/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pigunit.pig;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.PigServer;

public class GruntParser
extends org.apache.pig.tools.grunt.GruntParser {
    private final Map<String, String> aliasOverride;

    public GruntParser(Reader stream, Map<String, String> aliasOverride) {
        this(stream, null, aliasOverride);
    }

    public GruntParser(Reader stream, org.apache.pig.pigunit.pig.PigServer pigServer, Map<String, String> aliasOverride) {
        super(stream, (PigServer)pigServer);
        this.aliasOverride = aliasOverride;
    }

    protected void processPig(String cmd) throws IOException {
        String command = this.override(cmd);
        if (!command.equals("")) {
            super.processPig(command);
        }
    }

    public String override(String query) {
        String fsRoot = System.getProperty("pigunit.filesystem.prefix");
        if (fsRoot != null) {
            query = Pattern.compile("(LOAD\\s+'(([^:/?#]+)://)?)", 2).matcher(query).replaceFirst("$1" + fsRoot);
            query = Pattern.compile("(STORE\\s+([^']+)\\s+INTO\\s+'(([^:/?#]+)://)?)", 2).matcher(query).replaceFirst("$1" + fsRoot);
        }
        HashMap<String, String> metaData = new HashMap<String, String>();
        for (Map.Entry<String, String> alias : this.aliasOverride.entrySet()) {
            this.saveLastStoreAlias(query, metaData);
            if (!query.toLowerCase().startsWith(alias.getKey().toLowerCase() + " ")) continue;
            System.out.println(String.format("%s\n--> %s", query, alias.getValue() == "" ? "none" : alias.getValue()));
            query = alias.getValue();
        }
        this.aliasOverride.putAll(metaData);
        return query;
    }

    void saveLastStoreAlias(String cmd, Map<String, String> metaData) {
        Pattern outputFile;
        Matcher matcher;
        if (cmd.toUpperCase().startsWith("STORE") && (matcher = (outputFile = Pattern.compile("STORE +([^']+) INTO.*", 2)).matcher(cmd)).matches()) {
            metaData.put("LAST_STORE_ALIAS", matcher.group(1));
        }
    }
}

