/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pigunit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pig.ExecType;
import org.apache.pig.ExecTypeProvider;
import org.apache.pig.PigException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.pigunit.Cluster;
import org.apache.pig.pigunit.pig.PigServer;
import org.apache.pig.tools.parameters.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigTest {
    private final String originalTextPigScript;
    private final String[] args;
    private final String[] argFiles;
    private final Map<String, String> aliasOverrides;
    private static ThreadLocal<PigServer> pig = new ThreadLocal();
    private static ThreadLocal<Cluster> cluster = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(PigTest.class);
    private static final String EXEC_CLUSTER = "pigunit.exectype";

    PigTest(String[] args, String[] argFiles, String pigTextScript) {
        this.originalTextPigScript = pigTextScript;
        this.args = args;
        this.argFiles = argFiles;
        this.aliasOverrides = new HashMap<String, String>(){
            {
                this.put("STORE", "");
                this.put("DUMP", "");
            }
        };
    }

    public PigTest(String scriptPath) throws IOException {
        this(null, null, PigTest.readFile(scriptPath));
    }

    public PigTest(String[] script) {
        this(null, null, StringUtils.join((Object[])script, "\n"));
    }

    public PigTest(String scriptPath, String[] args) throws IOException {
        this(args, null, PigTest.readFile(scriptPath));
    }

    public PigTest(String[] script, String[] args) {
        this(args, null, StringUtils.join((Object[])script, "\n"));
    }

    public PigTest(String[] script, String[] args, String[] argsFile) {
        this(args, argsFile, StringUtils.join((Object[])script, "\n"));
    }

    public PigTest(String scriptPath, String[] args, String[] argFiles) throws IOException {
        this(args, argFiles, PigTest.readFile(scriptPath));
    }

    public PigTest(String scriptPath, String[] args, PigServer pig, Cluster cluster) throws IOException {
        this(args, null, PigTest.readFile(scriptPath));
        PigTest.pig.set(pig);
        PigTest.cluster.set(cluster);
    }

    public static Cluster getCluster() throws ExecException {
        try {
            if (cluster.get() == null) {
                ExecType execType = ExecType.LOCAL;
                if (System.getProperties().containsKey(EXEC_CLUSTER)) {
                    if (System.getProperties().getProperty(EXEC_CLUSTER).equalsIgnoreCase("mr")) {
                        LOG.info((Object)"Using mr cluster mode");
                        execType = ExecType.MAPREDUCE;
                    } else if (System.getProperties().getProperty(EXEC_CLUSTER).equalsIgnoreCase("tez")) {
                        LOG.info((Object)"Using tez cluster mode");
                        execType = ExecTypeProvider.fromString((String)"tez");
                    } else if (System.getProperties().getProperty(EXEC_CLUSTER).equalsIgnoreCase("tez_local")) {
                        LOG.info((Object)"Using tez local mode");
                        execType = ExecTypeProvider.fromString((String)"tez_local");
                    } else {
                        LOG.info((Object)"Using default local mode");
                    }
                } else {
                    LOG.info((Object)"Using default local mode");
                }
                pig.set(new PigServer(execType));
                cluster.set(new Cluster(pig.get().getPigContext()));
            }
        }
        catch (PigException e) {
            throw new ExecException((Throwable)e);
        }
        return cluster.get();
    }

    public static PigServer getPigServer() {
        return pig.get();
    }

    protected void registerScript() throws IOException, ParseException {
        PigTest.getCluster();
        BufferedReader reader = new BufferedReader(new StringReader(this.originalTextPigScript));
        PigContext context = PigTest.getPigServer().getPigContext();
        String substitutedPig = context.doParamSubstitution(reader, this.args == null ? null : Arrays.asList(this.args), this.argFiles == null ? null : Arrays.asList(this.argFiles));
        LOG.info((Object)substitutedPig);
        File f = File.createTempFile("tmp", "pigunit");
        PrintWriter pw = new PrintWriter(f);
        pw.println(substitutedPig);
        pw.close();
        String pigSubstitutedFile = f.getCanonicalPath();
        PigTest.getPigServer().registerScript(pigSubstitutedFile, this.aliasOverrides);
    }

    public void runScript() throws IOException, ParseException {
        this.registerScript();
    }

    public Iterator<Tuple> getAlias(String alias) throws IOException, ParseException {
        this.registerScript();
        return PigTest.getPigServer().openIterator(alias);
    }

    private Iterator<Tuple> getAliasFromCache(String alias) throws IOException, ParseException {
        return PigTest.getPigServer().openIterator(alias);
    }

    public Iterator<Tuple> getAlias() throws IOException, ParseException {
        this.registerScript();
        String alias = this.aliasOverrides.get("LAST_STORE_ALIAS");
        return this.getAliasFromCache(alias);
    }

    public void override(String alias, String query) {
        this.aliasOverrides.put(alias, query);
    }

    public void unoverride(String alias) {
        this.aliasOverrides.remove(alias);
    }

    public void assertOutput(String[] expected) throws IOException, ParseException {
        this.registerScript();
        String alias = this.aliasOverrides.get("LAST_STORE_ALIAS");
        this.assertEquals(StringUtils.join((Object[])expected, "\n"), StringUtils.join(this.getAliasFromCache(alias), "\n"));
    }

    public void assertOutput(String alias, String[] expected) throws IOException, ParseException {
        this.registerScript();
        this.assertEquals(StringUtils.join((Object[])expected, "\n"), StringUtils.join(this.getAliasFromCache(alias), "\n"));
    }

    public void assertOutput(File expected) throws IOException, ParseException {
        this.registerScript();
        String alias = this.aliasOverrides.get("LAST_STORE_ALIAS");
        this.assertEquals(PigTest.readFile(expected).replaceAll("\r\n", "\n"), StringUtils.join(this.getAliasFromCache(alias), "\n"));
    }

    public void assertOutput(String alias, File expected) throws IOException, ParseException {
        this.registerScript();
        this.assertEquals(PigTest.readFile(expected).replaceAll("\r\n", "\n"), StringUtils.join(this.getAliasFromCache(alias), "\n"));
    }

    public void assertOutput(String aliasInput, String[] input, String alias, String[] expected) throws IOException, ParseException {
        this.assertOutput(aliasInput, input, alias, expected, "\\t");
    }

    public void assertOutput(String aliasInput, String[] input, String alias, String[] expected, String delimiter) throws IOException, ParseException {
        this.registerScript();
        StringBuilder sb = new StringBuilder();
        Schema.stringifySchema((StringBuilder)sb, (Schema)PigTest.getPigServer().dumpSchema(aliasInput), (byte)110);
        String destination = FileLocalizer.getTemporaryPath((PigContext)PigTest.getPigServer().getPigContext()).toString();
        PigTest.getCluster().copyFromLocalFile(input, destination, true);
        this.override(aliasInput, String.format("%s = LOAD '%s' USING PigStorage('%s') AS %s;", aliasInput, destination, delimiter, sb.toString()));
        this.assertOutput(alias, expected);
    }

    protected void assertEquals(String expected, String current) {
        Assert.assertEquals((String)expected, (String)current);
    }

    private static String readFile(String path) throws IOException {
        return PigTest.readFile(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }
}

