/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pigunit.pig;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GruntParser
extends org.apache.pig.tools.grunt.GruntParser {
    private final Map<String, String> aliasOverride;

    public GruntParser(Reader stream, Map<String, String> aliasOverride) {
        super(stream);
        this.aliasOverride = aliasOverride;
    }

    protected void processPig(String cmd) throws IOException {
        String command = this.override(cmd);
        if (!command.equals("")) {
            super.processPig(command);
        }
    }

    public String override(String query) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        for (Map.Entry<String, String> alias : this.aliasOverride.entrySet()) {
            this.saveLastStoreAlias(query, metaData);
            if (!query.toLowerCase().startsWith(alias.getKey().toLowerCase() + " ")) continue;
            System.out.println(String.format("%s\n--> %s", query, alias.getValue() == "" ? "none" : alias.getValue()));
            query = alias.getValue();
        }
        this.aliasOverride.putAll(metaData);
        return query;
    }

    void saveLastStoreAlias(String cmd, Map<String, String> metaData) {
        Pattern outputFile;
        Matcher matcher;
        if (cmd.toUpperCase().startsWith("STORE") && (matcher = (outputFile = Pattern.compile("STORE +([^']+) INTO.*", 2)).matcher(cmd)).matches()) {
            metaData.put("LAST_STORE_ALIAS", matcher.group(1));
        }
    }
}

