/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.pigunit.pig;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.pig.pigunit.pig.GruntParser;
import org.apache.pig.pigunit.pig.PigServer;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestGruntParser {
    private GruntParser parser;
    private Map<String, String> override;

    @Before
    public void setUp() throws Exception {
        this.override = new HashMap<String, String>(){
            {
                this.put("STORE", "");
                this.put("DUMP", "");
            }
        };
        PigServer pigServer = new PigServer(Util.getLocalTestMode());
        this.parser = new GruntParser((Reader)new StringReader(""), pigServer, this.override);
    }

    @Test
    public void testRemoveStores() throws IOException {
        Assert.assertEquals((String)"", (String)this.parser.override("STORE output INTO '/path';"));
        this.override.remove("STORE");
        Assert.assertEquals((String)"STORE output INTO '/path';", (String)this.parser.override("STORE output INTO '/path';"));
    }

    @Test
    public void testRemoveDumps() throws IOException {
        Assert.assertEquals((String)"", (String)this.parser.override("DUMP output;"));
        this.override.remove("DUMP");
        Assert.assertEquals((String)"DUMP output;", (String)this.parser.override("DUMP output;"));
    }

    @Test
    public void testReplaceLoad() throws IOException {
        this.override.put("A", "A = LOAD 'file';");
        Assert.assertEquals((String)"A = LOAD 'file';", (String)this.parser.override("A = LOAD 'input.txt' AS (query:CHARARRAY);"));
    }

    @Test
    public void testGetStoreAlias() throws IOException {
        this.override.remove("STORE");
        this.parser.override("STORE output INTO '/path'");
        Assert.assertEquals((String)"output", (String)this.override.get("LAST_STORE_ALIAS"));
    }

    @Test
    public void testChangeRootDirectory() throws Exception {
        Assert.assertEquals((String)"A = LOAD 'input.txt';", (String)this.parser.override("A = LOAD 'input.txt';"));
        System.setProperty("pigunit.filesystem.prefix", "/tmp/pigunit/");
        Assert.assertEquals((String)"A = LOAD '/tmp/pigunit/input.txt';", (String)this.parser.override("A = LOAD 'input.txt';"));
        System.clearProperty("pigunit.filesystem.prefix");
        Assert.assertEquals((String)"A = LOAD 'input.txt';", (String)this.parser.override("A = LOAD 'input.txt';"));
    }
}

