/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test.pigunit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.pig.ExecType;
import org.apache.pig.pigunit.Cluster;
import org.apache.pig.pigunit.PigTest;
import org.apache.pig.pigunit.pig.PigServer;
import org.apache.pig.tools.parameters.ParseException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestPigTest {
    private PigTest test;
    private static Cluster cluster;
    private static final String PIG_SCRIPT = "test/data/pigunit/top_queries.pig";
    private static final String PIG_SCRIPT_MACRO = "test/data/pigunit/top_queries_macro.pig";
    private static final Log LOG;

    @BeforeClass
    public static void setUpOnce() throws IOException {
        cluster = PigTest.getCluster();
        cluster.update(new Path("test/data/pigunit/top_queries_input_data.txt"), new Path("top_queries_input_data.txt"));
    }

    @Test
    public void testNtoN() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput("queries_limit", output);
    }

    @Test
    public void testImplicitNtoN() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput(output);
    }

    @Test
    public void testTextInput() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        String[] input = new String[]{"yahoo\t10", "twitter\t7", "facebook\t10", "yahoo\t15", "facebook\t5", "a\t1", "b\t2", "c\t3", "d\t4", "e\t5"};
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput("data", input, "queries_limit", output);
    }

    @Test
    public void testDelimiter() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        String[] input = new String[]{"yahoo,10", "twitter,7", "facebook,10", "yahoo,15", "facebook,5", "a,1", "b,2", "c,3", "d,4", "e,5"};
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput("data", input, "queries_limit", output, ",");
    }

    @Test
    public void testSubset() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        String[] input = new String[]{"yahoo\t10", "twitter\t7", "facebook\t10", "yahoo\t15", "facebook\t5", "a\t1", "b\t2", "c\t3", "d\t4", "e\t5"};
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput("data", input, "queries_limit", output);
    }

    @Test
    public void testOverride() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        this.test.override("queries_limit", "queries_limit = LIMIT queries_ordered 2;");
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)"};
        this.test.assertOutput(output);
    }

    @Test
    public void testInlinePigScript() throws ParseException, IOException {
        String[] script = new String[]{"data = LOAD 'top_queries_input_data.txt' AS (query:CHARARRAY, count:INT);", "queries_group = GROUP data BY query PARALLEL 1;", "queries_sum = FOREACH queries_group GENERATE group AS query, SUM(data.count) AS count;", "queries_ordered = ORDER queries_sum BY count DESC PARALLEL 1;", "queries_limit = LIMIT queries_ordered 3;", "STORE queries_limit INTO 'top_3_queries';"};
        this.test = new PigTest(script);
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput(output);
    }

    @Test
    public void testFileOutput() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        this.test.assertOutput(new File("test/data/pigunit/top_queries_expected_top_3.txt"));
    }

    @Test
    public void testArgFiles() throws ParseException, IOException {
        String[] argsFile = new String[]{"test/data/pigunit/top_queries_params.txt"};
        this.test = new PigTest(PIG_SCRIPT, null, argsFile);
        this.test.assertOutput(new File("test/data/pigunit/top_queries_expected_top_3.txt"));
    }

    @Test
    public void testGetLastAlias() throws ParseException, IOException {
        String[] script = new String[]{"data = LOAD 'top_queries_input_data.txt' AS (query:CHARARRAY, count:INT);", "queries_group = GROUP data BY query PARALLEL 1;", "queries_sum = FOREACH queries_group GENERATE group AS query, SUM(data.count) AS count;", "queries_ordered = ORDER queries_sum BY count DESC PARALLEL 1;", "queries_limit = LIMIT queries_ordered 3;", "STORE queries_limit INTO 'top_3_queries';"};
        this.test = new PigTest(script);
        String expected = "(yahoo,25)\n(facebook,15)\n(twitter,7)";
        Assert.assertEquals((Object)expected, (Object)StringUtils.join((Iterator)this.test.getAlias("queries_limit"), (String)"\n"));
    }

    @Test
    public void testWithUdf() throws ParseException, IOException {
        String[] script = new String[]{"DEFINE TOKENIZE TOKENIZE();", "data = LOAD 'top_queries_input_data.txt' AS (query:CHARARRAY, count:INT);", "queries = FOREACH data GENERATE query, TOKENIZE(query) AS query_tokens;", "queries_ordered = ORDER queries BY query DESC PARALLEL 1;", "queries_limit = LIMIT queries_ordered 3;", "STORE queries_limit INTO 'top_3_queries';"};
        this.test = new PigTest(script);
        String[] output = new String[]{"(yahoo,{(yahoo)})", "(yahoo,{(yahoo)})", "(twitter,{(twitter)})"};
        this.test.assertOutput(output);
    }

    @Test
    public void testStore() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT, args);
        this.test.unoverride("STORE");
        this.test.runScript();
        Assert.assertTrue((boolean)cluster.delete(new Path("top_3_queries")));
    }

    @Test
    public void testMacro() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        this.test = new PigTest(PIG_SCRIPT_MACRO, args);
        this.test.unoverride("STORE");
        this.test.runScript();
        Assert.assertTrue((boolean)cluster.delete(new Path("top_3_queries")));
    }

    @Ignore(value="Not ready yet")
    @Test
    public void testWithMock() throws ParseException, IOException {
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        PigServer mockServer = null;
        Cluster mockCluster = null;
        this.test = new PigTest(PIG_SCRIPT, args, mockServer, mockCluster);
        this.test.assertOutput(new File("data/top_queries_expected_top_3.txt"));
    }

    @Test
    public void testDefaultBootup() throws ParseException, IOException {
        String pigProps = "pig.properties";
        String bootupPath = "/tmp/.temppigbootup";
        File propertyFile = new File(pigProps);
        PrintWriter out = new PrintWriter(new FileWriter(propertyFile));
        out.println("pig.load.default.statements=" + bootupPath);
        out.close();
        File bootupFile = new File(bootupPath);
        out = new PrintWriter(new FileWriter(bootupFile));
        out.println("data = LOAD 'top_queries_input_data.txt' AS (query:CHARARRAY, count:INT);");
        out.close();
        String[] script = new String[]{"queries_group = GROUP data BY query PARALLEL 1;", "queries_sum = FOREACH queries_group GENERATE group AS query, SUM(data.count) AS count;", "queries_ordered = ORDER queries_sum BY count DESC PARALLEL 1;", "queries_limit = LIMIT queries_ordered 3;", "STORE queries_limit INTO 'top_3_queries';"};
        String scriptPath = "/tmp/tempScript";
        File scriptFile = new File(scriptPath);
        out = new PrintWriter(new FileWriter(scriptFile));
        for (String line : script) {
            out.println(line);
        }
        out.close();
        String[] args = new String[]{"n=3", "reducers=1", "input=top_queries_input_data.txt", "output=top_3_queries"};
        PigServer pig = null;
        if (System.getProperties().containsKey("pigunit.exectype.cluster")) {
            LOG.info((Object)"Using cluster mode");
            pig = new PigServer(ExecType.MAPREDUCE);
        } else {
            LOG.info((Object)"Using default local mode");
            pig = new PigServer(ExecType.LOCAL);
        }
        Cluster cluster = new Cluster(pig.getPigContext());
        this.test = new PigTest(scriptPath, args, pig, cluster);
        String[] output = new String[]{"(yahoo,25)", "(facebook,15)", "(twitter,7)"};
        this.test.assertOutput("queries_limit", output);
        propertyFile.delete();
        scriptFile.delete();
        bootupFile.delete();
    }

    static {
        LOG = LogFactory.getLog(TestPigTest.class);
    }
}

