/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.avro.AvroStorageInputStream;
import org.apache.pig.piggybank.storage.avro.AvroStorageLog;
import org.apache.pig.piggybank.storage.avro.AvroStorageUtils;
import org.apache.pig.piggybank.storage.avro.PigAvroDatumReader;
import org.codehaus.jackson.JsonNode;

public class PigAvroRecordReader
extends RecordReader<NullWritable, Writable> {
    private static final Log LOG = LogFactory.getLog(PigAvroRecordReader.class);
    private AvroStorageInputStream in;
    private DataFileReader<Object> reader;
    private long start;
    private long end;
    private Path path;
    private boolean ignoreBadFiles;
    private TupleFactory tupleFactory = TupleFactory.getInstance();
    private ArrayList<Object> mProtoTuple;
    private boolean useMultipleSchemas = false;
    private Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap;

    public PigAvroRecordReader(TaskAttemptContext context, FileSplit split, Schema readerSchema, boolean ignoreBadFiles, Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap, boolean useMultipleSchemas) throws IOException {
        Schema writerSchema;
        this.path = split.getPath();
        this.in = new AvroStorageInputStream(this.path, context);
        this.useMultipleSchemas = useMultipleSchemas;
        if (readerSchema == null) {
            AvroStorageLog.details("No avro schema given; assuming the schema is embedded");
        }
        try {
            FileSystem fs = FileSystem.get((URI)this.path.toUri(), (Configuration)context.getConfiguration());
            writerSchema = AvroStorageUtils.getSchema(this.path, fs);
        }
        catch (IOException e) {
            AvroStorageLog.details("No avro writer schema found in '" + this.path + "'; assuming writer schema matches reader schema");
            writerSchema = null;
        }
        try {
            this.reader = useMultipleSchemas ? new DataFileReader((SeekableInput)this.in, (DatumReader)new PigAvroDatumReader(writerSchema, null)) : new DataFileReader((SeekableInput)this.in, (DatumReader)new PigAvroDatumReader(writerSchema, readerSchema));
        }
        catch (IOException e) {
            throw new IOException("Error initializing data file reader for file (" + split.getPath() + ")", e);
        }
        this.reader.sync(split.getStart());
        this.start = this.in.tell();
        this.end = split.getStart() + split.getLength();
        this.ignoreBadFiles = ignoreBadFiles;
        this.schemaToMergedSchemaMap = schemaToMergedSchemaMap;
        if (schemaToMergedSchemaMap != null) {
            int maxPos = 0;
            for (Map<Integer, Integer> map : schemaToMergedSchemaMap.values()) {
                for (Integer i : map.values()) {
                    maxPos = Math.max(i, maxPos);
                }
            }
            int tupleSize = maxPos + 1;
            AvroStorageLog.details("Creating proto tuple of fixed size: " + tupleSize);
            this.mProtoTuple = new ArrayList(tupleSize);
            for (int i = 0; i < tupleSize; ++i) {
                List subFields = readerSchema.getFields();
                JsonNode defValue = ((Schema.Field)subFields.get(i)).defaultValue();
                if (defValue != null) {
                    Schema.Type type = ((Schema.Field)subFields.get(i)).schema().getType();
                    if (type.equals((Object)Schema.Type.UNION)) {
                        List schemas = ((Schema.Field)subFields.get(i)).schema().getTypes();
                        for (Schema schema : schemas) {
                            if (schema.getType().equals((Object)Schema.Type.NULL)) continue;
                            type = schema.getType();
                            break;
                        }
                    }
                    switch (type) {
                        case BOOLEAN: {
                            this.mProtoTuple.add(i, defValue.getBooleanValue());
                            break;
                        }
                        case ENUM: {
                            this.mProtoTuple.add(i, defValue.getTextValue());
                            break;
                        }
                        case FIXED: {
                            this.mProtoTuple.add(i, defValue.getTextValue());
                            break;
                        }
                        case INT: {
                            this.mProtoTuple.add(i, defValue.getIntValue());
                            break;
                        }
                        case LONG: {
                            this.mProtoTuple.add(i, defValue.getIntValue());
                            break;
                        }
                        case FLOAT: {
                            this.mProtoTuple.add(i, Float.valueOf(defValue.getNumberValue().floatValue()));
                            break;
                        }
                        case DOUBLE: {
                            this.mProtoTuple.add(i, defValue.getNumberValue().doubleValue());
                            break;
                        }
                        case STRING: {
                            this.mProtoTuple.add(i, defValue.getTextValue());
                            break;
                        }
                        default: {
                            this.mProtoTuple.add(i, null);
                            break;
                        }
                    }
                    continue;
                }
                this.mProtoTuple.add(i, null);
            }
        }
    }

    public float getProgress() throws IOException {
        return this.end == this.start ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public Writable getCurrentValue() throws IOException, InterruptedException {
        try {
            Object obj = this.reader.next();
            Tuple result = null;
            if (obj instanceof Tuple) {
                AvroStorageLog.details("Class =" + obj.getClass());
                result = (Tuple)obj;
            } else {
                if (obj != null) {
                    AvroStorageLog.details("Wrap class " + obj.getClass() + " as a tuple.");
                } else {
                    AvroStorageLog.details("Wrap null as a tuple.");
                }
                result = this.wrapAsTuple(obj);
            }
            if (this.schemaToMergedSchemaMap != null) {
                Map<Integer, Integer> map = this.schemaToMergedSchemaMap.get(this.path);
                if (map == null) {
                    throw new IOException("The schema of '" + this.path + "' " + "is not merged by AvroStorage.");
                }
                result = this.remap(result, map);
            }
            return result;
        }
        catch (Exception e) {
            if (this.ignoreBadFiles) {
                LOG.warn((Object)("Ignoring bad record for '" + this.path + "'."));
                return null;
            }
            LOG.error((Object)("Bad record for '" + this.path + "'."));
            throw new IOException(e);
        }
    }

    private Tuple remap(Tuple tuple, Map<Integer, Integer> map) throws IOException {
        try {
            for (int pos = 0; pos < tuple.size(); ++pos) {
                this.mProtoTuple.set(map.get(pos), tuple.get(pos));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.tupleFactory.newTuple(this.mProtoTuple);
    }

    protected Tuple wrapAsTuple(Object in) {
        Tuple tuple = this.tupleFactory.newTuple();
        tuple.append(in);
        return tuple;
    }

    public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            return this.reader.hasNext() && !this.reader.pastSync(this.end);
        }
        catch (AvroRuntimeException e) {
            if (this.ignoreBadFiles) {
                LOG.warn((Object)("Ignoring bad file '" + this.path + "'."));
                return false;
            }
            throw e;
        }
    }
}

