/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.joda.time.DateTime;

public class DBStorage
extends StoreFunc {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PreparedStatement ps;
    private Connection con;
    private String jdbcURL;
    private String user;
    private String pass;
    private int batchSize;
    private int count = 0;
    private String insertQuery;
    protected ResourceSchema schema = null;
    private String udfcSignature = null;
    private static final String SCHEMA_SIGNATURE = "pig.dbstorage.schema";

    public DBStorage(String driver, String jdbcURL, String insertQuery) {
        this(driver, jdbcURL, null, null, insertQuery, "100");
    }

    public DBStorage(String driver, String jdbcURL, String user, String pass, String insertQuery) throws SQLException {
        this(driver, jdbcURL, user, pass, insertQuery, "100");
    }

    public DBStorage(String driver, String jdbcURL, String user, String pass, String insertQuery, String batchSize) throws RuntimeException {
        this.log.debug((Object)("DBStorage(" + driver + "," + jdbcURL + "," + user + ",XXXX," + insertQuery + ")"));
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("can't load DB driver:" + driver), (Throwable)e);
            throw new RuntimeException("Can't load DB Driver", e);
        }
        this.jdbcURL = jdbcURL;
        this.user = user;
        this.pass = pass;
        this.insertQuery = insertQuery;
        this.batchSize = Integer.parseInt(batchSize);
    }

    public void putNext(Tuple tuple) throws IOException {
        block22: {
            int sqlPos = 1;
            try {
                int size = tuple.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        Object field = tuple.get(i);
                        switch (DataType.findType((Object)field)) {
                            case 1: {
                                int nullSqlType = 12;
                                if (this.schema != null) {
                                    ResourceSchema.ResourceFieldSchema fs = this.schema.getFields()[i];
                                    nullSqlType = this.sqlDataTypeFromPigDataType(fs.getType());
                                }
                                this.ps.setNull(sqlPos, nullSqlType);
                                ++sqlPos;
                                break;
                            }
                            case 5: {
                                this.ps.setBoolean(sqlPos, (Boolean)field);
                                ++sqlPos;
                                break;
                            }
                            case 10: {
                                this.ps.setInt(sqlPos, (Integer)field);
                                ++sqlPos;
                                break;
                            }
                            case 15: {
                                this.ps.setLong(sqlPos, (Long)field);
                                ++sqlPos;
                                break;
                            }
                            case 20: {
                                this.ps.setFloat(sqlPos, ((Float)field).floatValue());
                                ++sqlPos;
                                break;
                            }
                            case 25: {
                                this.ps.setDouble(sqlPos, (Double)field);
                                ++sqlPos;
                                break;
                            }
                            case 30: {
                                this.ps.setDate(sqlPos, new Date(((DateTime)field).getMillis()));
                                ++sqlPos;
                                break;
                            }
                            case 50: {
                                byte[] b = ((DataByteArray)field).get();
                                this.ps.setBytes(sqlPos, b);
                                ++sqlPos;
                                break;
                            }
                            case 55: {
                                this.ps.setString(sqlPos, (String)field);
                                ++sqlPos;
                                break;
                            }
                            case 6: {
                                this.ps.setByte(sqlPos, (Byte)field);
                                ++sqlPos;
                                break;
                            }
                            case 100: 
                            case 110: 
                            case 120: {
                                throw new RuntimeException("Cannot store a non-flat tuple using DbStorage");
                            }
                            default: {
                                throw new RuntimeException("Unknown datatype " + DataType.findType((Object)field));
                            }
                        }
                        continue;
                    }
                    catch (ExecException ee) {
                        throw new RuntimeException(ee);
                    }
                }
                this.ps.addBatch();
                ++this.count;
                if (this.count > this.batchSize) {
                    this.count = 0;
                    this.ps.executeBatch();
                    this.ps.clearBatch();
                    this.ps.clearParameters();
                }
            }
            catch (SQLException e) {
                try {
                    this.log.error((Object)("Unable to insert record:" + tuple.toDelimitedString("\t")), (Throwable)e);
                }
                catch (ExecException ee) {
                    // empty catch block
                }
                if (e.getErrorCode() == 1366) break block22;
                throw new RuntimeException("JDBC error", e);
            }
        }
    }

    protected int sqlDataTypeFromPigDataType(byte pigDataType) {
        switch (pigDataType) {
            case 10: {
                return 4;
            }
            case 15: {
                return -5;
            }
            case 20: {
                return 6;
            }
            case 25: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 30: {
                return 91;
            }
            case 6: 
            case 50: 
            case 55: {
                return 12;
            }
        }
        this.log.warn((Object)("Can not find SQL data type for " + pigDataType + " returning VARCHAR"));
        return 12;
    }

    public OutputFormat getOutputFormat() throws IOException {
        return new MyDBOutputFormat();
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.ps = null;
        this.con = null;
        if (this.insertQuery == null) {
            throw new IOException("SQL Insert command not specified");
        }
        try {
            this.con = this.user == null || this.pass == null ? DriverManager.getConnection(this.jdbcURL) : DriverManager.getConnection(this.jdbcURL, this.user, this.pass);
            this.con.setAutoCommit(false);
            this.ps = this.con.prepareStatement(this.insertQuery);
        }
        catch (SQLException e) {
            this.log.error((Object)("Unable to connect to JDBC @" + this.jdbcURL));
            throw new IOException("JDBC Error", e);
        }
        this.count = 0;
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema != null) {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)strSchema));
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfcSignature = signature;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        p.setProperty(SCHEMA_SIGNATURE, s.toString());
    }

    class MyDBOutputFormat
    extends OutputFormat<NullWritable, NullWritable> {
        MyDBOutputFormat() {
        }

        public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new OutputCommitter(){

                public void abortTask(TaskAttemptContext context) throws IOException {
                    try {
                        if (DBStorage.this.ps != null) {
                            DBStorage.this.ps.close();
                        }
                        if (DBStorage.this.con != null) {
                            DBStorage.this.con.rollback();
                            DBStorage.this.con.close();
                        }
                    }
                    catch (SQLException sqe) {
                        throw new IOException(sqe);
                    }
                }

                public void commitTask(TaskAttemptContext context) throws IOException {
                    if (DBStorage.this.ps != null) {
                        try {
                            DBStorage.this.ps.executeBatch();
                            DBStorage.this.con.commit();
                            DBStorage.this.ps.close();
                            DBStorage.this.con.close();
                            DBStorage.this.ps = null;
                            DBStorage.this.con = null;
                        }
                        catch (SQLException e) {
                            DBStorage.this.log.error((Object)"ps.close", (Throwable)e);
                            throw new IOException("JDBC Error", e);
                        }
                    }
                }

                public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
                    return true;
                }

                public void cleanupJob(JobContext context) throws IOException {
                }

                public void setupJob(JobContext context) throws IOException {
                }

                public void setupTask(TaskAttemptContext context) throws IOException {
                }
            };
        }

        public RecordWriter<NullWritable, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new RecordWriter<NullWritable, NullWritable>(){

                public void close(TaskAttemptContext context) {
                }

                public void write(NullWritable k, NullWritable v) {
                }
            };
        }
    }
}

