/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.mapreduce;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.impl.PigContext;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.mapreduce.MRJobStats;
import org.apache.pig.tools.pigstats.mapreduce.MRScriptState;
import org.apache.pig.tools.pigstats.mapreduce.SimplePigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRPigStatsUtil
extends PigStatsUtil {
    public static final String TASK_COUNTER_GROUP = "org.apache.hadoop.mapred.Task$Counter";
    public static final String FS_COUNTER_GROUP = HadoopShims.getFsCounterGroupName();
    private static final Log LOG = LogFactory.getLog(MRPigStatsUtil.class);

    public static long getMultiStoreCount(Job job, JobClient jobClient, String counterName) {
        long value = -1L;
        try {
            RunningJob rj = jobClient.getJob(job.getAssignedJobID());
            if (rj != null) {
                Counters.Counter counter = rj.getCounters().getGroup("MultiStoreCounters").getCounterForName(counterName);
                value = counter.getValue();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to get the counter for " + counterName), (Throwable)e);
        }
        return value;
    }

    public static void startCollection(PigContext pc, JobClient client, JobControlCompiler jcc, MROperPlan plan) {
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        ps.initialize(pc, client, jcc, plan);
        MRScriptState.get().emitInitialPlanNotification(plan);
        MRScriptState.get().emitLaunchStartedNotification(plan.size());
    }

    public static void stopCollection(boolean display) {
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        ps.finish();
        if (!ps.isSuccessful()) {
            LOG.error((Object)(ps.getNumberFailedJobs() + " map reduce job(s) failed!"));
            String errMsg = ps.getErrorMessage();
            if (errMsg != null) {
                LOG.error((Object)("Error message: " + errMsg));
            }
        }
        MRScriptState.get().emitLaunchCompletedNotification(ps.getNumberSuccessfulJobs());
        if (display) {
            ps.display();
        }
    }

    public static JobStats addJobStats(Job job) {
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        return ps.addMRJobStats(job);
    }

    public static void displayStatistics() {
        ((SimplePigStats)PigStats.get()).display();
    }

    public static void updateJobMroMap(Map<Job, MapReduceOper> jobMroMap) {
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        for (Map.Entry<Job, MapReduceOper> entry : jobMroMap.entrySet()) {
            MapReduceOper mro = entry.getValue();
            ps.mapMROperToJob(mro, entry.getKey());
        }
    }

    public static void accumulateStats(JobControl jc) {
        MRJobStats js;
        SimplePigStats ps = (SimplePigStats)PigStats.get();
        MRScriptState ss = MRScriptState.get();
        for (Job job : jc.getSuccessfulJobs()) {
            js = MRPigStatsUtil.addSuccessJobStats(ps, job);
            if (js == null) continue;
            ss.emitjobFinishedNotification(js);
        }
        for (Job job : jc.getFailedJobs()) {
            js = MRPigStatsUtil.addFailedJobStats(ps, job);
            if (js == null) continue;
            js.setErrorMsg(job.getMessage());
            ss.emitJobFailedNotification(js);
        }
    }

    @InterfaceAudience.Private
    public static void setBackendException(Job job, Exception e) {
        JobID jobId = job.getAssignedJobID();
        if (jobId == null) {
            return;
        }
        PigStats.get().setBackendException(jobId.toString(), e);
    }

    private static MRJobStats addFailedJobStats(SimplePigStats ps, Job job) {
        if (ps.isJobSeen(job)) {
            return null;
        }
        MRJobStats js = ps.addMRJobStats(job);
        if (js == null) {
            LOG.warn((Object)"unable to add failed job stats");
        } else {
            js.setSuccessful(false);
            js.addOutputStatistics();
            js.addInputStatistics();
        }
        return js;
    }

    public static MRJobStats addNativeJobStats(PigStats ps, NativeMapReduceOper mr, boolean success) {
        return MRPigStatsUtil.addNativeJobStats(ps, mr, success, null);
    }

    public static MRJobStats addNativeJobStats(PigStats ps, NativeMapReduceOper mr, boolean success, Exception e) {
        if (ps.isEmbedded()) {
            throw new IllegalArgumentException();
        }
        MRJobStats js = ((SimplePigStats)ps).addMRJobStatsForNative(mr);
        if (js == null) {
            LOG.warn((Object)"unable to add native job stats");
        } else {
            js.setSuccessful(success);
            if (e != null) {
                js.setBackendException(e);
            }
        }
        return js;
    }

    private static MRJobStats addSuccessJobStats(SimplePigStats ps, Job job) {
        if (ps.isJobSeen(job)) {
            return null;
        }
        MRJobStats js = ps.addMRJobStats(job);
        if (js == null) {
            LOG.warn((Object)"unable to add job stats");
        } else {
            js.setSuccessful(true);
            js.addMapReduceStatistics(job);
            js.addCounters(job);
            js.addOutputStatistics();
            js.addInputStatistics();
        }
        return js;
    }
}

