/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.mapreduce;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.mapreduce.MRJobStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimplePigStats
extends PigStats {
    private static final Log LOG = LogFactory.getLog(SimplePigStats.class);
    private JobClient jobClient;
    private JobControlCompiler jcc;
    private Map<Job, MapReduceOper> jobMroMap;
    private Map<MapReduceOper, MRJobStats> mroJobMap;
    private Set<Job> jobSeen = new HashSet<Job>();

    @Override
    public List<String> getAllErrorMessages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<PigStats>> getAllStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public long getSMMSpillCount() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            ret += ((MRJobStats)it.next()).getSMMSpillCount();
        }
        return ret;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            ret += ((MRJobStats)it.next()).getProactiveSpillCountObjects();
        }
        return ret;
    }

    @Override
    public long getProactiveSpillCountRecords() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            ret += ((MRJobStats)it.next()).getProactiveSpillCountRecs();
        }
        return ret;
    }

    public SimplePigStats() {
        this.jobMroMap = new HashMap<Job, MapReduceOper>();
        this.jobPlan = new PigStats.JobGraph();
    }

    void initialize(PigContext pigContext, JobClient jobClient, JobControlCompiler jcc, MROperPlan mrPlan) {
        super.start();
        if (pigContext == null || jobClient == null || jcc == null) {
            LOG.warn((Object)("invalid params: " + pigContext + jobClient + jcc));
            return;
        }
        this.pigContext = pigContext;
        this.jobClient = jobClient;
        this.jcc = jcc;
        try {
            new JobGraphBuilder(mrPlan).visit();
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to build job plan", (Throwable)e);
        }
    }

    void finish() {
        super.stop();
    }

    boolean isInitialized() {
        return this.startTime > 0L;
    }

    @Override
    @Deprecated
    public JobClient getJobClient() {
        return this.jobClient;
    }

    JobControlCompiler getJobControlCompiler() {
        return this.jcc;
    }

    MRJobStats addMRJobStats(Job job) {
        MapReduceOper mro = this.jobMroMap.get(job);
        if (mro == null) {
            LOG.warn((Object)("unable to get MR oper for job: " + job.toString()));
            return null;
        }
        MRJobStats js = this.mroJobMap.get(mro);
        JobID jobId = job.getAssignedJobID();
        js.setId(jobId);
        js.setAlias(mro);
        js.setConf((Configuration)job.getJobConf());
        return js;
    }

    MRJobStats addMRJobStatsForNative(NativeMapReduceOper mr) {
        MRJobStats js = this.mroJobMap.get(mr);
        js.setId(new JobID(mr.getJobId(), NativeMapReduceOper.getJobNumber()));
        js.setAlias(mr);
        return js;
    }

    void display() {
        List<JobStats> arr;
        if (this.returnCode == -1) {
            LOG.warn((Object)"unknown return code, can't display the results");
            return;
        }
        if (this.pigContext == null) {
            LOG.warn((Object)"unknown exec type, don't display the results");
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append("\nHadoopVersion\tPigVersion\tUserId\tStartedAt\tFinishedAt\tFeatures\n");
        sb.append(this.getHadoopVersion()).append("\t").append(this.getPigVersion()).append("\t").append(this.userId).append("\t").append(sdf.format(new Date(this.startTime))).append("\t").append(sdf.format(new Date(this.endTime))).append("\t").append(this.getFeatures()).append("\n");
        sb.append("\n");
        if (this.returnCode == 0) {
            sb.append("Success!\n");
        } else if (this.returnCode == 3) {
            sb.append("Some jobs have failed! Stop running all dependent jobs\n");
        } else {
            sb.append("Failed!\n");
        }
        sb.append("\n");
        if (this.returnCode == 0 || this.returnCode == 3) {
            sb.append("Job Stats (time in seconds):\n");
            sb.append("JobId\tMaps\tReduces\tMaxMapTime\tMinMapTIme\tAvgMapTime\tMedianMapTime\tMaxReduceTime\tMinReduceTime\tAvgReduceTime\tMedianReducetime\tAlias\tFeature\tOutputs").append("\n");
            arr = this.jobPlan.getSuccessfulJobs();
            for (JobStats js : arr) {
                sb.append(js.getDisplayString());
            }
            sb.append("\n");
        }
        if (this.returnCode == 2 || this.returnCode == 3) {
            sb.append("Failed Jobs:\n");
            sb.append("JobId\tAlias\tFeature\tMessage\tOutputs").append("\n");
            arr = this.jobPlan.getFailedJobs();
            for (JobStats js : arr) {
                sb.append(js.getDisplayString());
            }
            sb.append("\n");
        }
        sb.append("Input(s):\n");
        for (InputStats is : this.getInputStats()) {
            sb.append(is.getDisplayString());
        }
        sb.append("\n");
        sb.append("Output(s):\n");
        for (OutputStats ds : this.getOutputStats()) {
            sb.append(ds.getDisplayString());
        }
        sb.append("\nCounters:\n");
        sb.append("Total records written : " + this.getRecordWritten()).append("\n");
        sb.append("Total bytes written : " + this.getBytesWritten()).append("\n");
        sb.append("Spillable Memory Manager spill count : " + this.getSMMSpillCount()).append("\n");
        sb.append("Total bags proactively spilled: " + this.getProactiveSpillCountObjects()).append("\n");
        sb.append("Total records proactively spilled: " + this.getProactiveSpillCountRecords()).append("\n");
        sb.append("\nJob DAG:\n").append(this.jobPlan.toString());
        LOG.info((Object)("Script Statistics: \n" + sb.toString()));
    }

    void mapMROperToJob(MapReduceOper mro, Job job) {
        if (mro == null) {
            LOG.warn((Object)"null MR operator");
        } else {
            MRJobStats js = this.mroJobMap.get(mro);
            if (js == null) {
                LOG.warn((Object)("null job stats for mro: " + mro.getOperatorKey()));
            } else {
                this.jobMroMap.put(job, mro);
            }
        }
    }

    boolean isJobSeen(Job job) {
        return !this.jobSeen.add(job);
    }

    private class JobGraphBuilder
    extends MROpPlanVisitor {
        public JobGraphBuilder(MROperPlan plan) {
            super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DependencyOrderWalker<MapReduceOper, MROperPlan>(plan));
            SimplePigStats.this.jobPlan = new PigStats.JobGraph();
            SimplePigStats.this.mroJobMap = new HashMap();
        }

        public void visitMROp(MapReduceOper mr) throws VisitorException {
            MRJobStats js = new MRJobStats(mr.getOperatorKey().toString(), SimplePigStats.this.jobPlan);
            SimplePigStats.this.jobPlan.add(js);
            List<MapReduceOper> preds = ((MROperPlan)this.getPlan()).getPredecessors(mr);
            if (preds != null) {
                for (MapReduceOper pred : preds) {
                    MRJobStats jpred = (MRJobStats)SimplePigStats.this.mroJobMap.get(pred);
                    if (SimplePigStats.this.jobPlan.isConnected(jpred, js)) continue;
                    SimplePigStats.this.jobPlan.connect(jpred, js);
                }
            }
            SimplePigStats.this.mroJobMap.put(mr, js);
        }
    }
}

