/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.HashMap;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOSplitOutput
extends LogicalRelationalOperator {
    private LogicalExpressionPlan filterPlan;
    private Map<Long, Long> uidMapping = new HashMap<Long, Long>();

    public LOSplitOutput(LogicalPlan plan) {
        super("LOSplitOutput", plan);
    }

    public LOSplitOutput(LogicalPlan plan, LogicalExpressionPlan filterPlan) {
        super("LOSplitOutput", plan);
        this.filterPlan = filterPlan;
    }

    public LogicalExpressionPlan getFilterPlan() {
        return this.filterPlan;
    }

    public void setFilterPlan(LogicalExpressionPlan filterPlan) {
        this.filterPlan = filterPlan;
    }

    private void reassignUidRec(LogicalSchema schema) {
        for (LogicalSchema.LogicalFieldSchema fs : schema.getFields()) {
            if (fs.schema != null && (fs.type == 110 || fs.type == 120 || fs.type == 100)) {
                this.reassignUidRec(fs.schema);
            }
            if (this.uidMapping.containsKey(fs.uid)) {
                fs.uid = this.uidMapping.get(fs.uid);
                continue;
            }
            long predUid = fs.uid;
            fs.uid = LogicalExpression.getNextUid();
            this.uidMapping.put(predUid, fs.uid);
        }
    }

    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        LogicalRelationalOperator input = null;
        input = (LogicalRelationalOperator)this.plan.getPredecessors(this).get(0);
        if (input.getSchema() != null) {
            this.schema = input.getSchema().deepCopy();
            this.reassignUidRec(this.schema);
        }
        return this.schema;
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOSplitOutput) {
            LOSplitOutput os = (LOSplitOutput)other;
            return this.filterPlan.isEqual(os.filterPlan) && this.checkEquality(os);
        }
        return false;
    }

    public void resetUid() {
        this.uidMapping = new HashMap<Long, Long>();
    }

    public long getInputUids(long uid) {
        for (Map.Entry<Long, Long> pair : this.uidMapping.entrySet()) {
            if (pair.getValue() != uid) continue;
            return pair.getKey();
        }
        return -1L;
    }
}

