/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SchemaTuple;
import org.apache.pig.data.SizeUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.data.utils.SedesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class AppendableSchemaTuple<T extends AppendableSchemaTuple<T>>
extends SchemaTuple<T> {
    private static final long serialVersionUID = 1L;
    private Tuple appendedFields;
    private static final TupleFactory mTupleFactory = TupleFactory.getInstance();

    @Override
    public void append(Object val) {
        if (this.appendedFields == null) {
            this.appendedFields = mTupleFactory.newTuple();
        }
        this.appendedFields.append(val);
    }

    protected int appendedFieldsSize() {
        return this.appendedFields == null ? 0 : this.appendedFields.size();
    }

    protected boolean isAppendedFieldsNull() {
        return this.appendedFieldsSize() == 0;
    }

    protected Object getAppendedField(int i) throws ExecException {
        return this.isAppendedFieldNull(i) ? null : this.appendedFields.get(i);
    }

    private boolean isAppendedFieldNull(int i) throws ExecException {
        return this.isAppendedFieldsNull() || this.appendedFields.isNull(i);
    }

    public Tuple getAppendedFields() {
        return this.appendedFields;
    }

    protected void setAppendedFields(Tuple t) {
        this.appendedFields = t;
    }

    private void resetAppendedFields() {
        this.appendedFields = null;
    }

    private void setAppendedField(int fieldNum, Object val) throws ExecException {
        this.appendedFields.set(fieldNum, val);
    }

    @Override
    public long getMemorySize() {
        return SizeUtil.roundToEight(this.appendedFields.getMemorySize()) + super.getMemorySize();
    }

    private byte getAppendedFieldType(int i) throws ExecException {
        return this.appendedFields == null ? (byte)0 : this.appendedFields.getType(i);
    }

    @Override
    protected SchemaTuple<T> set(SchemaTuple<?> t, boolean checkType) throws ExecException {
        this.resetAppendedFields();
        for (int j = this.schemaSize(); j < t.size(); ++j) {
            this.append(t.get(j));
        }
        return super.set(t, checkType);
    }

    @Override
    protected SchemaTuple<T> setSpecific(T t) {
        this.resetAppendedFields();
        this.setAppendedFields(((AppendableSchemaTuple)t).getAppendedFields());
        return super.setSpecific(t);
    }

    @Override
    public SchemaTuple<T> set(List<Object> l) throws ExecException {
        int schemaSize;
        int listSize = l.size();
        if (listSize < (schemaSize = this.schemaSize())) {
            throw new ExecException("Given list of objects has too few fields (" + l.size() + " vs " + this.schemaSize() + ")");
        }
        Iterator<Object> it = l.iterator();
        this.generatedCodeSetIterator(it);
        this.resetAppendedFields();
        while (it.hasNext()) {
            this.append(it.next());
        }
        return this;
    }

    @Override
    protected int compareTo(SchemaTuple<?> t, boolean checkType) {
        if (checkType && this.getClass() == t.getClass()) {
            return this.compareToSpecific((T)((AppendableSchemaTuple)t));
        }
        int i = super.compareTo(t, false);
        if (i != 0) {
            return i;
        }
        if (this.appendedFieldsSize() > 0) {
            int m = this.schemaSize();
            for (int k = 0; k < this.size() - this.schemaSize(); ++k) {
                try {
                    i = DataType.compare(this.getAppendedField(k), t.get(m++));
                }
                catch (ExecException e) {
                    throw new RuntimeException("Unable to get append value", e);
                }
                if (i == 0) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    protected int compareToSpecific(T t) {
        int i = this.compareSize((Tuple)t);
        if (i != 0) {
            return i;
        }
        i = super.compareToSpecific(t);
        if (i != 0) {
            return i;
        }
        for (int z = 0; z < this.appendedFieldsSize(); ++z) {
            try {
                i = DataType.compare(this.getAppendedField(z), ((AppendableSchemaTuple)t).getAppendedField(z));
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to get append", e);
            }
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.appendedFields == null) {
            return hash;
        }
        for (Object o : this.appendedFields) {
            if (o == null) continue;
            hash = 31 * hash + o.hashCode();
        }
        return hash;
    }

    @Override
    public void set(int fieldNum, Object val) throws ExecException {
        int diff = fieldNum - this.schemaSize();
        if (diff >= 0 && diff < this.appendedFieldsSize()) {
            this.setAppendedField(diff, val);
        } else {
            super.set(fieldNum, val);
        }
    }

    @Override
    public Object get(int fieldNum) throws ExecException {
        int diff = fieldNum - this.schemaSize();
        if (diff >= 0 && diff < this.appendedFieldsSize()) {
            return this.getAppendedField(diff);
        }
        return super.get(fieldNum);
    }

    @Override
    public boolean isNull(int fieldNum) throws ExecException {
        int diff = fieldNum - this.schemaSize();
        if (diff >= 0 && diff < this.appendedFieldsSize()) {
            return this.isAppendedFieldNull(diff);
        }
        return super.isNull(fieldNum);
    }

    @Override
    public byte getType(int fieldNum) throws ExecException {
        int diff = fieldNum - this.schemaSize();
        if (diff >= 0 && diff < this.appendedFieldsSize()) {
            return this.getAppendedFieldType(diff);
        }
        return super.getType(fieldNum);
    }

    @Override
    protected void setTypeAwareBase(int fieldNum, Object val, String type) throws ExecException {
        int diff = fieldNum - this.schemaSize();
        if (diff >= 0 && diff < this.appendedFieldsSize()) {
            this.setAppendedField(diff, val);
        } else {
            super.setTypeAwareBase(fieldNum, val, type);
        }
    }

    @Override
    protected Object getTypeAwareBase(int fieldNum, String type) throws ExecException {
        int diff = fieldNum - this.schemaSize();
        if (diff >= 0 && diff < this.appendedFieldsSize()) {
            return this.getAppendedField(diff);
        }
        return super.getTypeAwareBase(fieldNum, type);
    }

    @Override
    protected void writeElements(DataOutput out) throws IOException {
        boolean[] b = this.generatedCodeNullsArray();
        SedesHelper.writeBooleanArray(out, b, this.isAppendedFieldsNull());
        this.generatedCodeWriteElements(out);
        if (!this.isAppendedFieldsNull()) {
            SedesHelper.writeGenericTuple(out, this.getAppendedFields());
        }
    }

    @Override
    public int size() {
        return super.size() + this.appendedFieldsSize();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = this.schemaSize() + 1;
        boolean[] b = SedesHelper.readBooleanArray(in, len);
        this.generatedCodeReadFields(in, b);
        if (!b[len - 1]) {
            this.setAppendedFields(SedesHelper.readGenericTuple(in, in.readByte()));
        }
    }
}

