/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.shims;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DowngradeHelper;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ContextFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop23.PigJobControl;

public class HadoopShims {
    private static Log LOG = LogFactory.getLog(HadoopShims.class);
    private static Method getFileSystemClass;

    public static JobContext cloneJobContext(JobContext original) throws IOException, InterruptedException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.apache.hadoop.mapreduce.ContextFactory");
        }
        catch (ClassNotFoundException e) {
            JobContextImpl newContext = new JobContextImpl(original.getConfiguration(), original.getJobID());
            return newContext;
        }
        JobContext newContext = ContextFactory.cloneContext((JobContext)original, (Configuration)new JobConf(original.getConfiguration()));
        return newContext;
    }

    public static TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
        if (conf instanceof JobConf) {
            return new TaskAttemptContextImpl((Configuration)new JobConf(conf), taskId);
        }
        return new TaskAttemptContextImpl(conf, taskId);
    }

    public static JobContext createJobContext(Configuration conf, JobID jobId) {
        if (conf instanceof JobConf) {
            return new JobContextImpl((Configuration)new JobConf(conf), jobId);
        }
        return new JobContextImpl(conf, jobId);
    }

    public static boolean isMap(TaskAttemptID taskAttemptID) {
        TaskType type = taskAttemptID.getTaskType();
        return type == TaskType.MAP;
    }

    public static TaskAttemptID getNewTaskAttemptID() {
        TaskAttemptID taskAttemptID = new TaskAttemptID("", 1, TaskType.MAP, 1, 1);
        return taskAttemptID;
    }

    public static TaskAttemptID createTaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int id) {
        if (isMap) {
            return new TaskAttemptID(jtIdentifier, jobId, TaskType.MAP, taskId, id);
        }
        return new TaskAttemptID(jtIdentifier, jobId, TaskType.REDUCE, taskId, id);
    }

    public static void storeSchemaForLocal(org.apache.hadoop.mapred.jobcontrol.Job job, POStore st) {
    }

    public static String getFsCounterGroupName() {
        return "org.apache.hadoop.mapreduce.FileSystemCounter";
    }

    public static void commitOrCleanup(OutputCommitter oc, JobContext jc) throws IOException {
        oc.commitJob(jc);
    }

    public static JobControl newJobControl(String groupName, int timeToSleep) {
        return new PigJobControl(groupName, timeToSleep);
    }

    public static long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public static Counters getCounters(org.apache.hadoop.mapred.jobcontrol.Job job) throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.apache.hadoop.mapreduce.Cluster");
        }
        catch (ClassNotFoundException e) {
            return new Counters(job.getJob().getCounters());
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(Configuration.class);
            Cluster cluster = (Cluster)constructor.newInstance(job.getJobConf());
            Job mrJob = cluster.getJob((JobID)job.getAssignedJobID());
            if (mrJob == null) {
                mrJob = job.getJob();
            }
            return new Counters(mrJob.getCounters());
        }
        catch (Exception ir) {
            throw new IOException(ir);
        }
    }

    public static boolean isJobFailed(org.apache.hadoop.mapred.TaskReport report) {
        return report.getCurrentStatus() == TIPStatus.FAILED;
    }

    public static void unsetConf(Configuration conf, String key) {
        conf.unset(key);
    }

    public static void setTaskAttemptId(Configuration conf, TaskAttemptID taskAttemptID) {
        conf.setInt("mapreduce.job.application.attempt.id", taskAttemptID.getId());
    }

    public static boolean hasFileSystemImpl(Path path, Configuration conf) {
        String scheme = path.toUri().getScheme();
        if (scheme != null) {
            if (conf.get("fs.file.impl") != null) {
                String fsImpl = conf.get("fs." + scheme + ".impl");
                if (fsImpl == null) {
                    return false;
                }
            } else {
                if (getFileSystemClass == null) {
                    try {
                        getFileSystemClass = FileSystem.class.getDeclaredMethod("getFileSystemClass", String.class, Configuration.class);
                    }
                    catch (NoSuchMethodException e) {
                        LOG.warn((Object)("Error while trying to determine if path " + path + " has a filesystem implementation"));
                        return true;
                    }
                }
                try {
                    Object fs = getFileSystemClass.invoke(null, scheme, conf);
                    return fs != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static double progressOfRunningJob(org.apache.hadoop.mapred.jobcontrol.Job j) throws IOException {
        Job mrJob = j.getJob();
        try {
            return (mrJob.mapProgress() + mrJob.reduceProgress()) / 2.0f;
        }
        catch (Exception ir) {
            return 0.0;
        }
    }

    public static void killJob(org.apache.hadoop.mapred.jobcontrol.Job job) throws IOException {
        Job mrJob = job.getJob();
        try {
            if (mrJob != null) {
                mrJob.killJob();
            }
        }
        catch (Exception ir) {
            throw new IOException(ir);
        }
    }

    public static org.apache.hadoop.mapred.TaskReport[] getTaskReports(org.apache.hadoop.mapred.jobcontrol.Job job, TaskType type) throws IOException {
        Method m = null;
        try {
            m = Job.class.getMethod("getTaskReports", TaskType.class);
        }
        catch (NoSuchMethodException e) {
            JobClient jobClient = job.getJobClient();
            return type == TaskType.MAP ? jobClient.getMapTaskReports(job.getAssignedJobID()) : jobClient.getReduceTaskReports(job.getAssignedJobID());
        }
        try {
            Class<?> clazz = Class.forName("org.apache.hadoop.mapreduce.Cluster");
            Constructor<?> constructor = clazz.getConstructor(Configuration.class);
            Cluster cluster = (Cluster)constructor.newInstance(job.getJobConf());
            Job mrJob = cluster.getJob((JobID)job.getAssignedJobID());
            if (mrJob == null) {
                mrJob = job.getJob();
            }
            TaskReport[] reports = mrJob.getTaskReports(type);
            return DowngradeHelper.downgradeTaskReports(reports);
        }
        catch (Exception ir) {
            ir.printStackTrace();
            throw new IOException(ir);
        }
    }
}

