/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.mapreduce.MRPigStatsUtil;
import org.apache.pig.tools.pigstats.mapreduce.MRScriptState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class MRJobStats
extends JobStats {
    public static final String SUCCESS_HEADER = "JobId\tMaps\tReduces\tMaxMapTime\tMinMapTIme\tAvgMapTime\tMedianMapTime\tMaxReduceTime\tMinReduceTime\tAvgReduceTime\tMedianReducetime\tAlias\tFeature\tOutputs";
    public static final String FAILURE_HEADER = "JobId\tAlias\tFeature\tMessage\tOutputs";
    private static final Log LOG = LogFactory.getLog(MRJobStats.class);
    private List<POStore> mapStores = null;
    private List<POStore> reduceStores = null;
    private List<FileSpec> loads = null;
    private Boolean disableCounter = false;
    private JobID jobId;
    private long maxMapTime = 0L;
    private long minMapTime = 0L;
    private long avgMapTime = 0L;
    private long medianMapTime = 0L;
    private long maxReduceTime = 0L;
    private long minReduceTime = 0L;
    private long avgReduceTime = 0L;
    private long medianReduceTime = 0L;
    private int numberMaps = 0;
    private int numberReduces = 0;
    private long mapInputRecords = 0L;
    private long mapOutputRecords = 0L;
    private long reduceInputRecords = 0L;
    private long reduceOutputRecords = 0L;
    private long spillCount = 0L;
    private long activeSpillCountObj = 0L;
    private long activeSpillCountRecs = 0L;
    private HashMap<String, Long> multiStoreCounters = new HashMap();
    private HashMap<String, Long> multiInputCounters = new HashMap();
    private Counters counters = null;

    MRJobStats(String name, PigStats.JobGraph plan) {
        super(name, plan);
    }

    @Override
    public String getJobId() {
        return this.jobId == null ? null : this.jobId.toString();
    }

    @Override
    public int getNumberMaps() {
        return this.numberMaps;
    }

    @Override
    public int getNumberReduces() {
        return this.numberReduces;
    }

    @Override
    public long getMaxMapTime() {
        return this.maxMapTime;
    }

    @Override
    public long getMinMapTime() {
        return this.minMapTime;
    }

    @Override
    public long getAvgMapTime() {
        return this.avgMapTime;
    }

    @Override
    public long getMaxReduceTime() {
        return this.maxReduceTime;
    }

    @Override
    public long getMinReduceTime() {
        return this.minReduceTime;
    }

    @Override
    public long getAvgREduceTime() {
        return this.avgReduceTime;
    }

    @Override
    public long getMapInputRecords() {
        return this.mapInputRecords;
    }

    @Override
    public long getMapOutputRecords() {
        return this.mapOutputRecords;
    }

    @Override
    public long getReduceInputRecords() {
        return this.reduceInputRecords;
    }

    @Override
    public long getReduceOutputRecords() {
        return this.reduceOutputRecords;
    }

    @Override
    public long getSMMSpillCount() {
        return this.spillCount;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        return this.activeSpillCountObj;
    }

    @Override
    public long getProactiveSpillCountRecs() {
        return this.activeSpillCountRecs;
    }

    @Override
    public Counters getHadoopCounters() {
        return this.counters;
    }

    @Override
    public Map<String, Long> getMultiStoreCounters() {
        return Collections.unmodifiableMap(this.multiStoreCounters);
    }

    @Override
    public Map<String, Long> getMultiInputCounters() {
        return Collections.unmodifiableMap(this.multiInputCounters);
    }

    @Override
    public String getAlias() {
        return (String)this.getAnnotation("JobStatistics:alias");
    }

    @Override
    public String getAliasLocation() {
        return (String)this.getAnnotation("JobStatistics:alias_location");
    }

    @Override
    public String getFeature() {
        return (String)this.getAnnotation("JobStatistics:feature");
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (v instanceof PigStats.JobGraphPrinter) {
            PigStats.JobGraphPrinter jpp = (PigStats.JobGraphPrinter)v;
            jpp.visit(this);
        }
    }

    void setId(JobID jobId) {
        this.jobId = jobId;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            this.mapStores = (List)ObjectSerializer.deserialize(conf.get("pig.map.stores"));
            this.reduceStores = (List)ObjectSerializer.deserialize(conf.get("pig.reduce.stores"));
            this.loads = (ArrayList)ObjectSerializer.deserialize(conf.get("pig.inputs"));
            this.disableCounter = conf.getBoolean("pig.disable.counter", false);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to deserialize the store list", (Throwable)e);
        }
    }

    void setMapStat(int size, long max, long min, long avg, long median) {
        this.numberMaps = size;
        this.maxMapTime = max;
        this.minMapTime = min;
        this.avgMapTime = avg;
        this.medianMapTime = median;
    }

    void setReduceStat(int size, long max, long min, long avg, long median) {
        this.numberReduces = size;
        this.maxReduceTime = max;
        this.minReduceTime = min;
        this.avgReduceTime = avg;
        this.medianReduceTime = median;
    }

    private static void appendStat(long stat, StringBuilder sb) {
        if (stat != -1L) {
            sb.append(stat / 1000L);
        } else {
            sb.append("n/a");
        }
        sb.append("\t");
    }

    @Override
    public String getDisplayString() {
        String id;
        StringBuilder sb = new StringBuilder();
        String string = id = this.jobId == null ? "N/A" : this.jobId.toString();
        if (this.state == JobStats.JobState.FAILED) {
            sb.append(id).append("\t").append(this.getAlias()).append("\t").append(this.getFeature()).append("\t");
            if (this.state == JobStats.JobState.FAILED) {
                sb.append("Message: ").append(this.getErrorMessage()).append("\t");
            }
        } else if (this.state == JobStats.JobState.SUCCESS) {
            sb.append(id).append("\t").append(this.numberMaps).append("\t").append(this.numberReduces).append("\t");
            MRJobStats.appendStat(this.maxMapTime, sb);
            MRJobStats.appendStat(this.minMapTime, sb);
            MRJobStats.appendStat(this.avgMapTime, sb);
            MRJobStats.appendStat(this.medianMapTime, sb);
            MRJobStats.appendStat(this.maxReduceTime, sb);
            MRJobStats.appendStat(this.minReduceTime, sb);
            MRJobStats.appendStat(this.avgReduceTime, sb);
            MRJobStats.appendStat(this.medianReduceTime, sb);
            sb.append(this.getAlias()).append("\t").append(this.getFeature()).append("\t");
        }
        for (OutputStats os : this.outputs) {
            sb.append(os.getLocation()).append(",");
        }
        sb.append("\n");
        return sb.toString();
    }

    void addCounters(Job job) {
        try {
            this.counters = HadoopShims.getCounters(job);
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to get job counters", (Throwable)e);
        }
        if (this.counters != null) {
            Counters.Group taskgroup = this.counters.getGroup("org.apache.hadoop.mapred.Task$Counter");
            Counters.Group hdfsgroup = this.counters.getGroup(MRPigStatsUtil.FS_COUNTER_GROUP);
            Counters.Group multistoregroup = this.counters.getGroup("MultiStoreCounters");
            Counters.Group multiloadgroup = this.counters.getGroup("MultiInputCounters");
            this.mapInputRecords = taskgroup.getCounterForName("MAP_INPUT_RECORDS").getCounter();
            this.mapOutputRecords = taskgroup.getCounterForName("MAP_OUTPUT_RECORDS").getCounter();
            this.reduceInputRecords = taskgroup.getCounterForName("REDUCE_INPUT_RECORDS").getCounter();
            this.reduceOutputRecords = taskgroup.getCounterForName("REDUCE_OUTPUT_RECORDS").getCounter();
            this.hdfsBytesRead = hdfsgroup.getCounterForName("HDFS_BYTES_READ").getCounter();
            this.hdfsBytesWritten = hdfsgroup.getCounterForName("HDFS_BYTES_WRITTEN").getCounter();
            this.spillCount = this.counters.findCounter((Enum)PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT).getCounter();
            this.activeSpillCountObj = this.counters.findCounter((Enum)PigCounters.PROACTIVE_SPILL_COUNT_BAGS).getCounter();
            this.activeSpillCountRecs = this.counters.findCounter((Enum)PigCounters.PROACTIVE_SPILL_COUNT_RECS).getCounter();
            for (Counters.Counter cter : multistoregroup) {
                this.multiStoreCounters.put(cter.getName(), cter.getValue());
            }
            for (Counters.Counter cter : multiloadgroup) {
                this.multiInputCounters.put(cter.getName(), cter.getValue());
            }
        }
    }

    void addMapReduceStatistics(Job job) {
        TaskReport[] maps = null;
        try {
            maps = HadoopShims.getTaskReports(job, TaskType.MAP);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get map task report", (Throwable)e);
        }
        TaskReport[] reduces = null;
        try {
            reduces = HadoopShims.getTaskReports(job, TaskType.REDUCE);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get reduce task report", (Throwable)e);
        }
        this.addMapReduceStatistics(maps, reduces);
    }

    private TaskStat getTaskStat(TaskReport[] tasks) {
        int size = tasks.length;
        long max = 0L;
        long min = Long.MAX_VALUE;
        long median = 0L;
        long total = 0L;
        long[] durations = new long[size];
        for (int i = 0; i < tasks.length; ++i) {
            long duration;
            TaskReport rpt = tasks[i];
            durations[i] = duration = rpt.getFinishTime() - rpt.getStartTime();
            max = duration > max ? duration : max;
            min = duration < min ? duration : min;
            total += duration;
        }
        long avg = total / (long)size;
        median = this.calculateMedianValue(durations);
        return new TaskStat(size, max, min, avg, median);
    }

    private void addMapReduceStatistics(TaskReport[] maps, TaskReport[] reduces) {
        TaskStat st;
        if (maps != null && maps.length > 0) {
            st = this.getTaskStat(maps);
            this.setMapStat(st.size, st.max, st.min, st.avg, st.median);
        } else {
            int m = this.conf.getInt("mapred.map.tasks", 1);
            if (m > 0) {
                this.setMapStat(m, -1L, -1L, -1L, -1L);
            }
        }
        if (reduces != null && reduces.length > 0) {
            st = this.getTaskStat(reduces);
            this.setReduceStat(st.size, st.max, st.min, st.avg, st.median);
        } else {
            int m = this.conf.getInt("mapred.reduce.tasks", 1);
            if (m > 0) {
                this.setReduceStat(m, -1L, -1L, -1L, -1L);
            }
        }
    }

    void setAlias(MapReduceOper mro) {
        MRScriptState ss = MRScriptState.get();
        this.annotate("JobStatistics:alias", ss.getAlias(mro));
        this.annotate("JobStatistics:alias_location", ss.getAliasLocation(mro));
        this.annotate("JobStatistics:feature", ss.getPigFeature(mro));
    }

    void addOutputStatistics() {
        block4: {
            block3: {
                POStore sto;
                if (this.mapStores == null || this.reduceStores == null) {
                    LOG.warn((Object)"unable to get stores of the job");
                    return;
                }
                if (this.mapStores.size() + this.reduceStores.size() != 1) break block3;
                POStore pOStore = sto = this.mapStores.size() > 0 ? this.mapStores.get(0) : this.reduceStores.get(0);
                if (sto.isTmpStore()) break block4;
                long records = this.mapStores.size() > 0 ? this.mapOutputRecords : this.reduceOutputRecords;
                OutputStats ds = new OutputStats(sto.getSFile().getFileName(), this.hdfsBytesWritten, records, this.state == JobStats.JobState.SUCCESS);
                ds.setPOStore(sto);
                ds.setConf(this.conf);
                this.outputs.add(ds);
                if (this.state != JobStats.JobState.SUCCESS) break block4;
                MRScriptState.get().emitOutputCompletedNotification(ds);
                break block4;
            }
            for (POStore sto : this.mapStores) {
                if (sto.isTmpStore()) continue;
                this.addOneOutputStats(sto);
            }
            for (POStore sto : this.reduceStores) {
                if (sto.isTmpStore()) continue;
                this.addOneOutputStats(sto);
            }
        }
    }

    private void addOneOutputStats(POStore sto) {
        long records = -1L;
        if (sto.isMultiStore()) {
            Long n = this.multiStoreCounters.get(MRPigStatsUtil.getMultiStoreCounterName(sto));
            if (n != null) {
                records = n;
            }
        } else {
            records = this.mapOutputRecords;
        }
        long bytes = MRJobStats.getOutputSize(sto, this.conf);
        String location = sto.getSFile().getFileName();
        OutputStats ds = new OutputStats(location, bytes, records, this.state == JobStats.JobState.SUCCESS);
        ds.setPOStore(sto);
        ds.setConf(this.conf);
        this.outputs.add(ds);
        if (this.state == JobStats.JobState.SUCCESS) {
            MRScriptState.get().emitOutputCompletedNotification(ds);
        }
    }

    void addInputStatistics() {
        if (this.loads == null) {
            LOG.warn((Object)"unable to get inputs of the job");
            return;
        }
        if (this.loads.size() == 1) {
            FileSpec fsp = this.loads.get(0);
            if (!MRPigStatsUtil.isTempFile(fsp.getFileName())) {
                long records = this.mapInputRecords;
                InputStats is = new InputStats(fsp.getFileName(), this.hdfsBytesRead, records, this.state == JobStats.JobState.SUCCESS);
                is.setConf(this.conf);
                if (this.isSampler()) {
                    is.markSampleInput();
                }
                if (this.isIndexer()) {
                    is.markIndexerInput();
                }
                this.inputs.add(is);
            }
        } else {
            for (int i = 0; i < this.loads.size(); ++i) {
                FileSpec fsp = this.loads.get(i);
                if (MRPigStatsUtil.isTempFile(fsp.getFileName())) continue;
                this.addOneInputStats(fsp.getFileName(), i);
            }
        }
    }

    private void addOneInputStats(String fileName, int index) {
        long records = -1L;
        Long n = this.multiInputCounters.get(MRPigStatsUtil.getMultiInputsCounterName(fileName, index));
        if (n != null) {
            records = n;
        } else if (!this.disableCounter.booleanValue()) {
            records = 0L;
        } else {
            LOG.warn((Object)("unable to get input counter for " + fileName));
        }
        InputStats is = new InputStats(fileName, -1L, records, this.state == JobStats.JobState.SUCCESS);
        is.setConf(this.conf);
        this.inputs.add(is);
    }

    private class TaskStat {
        int size;
        long max;
        long min;
        long avg;
        long median;

        public TaskStat(int size, long max, long min, long avg, long median) {
            this.size = size;
            this.max = max;
            this.min = min;
            this.avg = avg;
            this.median = median;
        }
    }
}

