/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.parameters;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.pig.tools.parameters.ParamLoader;
import org.apache.pig.tools.parameters.ParameterSubstitutionException;
import org.apache.pig.tools.parameters.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessorContext {
    private Map<String, String> param_val;
    private Map<String, String> param_source;
    private final Log log = LogFactory.getLog(this.getClass());
    private Pattern bracketIdPattern = Pattern.compile("\\$\\{([_]*[a-zA-Z][a-zA-Z_0-9]*)\\}");
    private Pattern id_pattern = Pattern.compile("\\$([_]*[a-zA-Z][a-zA-Z_0-9]*)");

    public Map<String, String> getParamVal() {
        return this.param_val;
    }

    public PreprocessorContext(int limit) {
        this.param_val = new Hashtable<String, String>(limit);
        this.param_source = new Hashtable<String, String>(limit);
    }

    public PreprocessorContext(Map<String, String> paramVal) {
        this.param_val = paramVal;
        this.param_source = new Hashtable<String, String>(paramVal);
    }

    public void processShellCmd(String key, String val) throws ParameterSubstitutionException {
        this.processShellCmd(key, val, true);
    }

    public void processOrdLine(String key, String val) throws ParameterSubstitutionException {
        this.processOrdLine(key, val, true);
    }

    public void processShellCmd(String key, String val, Boolean overwrite) throws ParameterSubstitutionException {
        if (this.param_val.containsKey(key)) {
            if (this.param_source.get(key).equals(val) || !overwrite.booleanValue()) {
                return;
            }
            this.log.warn((Object)("Warning : Multiple values found for " + key + ". Using value " + val));
        }
        this.param_source.put(key, val);
        val = val.substring(1, val.length() - 1);
        String sub_val = this.substitute(val);
        sub_val = this.executeShellCommand(sub_val);
        this.param_val.put(key, sub_val);
    }

    public void processOrdLine(String key, String val, Boolean overwrite) throws ParameterSubstitutionException {
        if (this.param_val.containsKey(key)) {
            if (this.param_source.get(key).equals(val) || !overwrite.booleanValue()) {
                return;
            }
            this.log.warn((Object)("Warning : Multiple values found for " + key + ". Using value " + val));
        }
        this.param_source.put(key, val);
        String sub_val = this.substitute(val, key);
        this.param_val.put(key, sub_val);
    }

    private String executeShellCommand(String cmd) {
        int exitVal;
        RuntimeException rte;
        StringBuilder sb;
        String line;
        InputStreamReader isr;
        Process p;
        String streamData = "";
        String streamError = "";
        try {
            String[] cmdArgs;
            this.log.info((Object)("Executing command : " + cmd));
            StringBuffer sb2 = new StringBuffer("");
            if (Shell.WINDOWS) {
                cmd = cmd.replaceAll("/", "\\\\");
                sb2.append(cmd);
                cmdArgs = new String[]{"cmd", "/c", sb2.toString()};
            } else {
                sb2.append("exec ");
                sb2.append(cmd);
                cmdArgs = new String[]{"bash", "-c", sb2.toString()};
            }
            p = Runtime.getRuntime().exec(cmdArgs);
        }
        catch (IOException e) {
            RuntimeException rte2 = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte2;
        }
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(p.getInputStream());
            br = new BufferedReader(isr);
            line = null;
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            streamData = sb.toString();
        }
        catch (IOException e) {
            RuntimeException rte3 = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte3;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            isr = new InputStreamReader(p.getErrorStream());
            br = new BufferedReader(isr);
            line = null;
            sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            streamError = sb.toString();
            this.log.debug((Object)("Error stream while executing shell command : " + streamError));
        }
        catch (Exception e) {
            rte = new RuntimeException("IO Exception while executing shell command : " + e.getMessage(), e);
            throw rte;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            exitVal = p.waitFor();
        }
        catch (InterruptedException e) {
            RuntimeException rte4 = new RuntimeException("Interrupted Thread Exception while waiting for command to get over" + e.getMessage(), e);
            throw rte4;
        }
        if (exitVal != 0) {
            rte = new RuntimeException("Error executing shell command: " + cmd + ". Command exit with exit code of " + exitVal);
            throw rte;
        }
        return streamData.trim();
    }

    public void loadParamVal(List<String> params, List<String> paramFiles) throws IOException, ParseException {
        Reader dummyReader = null;
        ParamLoader paramLoader = new ParamLoader(dummyReader);
        paramLoader.setContext(this);
        if (paramFiles != null) {
            for (String path : paramFiles) {
                BufferedReader in = new BufferedReader(new FileReader(path));
                paramLoader.ReInit(in);
                while (paramLoader.Parse()) {
                }
                in.close();
            }
        }
        if (params != null) {
            for (String param : params) {
                paramLoader.ReInit(new StringReader(param));
                paramLoader.Parse();
            }
        }
    }

    public String substitute(String line) throws ParameterSubstitutionException {
        return this.substitute(line, null);
    }

    public String substitute(String line, String parentKey) throws ParameterSubstitutionException {
        int index = line.indexOf(36);
        if (index == -1) {
            return line;
        }
        String replaced_line = line;
        Matcher bracketKeyMatcher = this.bracketIdPattern.matcher(line);
        String key = "";
        String val = "";
        while (bracketKeyMatcher.find()) {
            if (bracketKeyMatcher.start() != 0 && line.charAt(bracketKeyMatcher.start() - 1) == '\\') continue;
            key = bracketKeyMatcher.group(1);
            if (!this.param_val.containsKey(key)) {
                String message = parentKey == null ? "Undefined parameter : " + key : "Undefined parameter : " + key + " found when trying to find the value of " + parentKey + ".";
                throw new ParameterSubstitutionException(message);
            }
            val = this.param_val.get(key);
            if (val.contains("$")) {
                val = val.replaceAll("(?<!\\\\)\\$", "\\\\\\$");
            }
            replaced_line = replaced_line.replaceFirst("\\$\\{" + key + "\\}", val);
        }
        Matcher keyMatcher = this.id_pattern.matcher(replaced_line);
        key = "";
        val = "";
        while (keyMatcher.find()) {
            if (keyMatcher.start() != 0 && line.charAt(keyMatcher.start() - 1) == '\\') continue;
            key = keyMatcher.group(1);
            if (!this.param_val.containsKey(key)) {
                String message = parentKey == null ? "Undefined parameter : " + key : "Undefined parameter : " + key + " found when trying to find the value of " + parentKey + ".";
                throw new ParameterSubstitutionException(message);
            }
            val = this.param_val.get(key);
            if (val.contains("$")) {
                val = val.replaceAll("(?<!\\\\)\\$", "\\\\\\$");
            }
            replaced_line = replaced_line.replaceFirst("\\$" + key, val);
        }
        replaced_line = replaced_line.replaceAll("\\\\\\$", "\\$");
        return replaced_line;
    }
}

