/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.accumulo;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.accumulo.AbstractAccumuloStorage;
import org.apache.pig.backend.hadoop.accumulo.Column;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccumuloStorage
extends AbstractAccumuloStorage {
    private static final Logger log = Logger.getLogger(AccumuloStorage.class);
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final Text EMPTY_TEXT = new Text(new byte[0]);
    private static final DataByteArray EMPTY_DATA_BYTE_ARRAY = new DataByteArray(new byte[0]);
    final Text _cfHolder = new Text();
    final Text _cqHolder = new Text();

    public AccumuloStorage() throws ParseException, IOException {
        this(EMPTY, EMPTY);
    }

    public AccumuloStorage(String columns) throws ParseException, IOException {
        this(columns, EMPTY);
    }

    public AccumuloStorage(String columnStr, String args) throws ParseException, IOException {
        super(columnStr, args);
    }

    @Override
    protected Tuple getTuple(Key key, Value value) throws IOException {
        SortedMap rowKVs = WholeRowIterator.decodeRow((Key)key, (Value)value);
        Tuple tuple = TupleFactory.getInstance().newTuple(this.columns.size() + 1);
        Text cfHolder = new Text();
        Text cqHolder = new Text();
        Text row = key.getRow();
        int tupleOffset = 0;
        tuple.set(tupleOffset, new DataByteArray(Text.decode((byte[])row.getBytes(), (int)0, (int)row.getLength())));
        block5: for (Column column : this.columns) {
            ++tupleOffset;
            switch (column.getType()) {
                case LITERAL: {
                    cfHolder.set(column.getColumnFamily());
                    if (null != column.getColumnQualifier()) {
                        cqHolder.set(column.getColumnQualifier());
                    } else {
                        cqHolder.set(EMPTY_TEXT);
                    }
                    Key literalStartKey = new Key(row, cfHolder, cqHolder);
                    SortedMap tailMap = rowKVs.tailMap(literalStartKey);
                    if (tailMap.isEmpty()) {
                        tuple.set(tupleOffset, EMPTY_DATA_BYTE_ARRAY);
                        break;
                    }
                    Key actualKey = tailMap.firstKey();
                    if (0 == literalStartKey.compareTo(actualKey, PartialKey.ROW_COLFAM_COLQUAL)) {
                        tuple.set(tupleOffset, new DataByteArray(((Value)tailMap.get(actualKey)).get()));
                        break;
                    }
                    tuple.set(tupleOffset, EMPTY_DATA_BYTE_ARRAY);
                    break;
                }
                case COLFAM_PREFIX: {
                    cfHolder.set(column.getColumnFamily());
                    Range colfamPrefixRange = Range.prefix((Text)row, (Text)cfHolder);
                    Key colfamPrefixStartKey = new Key(row, cfHolder);
                    SortedMap cfTailMap = rowKVs.tailMap(colfamPrefixStartKey);
                    if (cfTailMap.isEmpty()) {
                        tuple.set(tupleOffset, EMPTY_DATA_BYTE_ARRAY);
                        break;
                    }
                    HashMap<String, DataByteArray> tupleMap = new HashMap<String, DataByteArray>();
                    for (Map.Entry entry : cfTailMap.entrySet()) {
                        if (!colfamPrefixRange.contains(entry.getKey())) break;
                        entry.getKey().getColumnFamily(cfHolder);
                        entry.getKey().getColumnQualifier(cqHolder);
                        DataByteArray val = new DataByteArray(((Value)entry.getValue()).get());
                        if (0 == cqHolder.getLength()) {
                            tupleMap.put(cfHolder.toString(), val);
                            continue;
                        }
                        tupleMap.put(cfHolder.toString() + COLON + cqHolder.toString(), val);
                    }
                    if (tupleMap.isEmpty()) continue block5;
                    tuple.set(tupleOffset, tupleMap);
                    break;
                }
                case COLQUAL_PREFIX: {
                    cfHolder.set(column.getColumnFamily());
                    cqHolder.set(column.getColumnQualifier());
                    Range colqualPrefixRange = Range.prefix((Text)row, (Text)cfHolder, (Text)cqHolder);
                    Key colqualPrefixStartKey = new Key(row, cfHolder, cqHolder);
                    SortedMap cqTailMap = rowKVs.tailMap(colqualPrefixStartKey);
                    if (cqTailMap.isEmpty()) {
                        tuple.set(tupleOffset, EMPTY_DATA_BYTE_ARRAY);
                        break;
                    }
                    HashMap<String, DataByteArray> tupleMap = new HashMap<String, DataByteArray>();
                    for (Map.Entry entry : cqTailMap.entrySet()) {
                        if (!colqualPrefixRange.contains(entry.getKey())) break;
                        entry.getKey().getColumnFamily(cfHolder);
                        entry.getKey().getColumnQualifier(cqHolder);
                        DataByteArray val = new DataByteArray(((Value)entry.getValue()).get());
                        if (0 == cqHolder.getLength()) {
                            tupleMap.put(cfHolder.toString(), val);
                            continue;
                        }
                        tupleMap.put(cfHolder.toString() + COLON + cqHolder.toString(), val);
                    }
                    if (tupleMap.isEmpty()) continue block5;
                    tuple.set(tupleOffset, tupleMap);
                    break;
                }
            }
        }
        return tuple;
    }

    @Override
    protected void configureInputFormat(Job job) {
        AccumuloInputFormat.addIterator((Job)job, (IteratorSetting)new IteratorSetting(100, WholeRowIterator.class));
    }

    @Override
    protected Collection<Mutation> getMutations(Tuple tuple) throws ExecException, IOException {
        ResourceSchema.ResourceFieldSchema[] fieldSchemas = this.schema == null ? null : this.schema.getFields();
        Iterator tupleIter = tuple.iterator();
        if (1 >= tuple.size()) {
            log.debug((Object)("Ignoring tuple of size " + tuple.size()));
            return Collections.emptyList();
        }
        Mutation mutation = new Mutation(this.objectToText(tupleIter.next(), null == fieldSchemas ? null : fieldSchemas[0]));
        int tupleOffset = 1;
        Iterator columnIter = this.columns.iterator();
        block6: while (tupleIter.hasNext() && columnIter.hasNext()) {
            Object o = tupleIter.next();
            Column column = (Column)columnIter.next();
            byte type = this.schemaToType(o, null == fieldSchemas ? null : fieldSchemas[tupleOffset]);
            switch (column.getType()) {
                case LITERAL: {
                    byte[] bytes = this.objToBytes(o, type);
                    if (null == bytes) break;
                    Value value = new Value(bytes);
                    this.addColumn(mutation, column.getColumnFamily(), column.getColumnQualifier(), value);
                    break;
                }
                case COLFAM_PREFIX: 
                case COLQUAL_PREFIX: {
                    Map map;
                    try {
                        map = (Map)o;
                    }
                    catch (ClassCastException e) {
                        log.error((Object)("Expected Map at tuple offset " + tupleOffset + " but was " + o.getClass().getSimpleName()));
                        throw e;
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        Object objValue = entry.getValue();
                        byte valueType = DataType.findType(objValue);
                        byte[] mapValue = this.objToBytes(objValue, valueType);
                        if (Column.Type.COLFAM_PREFIX == column.getType()) {
                            this.addColumn(mutation, column.getColumnFamily() + key, null, new Value(mapValue));
                            continue;
                        }
                        if (Column.Type.COLQUAL_PREFIX == column.getType()) {
                            this.addColumn(mutation, column.getColumnFamily(), column.getColumnQualifier() + key, new Value(mapValue));
                            continue;
                        }
                        throw new IOException("Unknown column type");
                    }
                    break;
                }
                default: {
                    log.info((Object)"Ignoring unhandled column type");
                    continue block6;
                }
            }
            ++tupleOffset;
        }
        if (0 == mutation.size()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(mutation);
    }

    protected void addColumn(Mutation mutation, String colfam, String colqual, Value columnValue) {
        if (null != colfam) {
            this._cfHolder.set(colfam);
        } else {
            this._cfHolder.clear();
        }
        if (null != colqual) {
            this._cqHolder.set(colqual);
        } else {
            this._cqHolder.clear();
        }
        mutation.put(this._cfHolder, this._cqHolder, columnValue);
    }
}

