/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigException;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.HJob;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.PropertiesUtil;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.UriUtil;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ScalarExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalPlanData;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.QueryParserDriver;
import org.apache.pig.parser.QueryParserUtils;
import org.apache.pig.pen.ExampleGenerator;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigstats.EmptyPigStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.validator.BlackAndWhitelistFilter;
import org.apache.pig.validator.PigCommandFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public class PigServer {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String PRETTY_PRINT_SCHEMA_PROPERTY = "pig.pretty.print.schema";
    private static final String PIG_LOCATION_CHECK_STRICT = "pig.location.check.strict";
    protected final Deque<Graph> graphs = new LinkedList<Graph>();
    private Graph currDAG;
    protected final PigContext pigContext;
    private String jobName;
    private String jobPriority;
    private static final AtomicInteger scopeCounter = new AtomicInteger(0);
    protected final String scope = this.constructScope();
    private boolean validateEachStatement = false;
    private boolean skipParseInRegisterForBatch = false;
    private final BlackAndWhitelistFilter filter;

    private String constructScope() {
        return "" + scopeCounter.incrementAndGet();
    }

    public PigServer(String execTypeString) throws ExecException, IOException {
        this(PigServer.addExecTypeProperty(PropertiesUtil.loadDefaultProperties(), execTypeString));
    }

    public PigServer(Properties properties) throws ExecException, IOException {
        this(new PigContext(properties));
    }

    private static Properties addExecTypeProperty(Properties properties, String execType) {
        properties.setProperty("exectype", execType);
        return properties;
    }

    public PigServer(ExecType execType) throws ExecException {
        this(execType, PropertiesUtil.loadDefaultProperties());
    }

    public PigServer(ExecType execType, Properties properties) throws ExecException {
        this(new PigContext(execType, properties));
    }

    public PigServer(ExecType execType, Configuration conf) throws ExecException {
        this(new PigContext(execType, conf));
    }

    public PigServer(PigContext context) throws ExecException {
        this(context, true);
    }

    public PigServer(PigContext context, boolean connect) throws ExecException {
        this.pigContext = context;
        this.currDAG = new Graph(false);
        this.jobName = this.pigContext.getProperties().getProperty("jobName", "PigLatin:DefaultJobName");
        if (connect) {
            this.pigContext.connect();
        }
        this.filter = new BlackAndWhitelistFilter(this);
        this.addJarsFromProperties();
        this.markPredeployedJarsFromProperties();
        PigStats.start(this.pigContext.getExecutionEngine().instantiatePigStats());
        if (ScriptState.get() == null) {
            ScriptState.start(this.pigContext.getExecutionEngine().instantiateScriptState());
        }
    }

    private void addJarsFromProperties() throws ExecException {
        String jar_str = this.pigContext.getProperties().getProperty("pig.additional.jars");
        if (jar_str != null) {
            for (String jar : jar_str.split(File.pathSeparator)) {
                try {
                    this.registerJar(jar);
                }
                catch (IOException e) {
                    int errCode = 4010;
                    String msg = "Failed to register jar :" + jar + ". Caught exception.";
                    throw new ExecException(msg, errCode, 8, e);
                }
            }
        }
    }

    private void markPredeployedJarsFromProperties() throws ExecException {
        String jar_str = this.pigContext.getProperties().getProperty("pig.predeployed.jars");
        if (jar_str != null) {
            for (String jar : jar_str.split(File.pathSeparator)) {
                if (jar.length() <= 0) continue;
                this.pigContext.markJarAsPredeployed(jar);
            }
        }
    }

    public PigContext getPigContext() {
        return this.pigContext;
    }

    public Graph getCurrentDAG() {
        return this.currDAG;
    }

    public void debugOn() {
        Logger.getLogger((String)"org.apache.pig").setLevel(Level.DEBUG);
        this.pigContext.getLog4jProperties().setProperty("log4j.logger.org.apache.pig", Level.DEBUG.toString());
    }

    public void debugOff() {
        Logger.getLogger((String)"org.apache.pig").setLevel(this.pigContext.getDefaultLogLevel());
        this.pigContext.getLog4jProperties().setProperty("log4j.logger.org.apache.pig", this.pigContext.getDefaultLogLevel().toString());
    }

    public void setDefaultParallel(int p) {
        this.pigContext.defaultParallel = p;
    }

    public void setBatchOn() {
        this.log.debug((Object)"Create a new graph.");
        if (this.currDAG != null) {
            this.graphs.push(this.currDAG);
        }
        this.currDAG = new Graph(true);
    }

    public boolean isBatchOn() {
        return this.graphs.size() > 0;
    }

    public boolean isBatchEmpty() throws FrontendException {
        if (this.currDAG == null) {
            int errCode = 1083;
            String msg = "setBatchOn() must be called first.";
            throw new FrontendException(msg, errCode, 2);
        }
        return this.currDAG.isBatchEmpty();
    }

    public void parseAndBuild() throws IOException {
        if (this.currDAG == null || !this.isBatchOn()) {
            int errCode = 1083;
            String msg = "setBatchOn() must be called first.";
            throw new FrontendException(msg, errCode, 2);
        }
        this.currDAG.parseQuery();
        this.currDAG.buildPlan(null);
    }

    public List<ExecJob> executeBatch() throws IOException {
        return this.executeBatch(true);
    }

    public List<ExecJob> executeBatch(boolean parseAndBuild) throws IOException {
        if (parseAndBuild) {
            this.parseAndBuild();
        }
        PigStats stats = this.execute();
        return this.getJobs(stats);
    }

    protected List<ExecJob> getJobs(PigStats stats) {
        LinkedList<ExecJob> jobs = new LinkedList<ExecJob>();
        if (stats instanceof EmptyPigStats) {
            HJob job = new HJob(ExecJob.JOB_STATUS.COMPLETED, this.pigContext, stats.result(null).getPOStore(), null);
            jobs.add(job);
            return jobs;
        }
        PigStats.JobGraph jGraph = stats.getJobGraph();
        for (JobStats js : jGraph) {
            for (OutputStats output : js.getOutputs()) {
                if (js.isSuccessful()) {
                    jobs.add(new HJob(ExecJob.JOB_STATUS.COMPLETED, this.pigContext, output.getPOStore(), output.getAlias(), stats));
                    continue;
                }
                HJob hjob = new HJob(ExecJob.JOB_STATUS.FAILED, this.pigContext, output.getPOStore(), output.getAlias(), stats);
                hjob.setException(js.getException());
                jobs.add(hjob);
            }
        }
        return jobs;
    }

    public void discardBatch() throws FrontendException {
        if (this.currDAG == null || !this.isBatchOn()) {
            int errCode = 1083;
            String msg = "setBatchOn() must be called first.";
            throw new FrontendException(msg, errCode, 2);
        }
        this.currDAG = this.graphs.pop();
    }

    public void addPathToSkip(String path) {
        this.pigContext.addPathToSkip(path);
    }

    public void registerFunction(String function, FuncSpec funcSpec) {
        this.pigContext.registerFunction(function, funcSpec);
    }

    public void registerStreamingCommand(String commandAlias, StreamingCommand command) {
        this.pigContext.registerStreamCmd(commandAlias, command);
    }

    private URL locateJarFromResources(String jarName) throws IOException {
        Enumeration<URL> urls = ClassLoader.getSystemResources(jarName);
        URL resourceLocation = null;
        if (urls.hasMoreElements()) {
            resourceLocation = urls.nextElement();
        }
        if (urls.hasMoreElements()) {
            StringBuffer sb = new StringBuffer("Found multiple resources that match ");
            sb.append(jarName);
            sb.append(": ");
            sb.append(resourceLocation);
            while (urls.hasMoreElements()) {
                sb.append(urls.nextElement());
                sb.append("; ");
            }
            this.log.debug((Object)sb.toString());
        }
        return resourceLocation;
    }

    public void registerJar(String name) throws IOException {
        this.filter.validate(PigCommandFilter.Command.REGISTER);
        if (this.pigContext.hasJar(name)) {
            this.log.debug((Object)("Ignoring duplicate registration for jar " + name));
            return;
        }
        if (name != null) {
            if (name.isEmpty()) {
                this.log.warn((Object)"Empty string specified for jar path");
                return;
            }
            URL resource = this.locateJarFromResources(name);
            if (resource == null) {
                FileLocalizer.FetchFileRet[] files;
                for (FileLocalizer.FetchFileRet file : files = FileLocalizer.fetchFiles(this.pigContext.getProperties(), name)) {
                    File f = file.file;
                    if (!f.canRead()) {
                        int errCode = 4002;
                        String msg = "Can't read jar file: " + name;
                        throw new FrontendException(msg, errCode, 8);
                    }
                    this.pigContext.addJar(f.toURI().toURL(), name);
                }
            } else {
                this.pigContext.addJar(resource, name);
            }
        }
    }

    public void registerCode(String path, String scriptingLang, String namespace) throws IOException {
        if (this.pigContext.scriptingUDFs.containsKey(path) && this.pigContext.scriptingUDFs.get(path).equals(namespace)) {
            this.log.debug((Object)("Ignoring duplicate registration for scripting udf file " + path + " in namespace " + namespace));
            return;
        }
        this.pigContext.scriptingUDFs.put(path, namespace);
        File f = FileLocalizer.fetchFile((Properties)this.pigContext.getProperties(), (String)path).file;
        if (!f.canRead()) {
            int errCode = 4002;
            String msg = "Can't read file: " + path;
            throw new FrontendException(msg, errCode, 8);
        }
        String cwd = new File(".").getCanonicalPath();
        String filePath = f.getCanonicalPath();
        String nameInJar = filePath.equals(cwd + File.separator + path) ? filePath.substring(cwd.length() + 1) : filePath;
        this.pigContext.addScriptFile(nameInJar, filePath);
        if (scriptingLang != null) {
            ScriptEngine se = ScriptEngine.getInstance(scriptingLang);
            se.registerFunctions(nameInJar, namespace, this.pigContext);
        }
    }

    public void registerQuery(String query, int startLine) throws IOException {
        this.currDAG.registerQuery(query, startLine, this.validateEachStatement, this.skipParseInRegisterForBatch);
    }

    public void registerQuery(String query) throws IOException {
        this.registerQuery(query, 1);
    }

    public void registerScript(InputStream in) throws IOException {
        this.registerScript(in, null, null);
    }

    public void registerScript(InputStream in, Map<String, String> params) throws IOException {
        this.registerScript(in, params, null);
    }

    public void registerScript(InputStream in, List<String> paramsFiles) throws IOException {
        this.registerScript(in, null, paramsFiles);
    }

    public void registerScript(InputStream in, Map<String, String> params, List<String> paramsFiles) throws IOException {
        try {
            String substituted = this.pigContext.doParamSubstitution(in, this.paramMapToList(params), paramsFiles);
            GruntParser grunt = new GruntParser(new StringReader(substituted), this);
            grunt.setInteractive(false);
            grunt.parseStopOnError(true);
        }
        catch (ParseException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e);
        }
    }

    protected List<String> paramMapToList(Map<String, String> params) {
        ArrayList<String> paramList = new ArrayList<String>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramList.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        return paramList;
    }

    protected Graph getClonedGraph() throws IOException {
        Graph graph = this.currDAG.duplicate();
        if (graph == null) {
            int errCode = 2127;
            String msg = "Cloning of plan failed.";
            throw new FrontendException(msg, errCode, 4);
        }
        return graph;
    }

    public void registerScript(String fileName) throws IOException {
        this.registerScript(fileName, null, null);
    }

    public void registerScript(String fileName, Map<String, String> params) throws IOException {
        this.registerScript(fileName, params, null);
    }

    public void registerScript(String fileName, List<String> paramsFiles) throws IOException {
        this.registerScript(fileName, null, paramsFiles);
    }

    public void registerScript(String fileName, Map<String, String> params, List<String> paramsFiles) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.registerScript(fis, params, paramsFiles);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void printAliases() throws FrontendException {
        System.out.println("aliases: " + this.currDAG.getAliasOp().keySet());
    }

    public Schema dumpSchema(String alias) throws IOException {
        try {
            this.pigContext.inDumpSchema = true;
            if ("@".equals(alias)) {
                alias = this.getLastRel();
            }
            LogicalRelationalOperator op = this.getOperatorForAlias(alias);
            LogicalSchema schema = op.getSchema();
            boolean pretty = "true".equals(this.pigContext.getProperties().getProperty(PRETTY_PRINT_SCHEMA_PROPERTY));
            if (schema != null) {
                Schema s = Util.translateSchema(schema);
                System.out.println(alias + ": " + (pretty ? s.prettyPrint() : s.toString()));
                Schema schema2 = s;
                return schema2;
            }
            System.out.println("Schema for " + alias + " unknown.");
            Schema schema3 = null;
            return schema3;
        }
        catch (FrontendException fee) {
            int errCode = 1001;
            String msg = "Unable to describe schema for alias " + alias;
            throw new FrontendException(msg, errCode, 2, false, null, fee);
        }
        finally {
            this.pigContext.inDumpSchema = false;
        }
    }

    public Schema dumpSchemaNested(String alias, String nestedAlias) throws IOException {
        try {
            LogicalRelationalOperator op;
            this.pigContext.inDumpSchema = true;
            if ("@".equals(alias)) {
                alias = this.getLastRel();
            }
            if ((op = this.getOperatorForAlias(alias)) instanceof LOForEach) {
                LogicalSchema nestedSc = ((LOForEach)op).dumpNestedSchema(alias, nestedAlias);
                if (nestedSc != null) {
                    Schema s = Util.translateSchema(nestedSc);
                    System.out.println(alias + "::" + nestedAlias + ": " + s.toString());
                    Schema schema = s;
                    return schema;
                }
                System.out.println("Schema for " + alias + "::" + nestedAlias + " unknown.");
                Schema s = null;
                return s;
            }
            int errCode = 1001;
            String msg = "Unable to describe schema for " + alias + "::" + nestedAlias;
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        finally {
            this.pigContext.inDumpSchema = false;
        }
    }

    public void setJobName(String name) {
        this.jobName = "PigLatin:" + name;
    }

    public void setJobPriority(String priority) {
        this.jobPriority = priority;
    }

    public Iterator<Tuple> openIterator(String id) throws IOException {
        try {
            ExecJob job;
            this.pigContext.getProperties().setProperty("jobName", this.jobName);
            if (this.jobPriority != null) {
                this.pigContext.getProperties().setProperty("jobPriority", this.jobPriority);
            }
            if ((job = this.store(id, FileLocalizer.getTemporaryPath(this.pigContext).toString(), Utils.getTmpFileCompressorName(this.pigContext) + "()")).getStatus() == ExecJob.JOB_STATUS.COMPLETED) {
                return job.getResults();
            }
            if (job.getStatus() == ExecJob.JOB_STATUS.FAILED && job.getException() != null) {
                Exception e = job.getException();
                int errCode = 1066;
                String msg = "Unable to open iterator for alias " + id + ". Backend error : " + e.getMessage();
                throw new FrontendException(msg, errCode, 2, (Throwable)e);
            }
            throw new IOException("Job terminated with anomalous status " + job.getStatus().toString());
        }
        catch (FrontendException e) {
            throw e;
        }
        catch (Exception e) {
            int errCode = 1066;
            String msg = "Unable to open iterator for alias " + id;
            throw new FrontendException(msg, errCode, 2, (Throwable)e);
        }
    }

    public ExecJob store(String id, String filename) throws IOException {
        return this.store(id, filename, PigStorage.class.getName() + "()");
    }

    public ExecJob store(String id, String filename, String func) throws IOException {
        PigStats stats = this.storeEx(id, filename, func);
        if (stats.getOutputStats().size() < 1) {
            throw new IOException("Couldn't retrieve job.");
        }
        OutputStats output = stats.getOutputStats().get(0);
        if (stats.isSuccessful()) {
            return new HJob(ExecJob.JOB_STATUS.COMPLETED, this.pigContext, output.getPOStore(), output.getAlias(), stats);
        }
        HJob job = new HJob(ExecJob.JOB_STATUS.FAILED, this.pigContext, output.getPOStore(), output.getAlias(), stats);
        Exception ex = null;
        for (JobStats js : stats.getJobGraph()) {
            if (js.getException() == null) continue;
            ex = js.getException();
        }
        job.setException(ex);
        return job;
    }

    private PigStats storeEx(String alias, String filename, String func) throws IOException {
        if ("@".equals(alias)) {
            alias = this.getLastRel();
        }
        this.currDAG.parseQuery();
        this.currDAG.skipStores();
        this.currDAG.buildPlan(alias);
        try {
            QueryParserUtils.attachStorePlan(this.scope, this.currDAG.lp, filename, func, this.currDAG.getOperator(alias), alias, this.pigContext);
            this.currDAG.compile();
            return this.executeCompiledLogicalPlan();
        }
        catch (PigException e) {
            int errCode = 1002;
            String msg = "Unable to store alias " + alias;
            throw new PigException(msg, errCode, 2, e);
        }
    }

    public void explain(String alias, PrintStream stream) throws IOException {
        this.explain(alias, "text", true, false, stream, stream, null, null);
    }

    public void explain(String alias, String format, boolean verbose, boolean markAsExecute, PrintStream lps, PrintStream eps, File dir, String suffix) throws IOException {
        try {
            this.pigContext.inExplain = true;
            this.buildStorePlan(alias);
            this.currDAG.lp.optimize(this.pigContext);
            if (format == "xml" && lps == eps) {
                lps.println("<plan>");
            }
            this.currDAG.lp.explain(lps, format, verbose);
            if (this.currDAG.lp.size() == 0) {
                if (format == "xml" && lps == eps) {
                    lps.println("</plan>");
                }
                return;
            }
            this.pigContext.getExecutionEngine().explain(this.currDAG.lp, this.pigContext, eps, format, verbose, dir, suffix);
            if (format.equals("xml") && lps == eps) {
                lps.println("</plan>");
            }
            if (markAsExecute) {
                this.currDAG.markAsExecuted();
            }
        }
        catch (Exception e) {
            int errCode = 1067;
            String msg = "Unable to explain alias " + alias;
            throw new FrontendException(msg, errCode, 2, (Throwable)e);
        }
        finally {
            this.pigContext.inExplain = false;
        }
    }

    public long capacity() throws IOException {
        if (this.pigContext.getExecType().isLocal()) {
            throw new IOException("capacity only supported for non-local execution");
        }
        DataStorage dds = this.pigContext.getDfs();
        Map<String, Object> stats = dds.getStatistics();
        String rawCapacityStr = (String)stats.get("pig.raw.capacity.bytes");
        String rawUsedStr = (String)stats.get("pig.raw.used.capacity.bytes");
        if (rawCapacityStr == null || rawUsedStr == null) {
            throw new IOException("Failed to retrieve capacity stats");
        }
        long rawCapacityBytes = new Long(rawCapacityStr);
        long rawUsedBytes = new Long(rawUsedStr);
        return rawCapacityBytes - rawUsedBytes;
    }

    public long fileSize(String filename) throws IOException {
        DataStorage dfs = this.pigContext.getDfs();
        ElementDescriptor elem = dfs.asElement(filename);
        Map<String, Object> stats = elem.getStatistics();
        long length = (Long)stats.get("pig.path.length");
        short replication = (Short)stats.get("pig.path.block.replication");
        return length * (long)replication;
    }

    public boolean existsFile(String filename) throws IOException {
        ElementDescriptor elem = this.pigContext.getDfs().asElement(filename);
        return elem.exists();
    }

    public boolean deleteFile(String filename) throws IOException {
        this.filter.validate(PigCommandFilter.Command.RM);
        this.filter.validate(PigCommandFilter.Command.RMF);
        ElementDescriptor elem = this.pigContext.getDfs().asElement(filename);
        elem.delete();
        return true;
    }

    public boolean renameFile(String source, String target) throws IOException {
        this.filter.validate(PigCommandFilter.Command.MV);
        this.pigContext.rename(source, target);
        return true;
    }

    public boolean mkdirs(String dirs) throws IOException {
        this.filter.validate(PigCommandFilter.Command.MKDIR);
        ContainerDescriptor container = this.pigContext.getDfs().asContainer(dirs);
        container.create();
        return true;
    }

    public String[] listPaths(String dir) throws IOException {
        this.filter.validate(PigCommandFilter.Command.LS);
        ArrayList<String> allPaths = new ArrayList<String>();
        ContainerDescriptor container = this.pigContext.getDfs().asContainer(dir);
        for (ElementDescriptor elem : container) {
            allPaths.add(elem.toString());
        }
        String[] type = new String[1];
        return allPaths.toArray(type);
    }

    public Map<String, LogicalPlan> getAliases() {
        HashMap<String, LogicalPlan> aliasPlans = new HashMap<String, LogicalPlan>();
        for (LogicalRelationalOperator op : this.currDAG.getAliases().keySet()) {
            String alias = op.getAlias();
            if (null == alias) continue;
            aliasPlans.put(alias, this.currDAG.getAliases().get(op));
        }
        return aliasPlans;
    }

    public void shutdown() {
        FileLocalizer.deleteTempFiles();
    }

    public Set<String> getAliasKeySet() {
        return this.currDAG.getAliasOp().keySet();
    }

    public Map<Operator, DataBag> getExamples(String alias) throws IOException {
        try {
            if (this.currDAG.isBatchOn() && alias != null) {
                this.currDAG.parseQuery();
                this.currDAG.buildPlan(null);
                this.execute();
            }
            this.currDAG.parseQuery();
            this.currDAG.skipStores();
            this.currDAG.buildPlan(alias);
            this.currDAG.compile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ExampleGenerator exgen = new ExampleGenerator(this.currDAG.lp, this.pigContext);
        try {
            return exgen.getExamples();
        }
        catch (ExecException e) {
            e.printStackTrace(System.out);
            throw new IOException("ExecException", e);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new IOException("Exception ", e);
        }
    }

    public void printHistory(boolean withNumbers) {
        List<String> sc = this.currDAG.getScriptCache();
        if (!sc.isEmpty()) {
            for (int i = 0; i < sc.size(); ++i) {
                if (withNumbers) {
                    System.out.print(i + 1 + "   ");
                }
                System.out.println(sc.get(i));
            }
        }
    }

    private void buildStorePlan(String alias) throws IOException {
        this.currDAG.parseQuery();
        this.currDAG.buildPlan(alias);
        if (!this.isBatchOn() || alias != null) {
            QueryParserUtils.attachStorePlan(this.scope, this.currDAG.lp, "fakefile", null, this.currDAG.getOperator(alias), "fake", this.pigContext);
        }
        this.currDAG.compile();
    }

    private PigStats execute() throws IOException {
        this.pigContext.getProperties().setProperty("jobName", this.jobName);
        if (this.jobPriority != null) {
            this.pigContext.getProperties().setProperty("jobPriority", this.jobPriority);
        }
        this.currDAG.countExecutedStores();
        this.currDAG.compile();
        if (this.currDAG.lp.size() == 0) {
            return PigStats.get();
        }
        this.pigContext.getProperties().setProperty("pig.logical.plan.signature", this.currDAG.lp.getSignature());
        PigStats stats = this.executeCompiledLogicalPlan();
        return stats;
    }

    private PigStats executeCompiledLogicalPlan() throws ExecException, FrontendException {
        ScriptState.get().setScriptFeatures(this.currDAG.lp);
        this.currDAG.lp.optimize(this.pigContext);
        return this.launchPlan(this.currDAG.lp, "job_pigexec_");
    }

    protected PigStats launchPlan(LogicalPlan lp, String jobName) throws ExecException, FrontendException {
        PigStats stats = null;
        try {
            stats = this.pigContext.getExecutionEngine().launchPig(lp, jobName, this.pigContext);
        }
        catch (ExecException e) {
            throw e;
        }
        catch (FrontendException e) {
            throw e;
        }
        catch (Exception e) {
            int errCode = 2043;
            String msg = "Unexpected error during execution.";
            throw new ExecException(msg, errCode, 4, e);
        }
        return stats;
    }

    private LogicalPlan buildLp() throws IOException {
        this.currDAG.buildPlan(null);
        this.currDAG.compile();
        return this.currDAG.lp;
    }

    private LogicalRelationalOperator getOperatorForAlias(String alias) throws IOException {
        this.buildStorePlan(alias);
        LogicalRelationalOperator op = (LogicalRelationalOperator)this.currDAG.getOperator(alias);
        if (op == null) {
            int errCode = 1005;
            String msg = "No plan for " + alias + " to describe";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        return op;
    }

    public LogicalPlanData getLogicalPlanData() {
        return new LogicalPlanData(this.currDAG.lp);
    }

    public void setValidateEachStatement(boolean validateEachStatement) {
        this.validateEachStatement = validateEachStatement;
    }

    public void setSkipParseInRegisterForBatch(boolean skipParseInRegisterForBatch) {
        this.skipParseInRegisterForBatch = skipParseInRegisterForBatch;
    }

    public String getLastRel() {
        return this.currDAG.getLastRel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Graph {
        private final Map<LogicalRelationalOperator, LogicalPlan> aliases = new HashMap<LogicalRelationalOperator, LogicalPlan>();
        private Map<String, Operator> operators = new HashMap<String, Operator>();
        private String lastRel;
        private final List<String> scriptCache = new ArrayList<String>();
        private Map<String, String> fileNameMap = new HashMap<String, String>();
        private final boolean batchMode;
        private int processedStores = 0;
        private LogicalPlan lp;
        private int currentLineNum = 0;

        public Graph(boolean batchMode) {
            this.batchMode = batchMode;
            this.lp = new LogicalPlan();
        }

        private void countExecutedStores() throws FrontendException {
            LinkedList<LOStore> sinks = Util.getLogicalRelationalOperators(this.lp, LOStore.class);
            this.processedStores += sinks.size();
        }

        Map<LogicalRelationalOperator, LogicalPlan> getAliases() {
            return this.aliases;
        }

        Map<String, Operator> getAliasOp() {
            return this.operators;
        }

        boolean isBatchOn() {
            return this.batchMode;
        }

        boolean isBatchEmpty() {
            for (Operator op : this.lp.getSinks()) {
                if (!(op instanceof LOStore)) continue;
                return false;
            }
            return true;
        }

        void markAsExecuted() {
        }

        public LogicalPlan getLogicalPlan() {
            return this.lp;
        }

        Operator getOperator(String alias) throws FrontendException {
            return this.operators.get(alias);
        }

        public LogicalPlan getPlan(String alias) throws IOException {
            LogicalPlan plan = this.lp;
            if (alias != null) {
                LogicalRelationalOperator op = (LogicalRelationalOperator)this.operators.get(alias);
                if (op == null) {
                    int errCode = 1003;
                    String msg = "Unable to find an operator for alias " + alias;
                    throw new FrontendException(msg, errCode, 2);
                }
                plan = this.aliases.get(op);
            }
            return plan;
        }

        void buildPlan(String alias) throws IOException {
            if (alias == null) {
                this.skipStores();
            }
            final LinkedList<Operator> queue = new LinkedList<Operator>();
            if (alias != null) {
                Operator op = this.getOperator(alias);
                if (op == null) {
                    String msg = "Unable to find an operator for alias " + alias;
                    throw new FrontendException(msg, 1003, 2);
                }
                queue.add(op);
            } else {
                LinkedList<LOStore> stores = Util.getLogicalRelationalOperators(this.lp, LOStore.class);
                for (LOStore op : stores) {
                    boolean addSink = true;
                    List<Operator> succs = this.lp.getSuccessors(op);
                    if (succs != null && succs.size() > 0) {
                        for (Operator succ : succs) {
                            if (succ instanceof LOLoad) continue;
                            addSink = false;
                            break;
                        }
                    }
                    if (!addSink) continue;
                    queue.add(op);
                }
            }
            LogicalPlan plan = new LogicalPlan();
            while (!queue.isEmpty()) {
                Operator currOp = (Operator)queue.poll();
                plan.add(currOp);
                List<Operator> preds = this.lp.getPredecessors(currOp);
                if (preds != null) {
                    ArrayList<Operator> ops = new ArrayList<Operator>(preds);
                    for (Operator pred : ops) {
                        if (!queue.contains(pred)) {
                            queue.add(pred);
                        }
                        plan.connect(pred, currOp);
                    }
                }
                currOp.accept(new AllExpressionVisitor(plan, new DependencyOrderWalker(plan)){

                    protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan exprPlan) throws FrontendException {
                        return new LogicalExpressionVisitor(exprPlan, new DependencyOrderWalker(exprPlan)){

                            public void visit(ScalarExpression expr) throws FrontendException {
                                Operator refOp = expr.getImplicitReferencedOperator();
                                if (!queue.contains(refOp)) {
                                    queue.add(refOp);
                                }
                            }
                        };
                    }
                });
                currOp.setPlan(plan);
            }
            this.lp = plan;
        }

        private void skipStores() throws IOException {
            LinkedList<LOStore> sinks = Util.getLogicalRelationalOperators(this.lp, LOStore.class);
            ArrayList<LOStore> sinksToRemove = new ArrayList<LOStore>();
            int skipCount = this.processedStores;
            if (skipCount > 0) {
                for (LOStore lOStore : sinks) {
                    sinksToRemove.add(lOStore);
                    if (--skipCount != 0) continue;
                    break;
                }
            }
            for (Operator operator : sinksToRemove) {
                this.removeToLoad(operator);
                Operator pred = this.lp.getPredecessors(operator).get(0);
                this.lp.disconnect(pred, operator);
                this.lp.remove(operator);
            }
        }

        private void removeToLoad(Operator toRemove) throws IOException {
            List<Operator> successors = this.lp.getSuccessors(toRemove);
            ArrayList<Operator> succToRemove = new ArrayList<Operator>();
            if (successors != null && successors.size() > 0) {
                succToRemove.addAll(successors);
                for (Operator succ : succToRemove) {
                    this.lp.disconnect(toRemove, succ);
                    if (succ instanceof LOLoad) continue;
                    this.removeToLoad(succ);
                    this.lp.remove(succ);
                }
            }
        }

        void registerQuery(String query, int startLine, boolean validateEachStatement, boolean skipParseForBatch) throws IOException {
            if (this.batchMode) {
                if (startLine == this.currentLineNum) {
                    String line = this.scriptCache.remove(this.scriptCache.size() - 1);
                    this.scriptCache.add(line + query);
                } else {
                    while (startLine > this.currentLineNum + 1) {
                        this.scriptCache.add("");
                        ++this.currentLineNum;
                    }
                    BufferedReader br = new BufferedReader(new StringReader(query));
                    String line = br.readLine();
                    while (line != null) {
                        this.scriptCache.add(line);
                        ++this.currentLineNum;
                        line = br.readLine();
                    }
                }
                if (skipParseForBatch) {
                    return;
                }
            } else {
                this.scriptCache.add(query);
            }
            if (validateEachStatement) {
                this.validateQuery();
            }
            this.parseQuery();
            if (!this.batchMode) {
                this.buildPlan(null);
                for (Operator sink : this.lp.getSinks()) {
                    if (!(sink instanceof LOStore)) continue;
                    try {
                        PigServer.this.execute();
                        break;
                    }
                    catch (Exception e) {
                        int errCode = 1002;
                        String msg = "Unable to store alias " + ((LOStore)sink).getAlias();
                        throw new FrontendException(msg, errCode, 2, (Throwable)e);
                    }
                }
            }
        }

        private void validateQuery() throws FrontendException {
            String query = this.buildQuery();
            QueryParserDriver parserDriver = new QueryParserDriver(PigServer.this.pigContext, PigServer.this.scope, this.fileNameMap);
            try {
                LogicalPlan plan = parserDriver.parse(query);
                plan.validate(PigServer.this.pigContext, PigServer.this.scope, true);
            }
            catch (FrontendException ex) {
                this.scriptCache.remove(this.scriptCache.size() - 1);
                throw ex;
            }
        }

        public List<String> getScriptCache() {
            return this.scriptCache;
        }

        private void parseQuery() throws FrontendException {
            UDFContext.getUDFContext().reset();
            UDFContext.getUDFContext().setClientSystemProps(PigServer.this.pigContext.getProperties());
            String query = this.buildQuery();
            if (query.isEmpty()) {
                this.lp = new LogicalPlan();
                return;
            }
            try {
                QueryParserDriver parserDriver = new QueryParserDriver(PigServer.this.pigContext, PigServer.this.scope, this.fileNameMap);
                this.lp = parserDriver.parse(query);
                this.operators = parserDriver.getOperators();
                this.lastRel = parserDriver.getLastRel();
            }
            catch (Exception ex) {
                this.scriptCache.remove(this.scriptCache.size() - 1);
                PigException pe = LogUtils.getPigException(ex);
                int errCode = 1000;
                String msg = "Error during parsing. " + (pe == null ? ex.getMessage() : pe.getMessage());
                PigServer.this.log.error((Object)("exception during parsing: " + msg), (Throwable)ex);
                if (null == pe) {
                    throw new FrontendException(msg, errCode, 2, (Throwable)ex);
                }
                throw new FrontendException(msg, errCode, 2, ex, pe.getSourceLocation());
            }
        }

        public String getLastRel() {
            return this.lastRel;
        }

        private String buildQuery() {
            StringBuilder accuQuery = new StringBuilder();
            for (String line : this.scriptCache) {
                accuQuery.append(line + "\n");
            }
            return accuQuery.toString();
        }

        private void compile() throws IOException {
            this.lp.validate(PigServer.this.pigContext, PigServer.this.scope, false);
            PigServer.this.currDAG.postProcess();
        }

        private void postProcess() throws IOException {
            HashSet<LOLoad> loadOps = new HashSet<LOLoad>();
            List<Operator> sources = this.lp.getSources();
            for (Operator source : sources) {
                if (!(source instanceof LOLoad)) continue;
                loadOps.add((LOLoad)source);
            }
            HashSet<LOStore> storeOps = new HashSet<LOStore>();
            List<Operator> sinks = this.lp.getSinks();
            for (Operator sink : sinks) {
                if (!(sink instanceof LOStore)) continue;
                storeOps.add((LOStore)sink);
            }
            if ("true".equals(PigServer.this.pigContext.getProperties().getProperty(PigServer.PIG_LOCATION_CHECK_STRICT))) {
                PigServer.this.log.info((Object)"Output location strick check enabled");
                this.checkDuplicateStoreLoc(storeOps);
            }
            for (LOLoad load : loadOps) {
                for (LOStore store : storeOps) {
                    String ifile = load.getFileSpec().getFileName();
                    String ofile = store.getFileSpec().getFileName();
                    if (!ofile.equals(ifile) || store.getPlan().pathExists(load, store)) continue;
                    store.getPlan().connect(store, load);
                }
            }
        }

        private void checkDuplicateStoreLoc(Set<LOStore> storeOps) {
            HashSet<String> uniqueStoreLoc = new HashSet<String>();
            for (LOStore store : storeOps) {
                String fileName = store.getFileSpec().getFileName();
                if (uniqueStoreLoc.add(fileName) || !UriUtil.isHDFSFileOrLocalOrS3N(fileName, new Configuration(true))) continue;
                throw new RuntimeException("Script contains 2 or more STORE statements writing to same location : " + fileName);
            }
        }

        protected Graph duplicate() {
            int lineNumber = 1;
            Graph graph = new Graph(this.isBatchOn());
            graph.processedStores = this.processedStores;
            graph.fileNameMap = new HashMap<String, String>(this.fileNameMap);
            try {
                Iterator<String> it = this.scriptCache.iterator();
                while (it.hasNext()) {
                    graph.registerQuery(it.next(), lineNumber, false, false);
                    ++lineNumber;
                }
                graph.postProcess();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                graph = null;
            }
            return graph;
        }
    }
}

