/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.rules.DNFExpression;
import org.apache.pig.newplan.logical.rules.DNFPlan;
import org.apache.pig.newplan.logical.rules.LogicalExpressionProxy;

class DNFPlanGenerator
extends LogicalExpressionVisitor {
    private OperatorPlan dnfPlan = null;
    Deque<LogicalExpression> result = new LinkedList<LogicalExpression>();

    DNFPlanGenerator(OperatorPlan plan) throws FrontendException {
        super(plan, new ReverseDependencyOrderWalker(plan));
    }

    OperatorPlan getDNFPlan() {
        if (this.dnfPlan == null) {
            this.dnfPlan = this.result.isEmpty() ? this.plan : this.result.pop().getPlan();
        }
        return this.dnfPlan;
    }

    public void visit(AndExpression exp) throws FrontendException {
        block29: {
            DNFExpression current;
            boolean isRhsOr;
            boolean isLhsOr;
            boolean isRhsAnd;
            boolean isLhsAnd;
            LogicalExpression lhsExp;
            LogicalExpression rhsExp;
            block31: {
                block32: {
                    block30: {
                        block28: {
                            rhsExp = exp.getRhs() instanceof AndExpression || exp.getRhs() instanceof OrExpression ? this.result.pop() : exp.getRhs();
                            LogicalExpression logicalExpression = lhsExp = exp.getLhs() instanceof AndExpression || exp.getLhs() instanceof OrExpression ? this.result.pop() : exp.getLhs();
                            if (lhsExp instanceof AndExpression || lhsExp instanceof DNFExpression || lhsExp instanceof OrExpression || rhsExp instanceof AndExpression || rhsExp instanceof OrExpression || rhsExp instanceof DNFExpression) break block28;
                            this.result.push(exp);
                            break block29;
                        }
                        if (this.dnfPlan == null) {
                            this.dnfPlan = new DNFPlan();
                        }
                        isLhsAnd = lhsExp instanceof AndExpression || lhsExp instanceof DNFExpression && ((DNFExpression)lhsExp).type == DNFExpression.DNFExpressionType.AND;
                        boolean bl = isRhsAnd = rhsExp instanceof AndExpression || rhsExp instanceof DNFExpression && ((DNFExpression)rhsExp).type == DNFExpression.DNFExpressionType.AND;
                        if (!isLhsAnd || !isRhsAnd) break block30;
                        DNFExpression current2 = new DNFExpression("dnfAnd", this.dnfPlan, DNFExpression.DNFExpressionType.AND);
                        ((DNFPlan)this.dnfPlan).safeAdd(current2);
                        this.result.push(current2);
                        this.addChildren(current2, lhsExp);
                        this.addChildren(current2, rhsExp);
                        break block29;
                    }
                    isLhsOr = lhsExp instanceof OrExpression || lhsExp instanceof DNFExpression && ((DNFExpression)lhsExp).type == DNFExpression.DNFExpressionType.OR;
                    isRhsOr = rhsExp instanceof OrExpression || rhsExp instanceof DNFExpression && ((DNFExpression)rhsExp).type == DNFExpression.DNFExpressionType.OR;
                    current = isLhsOr || isRhsOr ? new DNFExpression("dnfOr", this.dnfPlan, DNFExpression.DNFExpressionType.OR) : new DNFExpression("dnfAnd", this.dnfPlan, DNFExpression.DNFExpressionType.AND);
                    ((DNFPlan)this.dnfPlan).safeAdd(current);
                    this.result.push(current);
                    if (isLhsOr || isRhsOr) break block31;
                    if (isLhsAnd) {
                        this.addChildren(current, lhsExp);
                    } else if (!isLhsOr) {
                        ((DNFPlan)this.dnfPlan).safeAdd(lhsExp);
                        this.dnfPlan.connect(current, lhsExp);
                    }
                    if (!isRhsAnd) break block32;
                    this.addChildren(current, rhsExp);
                    break block29;
                }
                if (isRhsOr) break block29;
                ((DNFPlan)this.dnfPlan).safeAdd(rhsExp);
                this.dnfPlan.connect(current, rhsExp);
                break block29;
            }
            if (!isLhsOr) {
                if (!isLhsAnd) {
                    this.mergeSimpleOr(current, lhsExp, rhsExp, true);
                } else {
                    this.mergeAndOr(current, lhsExp, rhsExp, true);
                }
            } else if (!isRhsOr) {
                if (!isRhsAnd) {
                    this.mergeSimpleOr(current, rhsExp, lhsExp, false);
                } else {
                    this.mergeAndOr(current, rhsExp, lhsExp, false);
                }
            } else {
                int i;
                Operator[] lhsChildren = lhsExp.getPlan().getSuccessors(lhsExp).toArray(new Operator[0]);
                Operator[] rhsChildren = rhsExp.getPlan().getSuccessors(rhsExp).toArray(new Operator[0]);
                boolean lhsDNF = lhsExp.getPlan() == this.dnfPlan;
                boolean rhsDNF = rhsExp.getPlan() == this.dnfPlan;
                int lsize = lhsChildren.length;
                int rsize = rhsChildren.length;
                LogicalExpression[][] grandChildrenL = new LogicalExpression[lsize][];
                for (int i2 = 0; i2 < lsize; ++i2) {
                    if (lhsChildren[i2] instanceof AndExpression) {
                        grandChildrenL[i2] = lhsChildren[i2].getPlan().getSuccessors(lhsChildren[i2]).toArray(new LogicalExpression[0]);
                        continue;
                    }
                    if (lhsChildren[i2] instanceof DNFExpression) {
                        grandChildrenL[i2] = this.dnfPlan.getSuccessors(lhsChildren[i2]).toArray(new LogicalExpression[0]);
                        continue;
                    }
                    grandChildrenL[i2] = new LogicalExpression[1];
                    grandChildrenL[i2][0] = (LogicalExpression)lhsChildren[i2];
                }
                LogicalExpression[][] grandChildrenR = new LogicalExpression[rsize][];
                for (i = 0; i < rsize; ++i) {
                    if (rhsChildren[i] instanceof AndExpression) {
                        grandChildrenR[i] = rhsChildren[i].getPlan().getSuccessors(rhsChildren[i]).toArray(new LogicalExpression[0]);
                        continue;
                    }
                    if (rhsChildren[i] instanceof DNFExpression) {
                        grandChildrenR[i] = this.dnfPlan.getSuccessors(rhsChildren[i]).toArray(new LogicalExpression[0]);
                        continue;
                    }
                    grandChildrenR[i] = new LogicalExpression[1];
                    grandChildrenR[i][0] = (LogicalExpression)rhsChildren[i];
                }
                if (lhsDNF) {
                    this.removeDescendants(this.dnfPlan, lhsExp);
                    this.dnfPlan.remove(lhsExp);
                }
                if (rhsDNF) {
                    this.removeDescendants(this.dnfPlan, rhsExp);
                    this.dnfPlan.remove(rhsExp);
                }
                for (i = 0; i < lsize; ++i) {
                    for (LogicalExpression lgchild : grandChildrenL[i]) {
                        if (!(lgchild instanceof LogicalExpressionProxy)) continue;
                        ((LogicalExpressionProxy)lgchild).restoreSrc();
                    }
                }
                for (i = 0; i < rsize; ++i) {
                    for (LogicalExpression rgchild : grandChildrenR[i]) {
                        if (!(rgchild instanceof LogicalExpressionProxy)) continue;
                        ((LogicalExpressionProxy)rgchild).restoreSrc();
                    }
                }
                for (i = 0; i < lsize; ++i) {
                    for (int j = 0; j < rsize; ++j) {
                        DNFExpression child = new DNFExpression("dnfAnd", this.dnfPlan, DNFExpression.DNFExpressionType.AND);
                        ((DNFPlan)this.dnfPlan).safeAdd(child);
                        this.dnfPlan.connect(current, child);
                        for (LogicalExpression lgchild : grandChildrenL[i]) {
                            LogicalExpressionProxy lhsClone = lgchild instanceof LogicalExpressionProxy ? new LogicalExpressionProxy(this.dnfPlan, ((LogicalExpressionProxy)lgchild).src) : new LogicalExpressionProxy(this.dnfPlan, lgchild);
                            this.dnfPlan.add(lhsClone);
                            this.dnfPlan.connect(child, lhsClone);
                        }
                        for (LogicalExpression rgchild : grandChildrenR[j]) {
                            LogicalExpressionProxy rhsClone = rgchild instanceof LogicalExpressionProxy ? new LogicalExpressionProxy(this.dnfPlan, ((LogicalExpressionProxy)rgchild).src) : new LogicalExpressionProxy(this.dnfPlan, rgchild);
                            this.dnfPlan.add(rhsClone);
                            this.dnfPlan.connect(child, rhsClone);
                        }
                    }
                }
            }
        }
    }

    private void removeDescendants(OperatorPlan plan, Operator op) throws FrontendException {
        if (plan.getSuccessors(op) == null) {
            return;
        }
        Object[] children = plan.getSuccessors(op).toArray();
        if (children != null) {
            for (Object c : children) {
                Operator child = (Operator)c;
                this.removeDescendants(plan, child);
                plan.disconnect(op, child);
                plan.remove(child);
            }
        }
    }

    private void mergeSimpleOr(LogicalExpression current, LogicalExpression simple, LogicalExpression or, boolean simpleFirst) throws FrontendException {
        boolean orDNF;
        Operator[] orChildren = or.getPlan().getSuccessors(or).toArray(new Operator[0]);
        int size = orChildren.length;
        LogicalExpression[][] grandChildrenOr = new LogicalExpression[size][];
        for (int i = 0; i < size; ++i) {
            if (orChildren[i] instanceof DNFExpression) {
                grandChildrenOr[i] = this.dnfPlan.getSuccessors(orChildren[i]).toArray(new LogicalExpression[0]);
                continue;
            }
            if (orChildren[i] instanceof AndExpression) {
                grandChildrenOr[i] = orChildren[i].getPlan().getSuccessors(orChildren[i]).toArray(new LogicalExpression[0]);
                continue;
            }
            grandChildrenOr[i] = new LogicalExpression[1];
            grandChildrenOr[i][0] = (LogicalExpression)orChildren[i];
        }
        boolean simpleDNF = simple.getPlan() == this.dnfPlan;
        boolean bl = orDNF = or.getPlan() == this.dnfPlan;
        if (simpleDNF) {
            if (simple instanceof LogicalExpressionProxy) {
                ((LogicalExpressionProxy)simple).restoreSrc();
            }
            this.dnfPlan.remove(simple);
        }
        if (orDNF) {
            this.removeDescendants(this.dnfPlan, or);
            this.dnfPlan.remove(or);
        }
        for (int i = 0; i < size; ++i) {
            DNFExpression child = new DNFExpression("dnfAnd", this.dnfPlan, DNFExpression.DNFExpressionType.AND);
            ((DNFPlan)this.dnfPlan).safeAdd(child);
            this.dnfPlan.connect(current, child);
            LogicalExpressionProxy simpleClone = simple instanceof LogicalExpressionProxy ? new LogicalExpressionProxy(this.dnfPlan, ((LogicalExpressionProxy)simple).src) : new LogicalExpressionProxy(this.dnfPlan, simple);
            this.dnfPlan.add(simpleClone);
            if (simpleFirst) {
                this.dnfPlan.connect(child, simpleClone);
            }
            for (LogicalExpression gchild : grandChildrenOr[i]) {
                LogicalExpression childClone = gchild instanceof LogicalExpressionProxy ? gchild : new LogicalExpressionProxy(this.dnfPlan, gchild);
                this.dnfPlan.add(childClone);
                this.dnfPlan.connect(child, childClone);
            }
            if (simpleFirst) continue;
            this.dnfPlan.connect(child, simpleClone);
        }
    }

    private void mergeAndOr(LogicalExpression current, LogicalExpression and, LogicalExpression or, boolean andFirst) throws FrontendException {
        Operator[] andChildren = and.getPlan().getSuccessors(and).toArray(new Operator[0]);
        Operator[] orChildren = or.getPlan().getSuccessors(or).toArray(new Operator[0]);
        int orSize = orChildren.length;
        int andSize = andChildren.length;
        boolean andDNF = and.getPlan() == this.dnfPlan;
        boolean orDNF = or.getPlan() == this.dnfPlan;
        LogicalExpression[][] grandChildrenOr = new LogicalExpression[orSize][];
        for (int i = 0; i < orSize; ++i) {
            if (orChildren[i] instanceof DNFExpression) {
                grandChildrenOr[i] = this.dnfPlan.getSuccessors(orChildren[i]).toArray(new LogicalExpression[0]);
                continue;
            }
            if (orChildren[i] instanceof AndExpression) {
                grandChildrenOr[i] = orChildren[i].getPlan().getSuccessors(orChildren[i]).toArray(new LogicalExpression[0]);
                continue;
            }
            grandChildrenOr[i] = new LogicalExpression[1];
            grandChildrenOr[i][0] = (LogicalExpression)orChildren[i];
        }
        for (Operator andChild : andChildren) {
            if (!(andChild instanceof LogicalExpressionProxy)) continue;
            ((LogicalExpressionProxy)andChild).restoreSrc();
        }
        if (andDNF) {
            this.removeDescendants(this.dnfPlan, and);
            this.dnfPlan.remove(and);
        }
        if (orDNF) {
            this.removeDescendants(this.dnfPlan, or);
            this.dnfPlan.remove(or);
        }
        for (int i = 0; i < orSize; ++i) {
            DNFExpression child = new DNFExpression("dnfAnd", this.dnfPlan, DNFExpression.DNFExpressionType.AND);
            ((DNFPlan)this.dnfPlan).safeAdd(child);
            if (!andFirst) {
                for (LogicalExpression gchild : grandChildrenOr[i]) {
                    this.dnfPlan.connect(child, gchild);
                }
            }
            for (int j = 0; j < andSize; ++j) {
                LogicalExpressionProxy andChildClone = andChildren[j] instanceof LogicalExpressionProxy ? new LogicalExpressionProxy(this.dnfPlan, ((LogicalExpressionProxy)andChildren[j]).src) : new LogicalExpressionProxy(this.dnfPlan, (LogicalExpression)andChildren[j]);
                this.dnfPlan.connect(child, andChildClone);
            }
            if (andFirst) {
                for (LogicalExpression gchild : grandChildrenOr[i]) {
                    this.dnfPlan.connect(child, gchild);
                }
            }
            this.dnfPlan.connect(current, child);
        }
    }

    public void visit(OrExpression exp) throws FrontendException {
        LogicalExpression lhsExp;
        LogicalExpression rhsExp = exp.getRhs() instanceof AndExpression || exp.getRhs() instanceof OrExpression ? this.result.pop() : exp.getRhs();
        LogicalExpression logicalExpression = lhsExp = exp.getLhs() instanceof AndExpression || exp.getLhs() instanceof OrExpression ? this.result.pop() : exp.getLhs();
        if (!(lhsExp instanceof OrExpression || lhsExp instanceof DNFExpression && ((DNFExpression)lhsExp).type != DNFExpression.DNFExpressionType.AND || rhsExp instanceof OrExpression || rhsExp instanceof DNFExpression && ((DNFExpression)rhsExp).type != DNFExpression.DNFExpressionType.AND)) {
            this.result.push(exp);
        } else {
            if (this.dnfPlan == null) {
                this.dnfPlan = new DNFPlan();
            }
            DNFExpression current = new DNFExpression("dnfOr", this.dnfPlan, DNFExpression.DNFExpressionType.OR);
            this.result.push(current);
            ((DNFPlan)this.dnfPlan).safeAdd(current);
            if (lhsExp instanceof OrExpression || lhsExp instanceof DNFExpression && ((DNFExpression)lhsExp).type == DNFExpression.DNFExpressionType.OR) {
                this.addChildren(current, lhsExp);
            } else {
                this.dnfPlan.connect(current, lhsExp);
            }
            if (rhsExp instanceof OrExpression || rhsExp instanceof DNFExpression && ((DNFExpression)rhsExp).type == DNFExpression.DNFExpressionType.OR) {
                this.addChildren(current, rhsExp);
            } else {
                this.dnfPlan.connect(current, rhsExp);
            }
        }
    }

    private void addChildren(LogicalExpression current, LogicalExpression exp) throws FrontendException {
        OperatorPlan childPlan = exp.getPlan();
        Operator[] children = childPlan.getSuccessors(exp).toArray(new Operator[0]);
        int size = children.length;
        for (int i = 0; i < size; ++i) {
            ((DNFPlan)this.dnfPlan).safeAdd(children[i]);
            this.dnfPlan.connect(current, children[i]);
        }
    }
}

