/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.BigDecimalAbs;
import org.apache.pig.builtin.BigIntegerAbs;
import org.apache.pig.builtin.DoubleAbs;
import org.apache.pig.builtin.FloatAbs;
import org.apache.pig.builtin.IntAbs;
import org.apache.pig.builtin.LongAbs;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABS
extends EvalFunc<Double> {
    @Override
    public Double exec(Tuple input) throws IOException {
        Double d;
        if (input == null || input.size() == 0) {
            return null;
        }
        try {
            d = DataType.toDouble(input.get(0));
        }
        catch (NumberFormatException nfe) {
            System.err.println("Failed to process input; error - " + nfe.getMessage());
            return null;
        }
        catch (Exception e) {
            throw new IOException("Caught exception processing input row ", e);
        }
        return Math.abs(d);
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 25));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(this.getClass().getName(), new Schema(new Schema.FieldSchema(null, 50))));
        funcList.add(new FuncSpec(DoubleAbs.class.getName(), new Schema(new Schema.FieldSchema(null, 25))));
        funcList.add(new FuncSpec(FloatAbs.class.getName(), new Schema(new Schema.FieldSchema(null, 20))));
        funcList.add(new FuncSpec(IntAbs.class.getName(), new Schema(new Schema.FieldSchema(null, 10))));
        funcList.add(new FuncSpec(LongAbs.class.getName(), new Schema(new Schema.FieldSchema(null, 15))));
        funcList.add(new FuncSpec(BigIntegerAbs.class.getName(), new Schema(new Schema.FieldSchema(null, 65))));
        funcList.add(new FuncSpec(BigDecimalAbs.class.getName(), new Schema(new Schema.FieldSchema(null, 70))));
        return funcList;
    }
}

