/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.BigDecimalAvg;
import org.apache.pig.builtin.BigIntegerAvg;
import org.apache.pig.builtin.DoubleAvg;
import org.apache.pig.builtin.FloatAvg;
import org.apache.pig.builtin.IntAvg;
import org.apache.pig.builtin.LongAvg;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVG
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private Double intermediateSum = null;
    private Double intermediateCount = null;

    @Override
    public Double exec(Tuple input) throws IOException {
        Double sum = AVG.sum(input);
        if (sum == null) {
            return null;
        }
        double count = AVG.count(input);
        Double avg = null;
        if (count > 0.0) {
            avg = new Double(sum / count);
        }
        return avg;
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Tuple combine(DataBag values) throws ExecException {
        double sum = 0.0;
        long count = 0L;
        Tuple output = mTupleFactory.newTuple(2);
        boolean sawNonNull = false;
        for (Tuple t : values) {
            Double d = (Double)t.get(0);
            if (d == null) {
                d = 0.0;
            } else {
                sawNonNull = true;
            }
            sum += d.doubleValue();
            count += ((Long)t.get(1)).longValue();
        }
        if (sawNonNull) {
            output.set(0, new Double(sum));
        } else {
            output.set(0, null);
        }
        output.set(1, count);
        return output;
    }

    protected static long count(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        long cnt = 0L;
        for (Tuple t : values) {
            if (t == null || t.size() <= 0 || t.get(0) == null) continue;
            ++cnt;
        }
        return cnt;
    }

    protected static Double sum(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sum = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d;
                DataByteArray dba = (DataByteArray)t.get(0);
                Double d2 = d = dba != null ? Double.valueOf(dba.toString()) : null;
                if (d == null) continue;
                sawNonNull = true;
                sum += d.doubleValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of doubles.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return new Double(sum);
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(this.getClass().getName(), Schema.generateNestedSchema((byte)120, 50)));
        funcList.add(new FuncSpec(DoubleAvg.class.getName(), Schema.generateNestedSchema((byte)120, 25)));
        funcList.add(new FuncSpec(FloatAvg.class.getName(), Schema.generateNestedSchema((byte)120, 20)));
        funcList.add(new FuncSpec(IntAvg.class.getName(), Schema.generateNestedSchema((byte)120, 10)));
        funcList.add(new FuncSpec(LongAvg.class.getName(), Schema.generateNestedSchema((byte)120, 15)));
        funcList.add(new FuncSpec(BigDecimalAvg.class.getName(), Schema.generateNestedSchema((byte)120, 70)));
        funcList.add(new FuncSpec(BigIntegerAvg.class.getName(), Schema.generateNestedSchema((byte)120, 65)));
        return funcList;
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            double count;
            Double sum = AVG.sum(b);
            if (sum == null) {
                return;
            }
            if (this.intermediateSum == null || this.intermediateCount == null) {
                this.intermediateSum = 0.0;
                this.intermediateCount = 0.0;
            }
            if ((count = (double)Long.valueOf(AVG.count(b)).longValue()) > 0.0) {
                this.intermediateCount = this.intermediateCount + count;
                this.intermediateSum = this.intermediateSum + sum;
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing average in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateSum = null;
        this.intermediateCount = null;
    }

    @Override
    public Double getValue() {
        Double avg = null;
        if (this.intermediateCount != null && this.intermediateCount > 0.0) {
            avg = new Double(this.intermediateSum / this.intermediateCount);
        }
        return avg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                Tuple combined = AVG.combine(b);
                Double sum = (Double)combined.get(0);
                if (sum == null) {
                    return null;
                }
                double count = ((Long)combined.get(1)).longValue();
                Double avg = null;
                if (count > 0.0) {
                    avg = new Double(sum / count);
                }
                return avg;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermediate
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                return AVG.combine(b);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            Tuple t = mTupleFactory.newTuple(2);
            try {
                DataBag bg = (DataBag)input.get(0);
                DataByteArray dba = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    dba = (DataByteArray)tp.get(0);
                }
                t.set(0, dba != null ? Double.valueOf(dba.toString()) : null);
                if (dba == null) {
                    t.set(1, 0L);
                } else {
                    t.set(1, 1L);
                }
                return t;
            }
            catch (NumberFormatException nfe) {
                t.set(0, null);
                t.set(1, 0L);
                return t;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

