/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.OptimizerUtils;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class PushUpFilter
extends Rule {
    public PushUpFilter(String n) {
        super(n, false);
    }

    public Transformer getNewTransformer() {
        return new PushUpFilterTransformer();
    }

    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOFilter op1 = new LOFilter(plan);
        plan.add(op1);
        return plan;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PushUpFilterTransformer
    extends Transformer {
        private OperatorSubPlan subPlan;

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            Operator current = matched.getSources().get(0);
            Operator pred = this.findNonFilterPredecessor(current);
            if (pred == null) {
                return false;
            }
            if (pred instanceof LOSort || pred instanceof LOUnion) {
                return true;
            }
            if (pred instanceof LOLoad || pred instanceof LOStore || pred instanceof LOStream || pred instanceof LOFilter || pred instanceof LOSplit || pred instanceof LOSplitOutput || pred instanceof LOLimit || pred instanceof LONative || pred instanceof LOForEach) {
                return false;
            }
            LOFilter filter = (LOFilter)current;
            List<Operator> preds = PushUpFilter.this.currentPlan.getPredecessors(pred);
            LogicalExpressionPlan filterPlan = filter.getFilterPlan();
            if (OptimizerUtils.planHasNonDeterministicUdf(filterPlan)) {
                return false;
            }
            if (pred instanceof LODistinct) {
                return true;
            }
            Set<Long> uids = this.collectUidFromExpPlan(filterPlan);
            if (pred instanceof LOCogroup) {
                LOCogroup cogrp = (LOCogroup)pred;
                if (preds.size() == 1 ? this.hasAll((LogicalRelationalOperator)preds.get(0), uids) : 1 == cogrp.getExpressionPlans().get(0).size() && !this.containUDF(filterPlan)) {
                    return true;
                }
            }
            if (pred instanceof LOCross || pred instanceof LOJoin) {
                boolean[] innerFlags = null;
                boolean isFullOuter = true;
                boolean isInner = true;
                if (pred instanceof LOJoin) {
                    for (boolean inner : innerFlags = ((LOJoin)pred).getInnerFlags()) {
                        if (inner) {
                            isFullOuter = false;
                            continue;
                        }
                        isInner = false;
                    }
                    if (isFullOuter) {
                        return false;
                    }
                }
                for (int j = 0; j < preds.size(); ++j) {
                    if (!this.hasAll((LogicalRelationalOperator)preds.get(j), uids) || !(pred instanceof LOCross) && (!(pred instanceof LOJoin) || !isInner && !innerFlags[j])) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean containUDF(LogicalExpressionPlan filterPlan) {
            Iterator<Operator> it = filterPlan.getOperators();
            while (it.hasNext()) {
                if (!(it.next() instanceof UserFuncExpression)) continue;
                return true;
            }
            return false;
        }

        Set<Long> collectUidFromExpPlan(LogicalExpressionPlan filterPlan) throws FrontendException {
            HashSet<Long> uids = new HashSet<Long>();
            Iterator<Operator> iter = filterPlan.getOperators();
            while (iter.hasNext()) {
                Operator op = iter.next();
                if (!(op instanceof ProjectExpression)) continue;
                long uid = ((ProjectExpression)op).getFieldSchema().uid;
                uids.add(uid);
            }
            return uids;
        }

        private Operator findNonFilterPredecessor(Operator current) {
            Operator pred;
            Operator op = current;
            while (true) {
                List<Operator> predecessors;
                if ((predecessors = PushUpFilter.this.currentPlan.getPredecessors(op)) == null || predecessors.size() == 0) {
                    return null;
                }
                pred = predecessors.get(0);
                if (!(pred instanceof LOFilter)) break;
                op = pred;
            }
            return pred;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.subPlan = new OperatorSubPlan(PushUpFilter.this.currentPlan);
            LOFilter filter = (LOFilter)matched.getSources().get(0);
            Operator predecessor = this.findNonFilterPredecessor(filter);
            this.subPlan.add(predecessor);
            Operator predec = PushUpFilter.this.currentPlan.getPredecessors(filter).get(0);
            Operator succed = PushUpFilter.this.currentPlan.getSuccessors(filter) != null ? PushUpFilter.this.currentPlan.getSuccessors(filter).get(0) : null;
            Pair<Integer, Integer> p1 = PushUpFilter.this.currentPlan.disconnect(predec, filter);
            if (succed != null) {
                this.subPlan.add(succed);
                Pair<Integer, Integer> p2 = PushUpFilter.this.currentPlan.disconnect(filter, succed);
                PushUpFilter.this.currentPlan.connect(predec, (Integer)p1.first, succed, (Integer)p2.second);
            }
            if (predecessor instanceof LOSort || predecessor instanceof LODistinct || predecessor instanceof LOCogroup && PushUpFilter.this.currentPlan.getPredecessors(predecessor).size() == 1) {
                Operator prev = PushUpFilter.this.currentPlan.getPredecessors(predecessor).get(0);
                this.insertFilter(prev, predecessor, filter);
                return;
            }
            LogicalExpressionPlan filterPlan = filter.getFilterPlan();
            List<Operator> preds = PushUpFilter.this.currentPlan.getPredecessors(predecessor);
            Map<Integer, Operator> inputs = this.findInputsToAddFilter(filterPlan, predecessor, preds);
            LOFilter newFilter = null;
            for (Map.Entry<Integer, Operator> entry : inputs.entrySet()) {
                int inputIndex = entry.getKey();
                Operator pred = entry.getValue();
                int columnOffset = 0;
                if (predecessor instanceof LOJoin || predecessor instanceof LOCross) {
                    for (int i = 0; i < inputIndex; ++i) {
                        columnOffset += ((LogicalRelationalOperator)preds.get(i)).getSchema().size();
                    }
                }
                newFilter = newFilter == null ? filter : new LOFilter((LogicalPlan)PushUpFilter.this.currentPlan);
                PushUpFilter.this.currentPlan.add(newFilter);
                this.subPlan.add(newFilter);
                this.subPlan.add(pred);
                LogicalExpressionPlan fPlan = filterPlan.deepCopy();
                List<Operator> sinks = fPlan.getSinks();
                ArrayList<ProjectExpression> projExprs = new ArrayList<ProjectExpression>();
                for (Operator sink : sinks) {
                    if (!(sink instanceof ProjectExpression)) continue;
                    projExprs.add((ProjectExpression)sink);
                }
                if (predecessor instanceof LOCogroup) {
                    for (ProjectExpression projExpr : projExprs) {
                        LogicalExpressionPlan plan = ((LOCogroup)predecessor).getExpressionPlans().get(inputIndex).iterator().next();
                        LogicalExpressionPlan copy = plan.deepCopy();
                        LogicalExpression root = (LogicalExpression)copy.getSinks().get(0);
                        List<Operator> predecessors = fPlan.getPredecessors(projExpr);
                        if (predecessors == null || predecessors.size() == 0) {
                            fPlan.remove(projExpr);
                            fPlan.add(root);
                            continue;
                        }
                        fPlan.add(root);
                        Operator pred1 = predecessors.get(0);
                        Pair<Integer, Integer> pair = fPlan.disconnect(pred1, projExpr);
                        fPlan.connect(pred1, (Integer)pair.first, root, (Integer)pair.second);
                        fPlan.remove(projExpr);
                    }
                }
                sinks = fPlan.getSinks();
                for (Operator sink : sinks) {
                    if (!(sink instanceof ProjectExpression)) continue;
                    ProjectExpression projE = (ProjectExpression)sink;
                    projE.setAttachedRelationalOp(newFilter);
                    projE.setInputNum(0);
                    projE.setColNum(projE.getColNum() - columnOffset);
                }
                newFilter.setFilterPlan(fPlan);
                this.insertFilter(pred, predecessor, newFilter);
            }
        }

        private boolean hasAll(LogicalRelationalOperator op, Set<Long> uids) throws FrontendException {
            LogicalSchema schema = op.getSchema();
            if (schema == null) {
                return false;
            }
            for (long uid : uids) {
                if (schema.findField(uid) != -1) continue;
                return false;
            }
            return true;
        }

        @Override
        public OperatorPlan reportChanges() {
            return PushUpFilter.this.currentPlan;
        }

        private void insertFilter(Operator prev, Operator predecessor, LOFilter filter) throws FrontendException {
            Pair<Integer, Integer> p3 = PushUpFilter.this.currentPlan.disconnect(prev, predecessor);
            PushUpFilter.this.currentPlan.connect(prev, (Integer)p3.first, filter, 0);
            PushUpFilter.this.currentPlan.connect(filter, 0, predecessor, (Integer)p3.second);
        }

        private Map<Integer, Operator> findInputsToAddFilter(LogicalExpressionPlan filterPlan, Operator predecessor, List<Operator> preds) throws FrontendException {
            HashMap<Integer, Operator> inputs = new HashMap<Integer, Operator>();
            if (predecessor instanceof LOUnion || predecessor instanceof LOCogroup) {
                for (int i = 0; i < preds.size(); ++i) {
                    inputs.put(i, preds.get(i));
                }
                return inputs;
            }
            Set<Long> uids = this.collectUidFromExpPlan(filterPlan);
            boolean[] innerFlags = null;
            boolean isInner = true;
            if (predecessor instanceof LOJoin) {
                for (boolean inner : innerFlags = ((LOJoin)predecessor).getInnerFlags()) {
                    if (inner) continue;
                    isInner = false;
                    break;
                }
            }
            for (int j = 0; j < preds.size(); ++j) {
                if (!this.hasAll((LogicalRelationalOperator)preds.get(j), uids) || !(predecessor instanceof LOCross) && (!(predecessor instanceof LOJoin) || !isInner && !innerFlags[j])) continue;
                Operator input = preds.get(j);
                this.subPlan.add(input);
                inputs.put(j, input);
            }
            return inputs;
        }
    }
}

