/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;

public class DanglingNestedNodeRemover
extends LogicalRelationalNodesVisitor {
    public DanglingNestedNodeRemover(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    public void visit(LOForEach foreach) throws FrontendException {
        LogicalPlan innerPlan = foreach.getInnerPlan();
        ArrayList<Operator> opsToRemove = new ArrayList<Operator>();
        Iterator<Operator> ops = innerPlan.getOperators();
        while (ops.hasNext()) {
            Operator op;
            Operator currentOp = op = ops.next();
            boolean endWithNoLOGenerate = false;
            while (!(currentOp instanceof LOGenerate)) {
                if (innerPlan.getSuccessors(currentOp) == null) {
                    endWithNoLOGenerate = true;
                    break;
                }
                currentOp = innerPlan.getSuccessors(currentOp).get(0);
            }
            if (!endWithNoLOGenerate) continue;
            opsToRemove.add(op);
        }
        for (Operator op : opsToRemove) {
            innerPlan.removeAndReconnect(op);
        }
    }
}

