/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LogicalPlanData {
    private final LogicalPlan lp;
    private int numLogicalRelationalOperators;
    private final List<LOLoad> sources;
    private final List<LOStore> sinks;

    public LogicalPlanData(LogicalPlan lp) {
        if (lp == null) {
            throw new RuntimeException("LogicalPlan is null.");
        }
        this.lp = lp;
        this.numLogicalRelationalOperators = 0;
        this.sources = Lists.newArrayList();
        this.sinks = Lists.newArrayList();
        this.init();
    }

    private void init() {
        Iterator<Operator> ops = this.lp.getOperators();
        while (ops.hasNext()) {
            Operator op = ops.next();
            if (!(op instanceof LogicalRelationalOperator)) continue;
            ++this.numLogicalRelationalOperators;
            if (op instanceof LOLoad) {
                this.sources.add((LOLoad)op);
                continue;
            }
            if (!(op instanceof LOStore)) continue;
            this.sinks.add((LOStore)op);
        }
    }

    public int getNumLogicalRelationOperators() {
        return this.numLogicalRelationalOperators;
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public int getNumSinks() {
        return this.sinks.size();
    }

    public List<String> getSources() {
        ArrayList<String> result = Lists.newArrayList();
        for (LOLoad load : this.sources) {
            result.add(load.getFileSpec().getFileName());
        }
        return result;
    }

    public List<String> getSinks() {
        ArrayList<String> result = Lists.newArrayList();
        for (LOStore sink : this.sinks) {
            result.add(sink.getFileSpec().getFileName());
        }
        return result;
    }

    public List<String> getLoadFuncs() {
        ArrayList<String> result = Lists.newArrayList();
        for (LOLoad load : this.sources) {
            result.add(load.getFileSpec().getFuncName());
        }
        return result;
    }

    public List<String> getStoreFuncs() {
        ArrayList<String> storeFuncs = Lists.newArrayList();
        for (LOStore sink : this.sinks) {
            storeFuncs.add(sink.getFileSpec().getFuncName());
        }
        return storeFuncs;
    }
}

