/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class PONot
extends UnaryComparisonOperator {
    private static final long serialVersionUID = 1L;
    private Result trueRes;
    private Result falseRes;

    public PONot(OperatorKey k) {
        this(k, -1);
    }

    public PONot(OperatorKey k, int rp) {
        super(k, rp);
        this.resultType = (byte)5;
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitNot(this);
    }

    public String name() {
        return "Not[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    public Result getNextBoolean() throws ExecException {
        if (this.trueRes == null) {
            this.trueRes = new Result();
            this.trueRes.returnStatus = 0;
            this.trueRes.result = true;
            this.falseRes = new Result();
            this.falseRes.returnStatus = 0;
            this.falseRes.result = false;
        }
        this.res = this.expr.getNextBoolean();
        if (this.res.returnStatus != 0 || this.res.result == null) {
            return this.res;
        }
        if (((Boolean)this.res.result).booleanValue()) {
            this.illustratorMarkup(null, this.falseRes.result, 1);
            return this.falseRes;
        }
        this.illustratorMarkup(null, this.trueRes.result, 0);
        return this.trueRes;
    }

    public PONot clone() throws CloneNotSupportedException {
        PONot clone = new PONot(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

