/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LogicalPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlanPrinter
extends PlanVisitor {
    private PrintStream mStream = null;
    private byte[] TAB1 = "    ".getBytes();
    private byte[] TABMore = "|   ".getBytes();
    private byte[] Bar = "|\n".getBytes();
    private byte[] LSep = "|---".getBytes();
    private byte[] USep = "|   |\n".getBytes();
    public static String SEPERATE = "\t";
    protected ArrayList<byte[]> tabs;
    protected boolean reverse = false;

    public LogicalPlanPrinter(OperatorPlan plan, PrintStream ps) throws FrontendException {
        this(plan, ps, new ArrayList<byte[]>());
    }

    private LogicalPlanPrinter(OperatorPlan plan, PrintStream ps, ArrayList<byte[]> tabs) throws FrontendException {
        super(plan, null);
        this.mStream = ps;
        this.tabs = tabs;
        this.reverse = !(plan instanceof LogicalPlan);
    }

    @Override
    public void visit() throws FrontendException {
        try {
            this.depthFirstLP();
        }
        catch (IOException e) {
            throw new FrontendException(e);
        }
    }

    protected void depthFirstLP() throws FrontendException, IOException {
        List<Operator> leaves = this.reverse ? this.plan.getSources() : this.plan.getSinks();
        for (Operator leaf : leaves) {
            this.writeWithTabs((leaf.toString() + "\n").getBytes());
            this.depthFirst(leaf);
        }
    }

    private void writeWithTabs(byte[] data) throws IOException {
        for (byte[] tab : this.tabs) {
            this.mStream.write(tab);
        }
        this.mStream.write(data);
    }

    private void depthFirst(Operator node) throws FrontendException, IOException {
        this.printNodePlan(node);
        List<Operator> operators = this.reverse ? this.plan.getSuccessors(node) : this.plan.getPredecessors(node);
        if (operators == null) {
            return;
        }
        ArrayList<Operator> predecessors = new ArrayList<Operator>(operators);
        int i = 0;
        for (Operator pred : predecessors) {
            this.writeWithTabs(this.Bar);
            this.writeWithTabs(this.LSep);
            this.mStream.write((pred.toString() + "\n").getBytes());
            if (++i < predecessors.size()) {
                this.tabs.add(this.TABMore);
            } else {
                this.tabs.add(this.TAB1);
            }
            this.depthFirst(pred);
            this.tabs.remove(this.tabs.size() - 1);
        }
    }

    private void printPlan(OperatorPlan lp) throws VisitorException, IOException {
        this.writeWithTabs(this.USep);
        this.tabs.add(this.TABMore);
        if (lp != null) {
            LogicalPlanPrinter printer = new LogicalPlanPrinter(lp, this.mStream, this.tabs);
            printer.visit();
        }
        this.tabs.remove(this.tabs.size() - 1);
    }

    private void printNodePlan(Operator node) throws FrontendException, IOException {
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            if (!(node instanceof LOFilter)) break block7;
                                            this.printPlan(((LOFilter)node).getFilterPlan());
                                            break block8;
                                        }
                                        if (!(node instanceof LOLimit)) break block9;
                                        this.printPlan(((LOLimit)node).getLimitPlan());
                                        break block8;
                                    }
                                    if (!(node instanceof LOForEach)) break block10;
                                    this.printPlan(((LOForEach)node).getInnerPlan());
                                    break block8;
                                }
                                if (!(node instanceof LOCogroup)) break block11;
                                MultiMap<Integer, LogicalExpressionPlan> plans = ((LOCogroup)node).getExpressionPlans();
                                for (int i : plans.keySet()) {
                                    for (OperatorPlan operatorPlan : plans.get(i)) {
                                        this.printPlan(operatorPlan);
                                    }
                                }
                                break block8;
                            }
                            if (!(node instanceof LOJoin)) break block12;
                            MultiMap<Integer, LogicalExpressionPlan> plans = ((LOJoin)node).getExpressionPlans();
                            for (int i : plans.keySet()) {
                                for (OperatorPlan operatorPlan : plans.get(i)) {
                                    this.printPlan(operatorPlan);
                                }
                            }
                            break block8;
                        }
                        if (!(node instanceof LORank)) break block13;
                        for (OperatorPlan operatorPlan : ((LORank)node).getRankColPlans()) {
                            this.printPlan(operatorPlan);
                        }
                        break block8;
                    }
                    if (!(node instanceof LOSort)) break block14;
                    for (OperatorPlan operatorPlan : ((LOSort)node).getSortColPlans()) {
                        this.printPlan(operatorPlan);
                    }
                    break block8;
                }
                if (!(node instanceof LOSplitOutput)) break block15;
                this.printPlan(((LOSplitOutput)node).getFilterPlan());
                break block8;
            }
            if (!(node instanceof LOGenerate)) break block8;
            for (OperatorPlan operatorPlan : ((LOGenerate)node).getOutputPlans()) {
                this.printPlan(operatorPlan);
            }
        }
    }
}

