/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.AbstractTuple;
import org.apache.pig.data.BinInterSedes;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.FieldIsNullException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TypeAwareTuple;
import org.apache.pig.data.utils.MethodHelper;
import org.apache.pig.data.utils.SedesHelper;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mortbay.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class SchemaTuple<T extends SchemaTuple<T>>
extends AbstractTuple
implements TypeAwareTuple {
    private static final long serialVersionUID = 1L;
    private static final int ONE_MINUTE = 60000;
    private static final BinInterSedes bis = new BinInterSedes();

    @Override
    @MethodHelper.NotImplemented
    public void append(Object val) {
        throw MethodHelper.methodNotImplemented();
    }

    @Override
    public long getMemorySize() {
        return 16L + this.getGeneratedCodeMemorySize();
    }

    protected abstract long getGeneratedCodeMemorySize();

    public abstract int getSchemaTupleIdentifier();

    protected abstract int schemaSize();

    public String getSchemaString() {
        return this.getSchema().toString();
    }

    protected SchemaTuple<T> set(SchemaTuple<?> t, boolean checkType) throws ExecException {
        return this.generatedCodeSet(t, checkType);
    }

    protected abstract SchemaTuple<T> generatedCodeSet(SchemaTuple<?> var1, boolean var2) throws ExecException;

    protected SchemaTuple<T> setSpecific(T t) {
        return this.generatedCodeSetSpecific(t);
    }

    protected abstract SchemaTuple<T> generatedCodeSetSpecific(T var1);

    public SchemaTuple<T> set(Tuple t) throws ExecException {
        return this.set(t, true);
    }

    protected SchemaTuple<T> set(Tuple t, boolean checkType) throws ExecException {
        if (checkType) {
            if (this.isSpecificSchemaTuple(t)) {
                return this.setSpecific((SchemaTuple)t);
            }
            if (t instanceof SchemaTuple) {
                return this.set((SchemaTuple)t, false);
            }
        }
        return this.set(t.getAll());
    }

    public SchemaTuple<T> set(SchemaTuple<?> t) throws ExecException {
        return this.set(t, true);
    }

    public SchemaTuple<T> set(List<Object> l) throws ExecException {
        if (l.size() != this.schemaSize()) {
            throw new ExecException("Given list of objects has improper number of fields (" + l.size() + " vs " + this.schemaSize() + ")");
        }
        this.generatedCodeSetIterator(l.iterator());
        return this;
    }

    protected abstract void generatedCodeSetIterator(Iterator<Object> var1) throws ExecException;

    protected void write(DataOutput out, boolean writeIdentifiers) throws IOException {
        if (writeIdentifiers) {
            int id = this.getSchemaTupleIdentifier();
            if (id < 255) {
                out.writeByte(28);
                out.writeByte(id);
            } else if (id < 65535) {
                out.writeByte(29);
                out.writeShort(id);
            } else {
                out.writeByte(30);
                out.writeInt(id);
            }
        }
        this.writeElements(out);
    }

    protected static void write(DataOutput out, DataBag v) throws IOException {
        bis.writeDatum(out, v, (byte)120);
    }

    protected static void write(DataOutput out, Map<String, Object> v) throws IOException {
        bis.writeDatum(out, v, (byte)100);
    }

    protected static void write(DataOutput out, int v) throws IOException {
        SedesHelper.Varint.writeSignedVarInt(v, out);
    }

    protected static void write(DataOutput out, long v) throws IOException {
        SedesHelper.Varint.writeSignedVarLong(v, out);
    }

    protected static void write(DataOutput out, float v) throws IOException {
        out.writeFloat(v);
    }

    protected static void write(DataOutput out, double v) throws IOException {
        out.writeDouble(v);
    }

    protected static void write(DataOutput out, DateTime v) throws IOException {
        out.writeLong(v.getMillis());
        out.writeShort(v.getZone().getOffset(v) / 60000);
    }

    protected static void write(DataOutput out, BigDecimal v) throws IOException {
        bis.writeDatum(out, v, (byte)70);
    }

    protected static void write(DataOutput out, BigInteger v) throws IOException {
        bis.writeDatum(out, v, (byte)65);
    }

    protected static void write(DataOutput out, byte[] v) throws IOException {
        SedesHelper.writeBytes(out, v);
    }

    protected static void write(DataOutput out, String v) throws IOException {
        SedesHelper.writeChararray(out, v);
    }

    protected static void write(DataOutput out, SchemaTuple<?> t) throws IOException {
        t.writeElements(out);
    }

    protected static DataBag read(DataInput in, DataBag v) throws IOException {
        return (DataBag)bis.readDatum(in);
    }

    protected static Map<String, Object> read(DataInput in, Map<String, Object> v) throws IOException {
        return (Map)bis.readDatum(in);
    }

    protected static int read(DataInput in, int v) throws IOException {
        return SedesHelper.Varint.readSignedVarInt(in);
    }

    protected static long read(DataInput in, long v) throws IOException {
        return SedesHelper.Varint.readSignedVarLong(in);
    }

    protected static float read(DataInput in, float v) throws IOException {
        return in.readFloat();
    }

    protected static double read(DataInput in, double v) throws IOException {
        return in.readDouble();
    }

    protected static DateTime read(DataInput in, DateTime v) throws IOException {
        return new DateTime(in.readLong(), DateTimeZone.forOffsetMillis(in.readShort() * 60000));
    }

    protected static BigDecimal read(DataInput in, BigDecimal v) throws IOException {
        return (BigDecimal)bis.readDatum(in);
    }

    protected static BigInteger read(DataInput in, BigInteger v) throws IOException {
        return (BigInteger)bis.readDatum(in);
    }

    protected static String read(DataInput in, String v) throws IOException {
        return SedesHelper.readChararray(in, in.readByte());
    }

    protected static byte[] read(DataInput in, byte[] v) throws IOException {
        return SedesHelper.readBytes(in, in.readByte());
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, true);
    }

    @Override
    public void reference(Tuple t) {
        try {
            this.set(t);
        }
        catch (ExecException e) {
            throw new RuntimeException("Failure to set given tuple: " + t, e);
        }
    }

    @Override
    public List<Object> getAll() {
        ArrayList<Object> l = Lists.newArrayListWithCapacity(this.size());
        for (int i = 0; i < this.size(); ++i) {
            try {
                l.add(this.get(i));
                continue;
            }
            catch (ExecException e) {
                throw new RuntimeException("Error getting index " + i + " from SchemaTuple", e);
            }
        }
        return l;
    }

    public abstract boolean isSpecificSchemaTuple(Object var1);

    public int compareTo(Object other) {
        if (this.isSpecificSchemaTuple(other)) {
            return this.compareToSpecific((SchemaTuple)other);
        }
        if (other instanceof SchemaTuple) {
            return this.compareTo((SchemaTuple)other, false);
        }
        if (other instanceof Tuple) {
            return this.compareTo((Tuple)other, false);
        }
        return DataType.compare(this, other);
    }

    public int compareTo(Tuple t) {
        return this.compareTo(t, true);
    }

    protected int compareTo(Tuple t, boolean checkType) {
        if (checkType) {
            if (this.isSpecificSchemaTuple(t)) {
                return this.compareToSpecific((SchemaTuple)t);
            }
            if (t instanceof SchemaTuple) {
                return this.compareTo((SchemaTuple)t, false);
            }
        }
        int mySz = this.size();
        int tSz = t.size();
        if (tSz < mySz) {
            return 1;
        }
        if (tSz > mySz) {
            return -1;
        }
        for (int i = 0; i < mySz; ++i) {
            try {
                int c = DataType.compare(this.get(i), t.get(i));
                if (c == 0) continue;
                return c;
            }
            catch (ExecException e) {
                throw new RuntimeException("Unable to compare tuples, t1 class = " + this.getClass() + ", t2 class = " + t.getClass(), e);
            }
        }
        return 0;
    }

    public int compareTo(SchemaTuple<?> t) {
        return this.compareTo(t, true);
    }

    protected int compareTo(SchemaTuple<?> t, boolean checkType) {
        if (checkType && this.isSpecificSchemaTuple(t)) {
            return this.compareToSpecific(t);
        }
        int i = this.compareSize(t);
        if (i != 0) {
            return i;
        }
        return this.generatedCodeCompareTo(t, checkType);
    }

    protected abstract int generatedCodeCompareTo(SchemaTuple<?> var1, boolean var2);

    protected int compareToSpecific(T t) {
        return this.generatedCodeCompareToSpecific(t);
    }

    protected abstract int generatedCodeCompareToSpecific(T var1);

    @Override
    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    protected DataBag unbox(Object v, DataBag t) {
        return this.unbox((DataBag)v);
    }

    protected Map<String, Object> unbox(Object v, Map<String, Object> t) {
        return this.unbox((Map)v);
    }

    protected byte[] unbox(Object v, byte[] t) {
        return this.unbox((DataByteArray)v);
    }

    protected int unbox(Object v, int t) {
        return this.unbox((Integer)v);
    }

    protected long unbox(Object v, long t) {
        return this.unbox((Long)v);
    }

    protected float unbox(Object v, float t) {
        return this.unbox((Float)v);
    }

    protected double unbox(Object v, double t) {
        return this.unbox((Double)v);
    }

    protected boolean unbox(Object v, boolean t) {
        return this.unbox((Boolean)v);
    }

    protected DateTime unbox(Object v, DateTime t) {
        return (DateTime)v;
    }

    protected BigDecimal unbox(Object v, BigDecimal t) {
        return (BigDecimal)v;
    }

    protected BigInteger unbox(Object v, BigInteger t) {
        return (BigInteger)v;
    }

    protected String unbox(Object v, String t) {
        return (String)v;
    }

    protected Tuple unbox(Object v, Tuple t) {
        return (Tuple)v;
    }

    protected DataBag unbox(DataBag v) {
        return v;
    }

    protected Map<String, Object> unbox(Map<String, Object> v) {
        return v;
    }

    protected byte[] unbox(DataByteArray v) {
        if (v == null) {
            return null;
        }
        return v.get();
    }

    protected int unbox(Integer v) {
        return v;
    }

    protected long unbox(Long v) {
        return v;
    }

    protected float unbox(Float v) {
        return v.floatValue();
    }

    protected double unbox(Double v) {
        return v;
    }

    protected boolean unbox(Boolean v) {
        return v;
    }

    protected DateTime unbox(DateTime v) {
        return v;
    }

    protected DataBag box(DataBag v) {
        return v;
    }

    protected Map<String, Object> box(Map<String, Object> v) {
        return v;
    }

    protected DataByteArray box(byte[] v) {
        if (v == null) {
            return null;
        }
        return new DataByteArray(v);
    }

    protected String box(String v) {
        return v;
    }

    protected Tuple box(Tuple t) {
        return t;
    }

    protected Integer box(int v) {
        return new Integer(v);
    }

    protected Long box(long v) {
        return new Long(v);
    }

    protected Float box(float v) {
        return new Float(v);
    }

    protected Double box(double v) {
        return new Double(v);
    }

    protected Boolean box(boolean v) {
        return new Boolean(v);
    }

    protected DateTime box(DateTime v) {
        return v;
    }

    protected BigDecimal box(BigDecimal v) {
        return v;
    }

    protected BigInteger box(BigInteger v) {
        return v;
    }

    protected int hashCodePiece(int hash, int v, boolean isNull) {
        return isNull ? hash : 31 * hash + v;
    }

    protected int hashCodePiece(int hash, long v, boolean isNull) {
        return isNull ? hash : 31 * hash + (int)(v ^ v >>> 32);
    }

    protected int hashCodePiece(int hash, float v, boolean isNull) {
        return isNull ? hash : 31 * hash + Float.floatToIntBits(v);
    }

    protected int hashCodePiece(int hash, double v, boolean isNull) {
        long v2 = Double.doubleToLongBits(v);
        return isNull ? hash : 31 * hash + (int)(v2 ^ v2 >>> 32);
    }

    protected int hashCodePiece(int hash, boolean v, boolean isNull) {
        return isNull ? hash : 31 * hash + (v ? 1231 : 1237);
    }

    protected int hashCodePiece(int hash, DateTime v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    protected int hashCodePiece(int hash, BigDecimal v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    protected int hashCodePiece(int hash, BigInteger v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    protected int hashCodePiece(int hash, byte[] v, boolean isNull) {
        return isNull ? hash : 31 * hash + DataByteArray.hashCode(v);
    }

    protected int hashCodePiece(int hash, String v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    protected int hashCodePiece(int hash, Tuple v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    protected int hashCodePiece(int hash, DataBag v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    protected int hashCodePiece(int hash, Map<String, Object> v, boolean isNull) {
        return isNull ? hash : 31 * hash + v.hashCode();
    }

    public int hashCode() {
        return this.generatedCodeHashCode();
    }

    protected abstract int generatedCodeHashCode();

    @Override
    public void set(int fieldNum, Object val) throws ExecException {
        this.generatedCodeSetField(fieldNum, val);
    }

    public abstract void generatedCodeSetField(int var1, Object var2) throws ExecException;

    @Override
    public Object get(int fieldNum) throws ExecException {
        return this.generatedCodeGetField(fieldNum);
    }

    public abstract Object generatedCodeGetField(int var1) throws ExecException;

    @Override
    public boolean isNull(int fieldNum) throws ExecException {
        return this.isGeneratedCodeFieldNull(fieldNum);
    }

    public abstract boolean isGeneratedCodeFieldNull(int var1) throws ExecException;

    @Override
    public byte getType(int fieldNum) throws ExecException {
        return this.getGeneratedCodeFieldType(fieldNum);
    }

    public abstract byte getGeneratedCodeFieldType(int var1) throws ExecException;

    protected void setTypeAwareBase(int fieldNum, Object val, String type) throws ExecException {
        throw new ExecException("Given field " + fieldNum + " not a " + type + " field!");
    }

    protected Object getTypeAwareBase(int fieldNum, String type) throws ExecException {
        throw new ExecException("Given field " + fieldNum + " not a " + type + " field!");
    }

    @Override
    public void setInt(int fieldNum, int val) throws ExecException {
        this.generatedCodeSetInt(fieldNum, val);
    }

    protected abstract void generatedCodeSetInt(int var1, int var2) throws ExecException;

    @Override
    public void setLong(int fieldNum, long val) throws ExecException {
        this.generatedCodeSetLong(fieldNum, val);
    }

    protected abstract void generatedCodeSetLong(int var1, long var2) throws ExecException;

    @Override
    public void setFloat(int fieldNum, float val) throws ExecException {
        this.generatedCodeSetFloat(fieldNum, val);
    }

    protected abstract void generatedCodeSetFloat(int var1, float var2) throws ExecException;

    @Override
    public void setDouble(int fieldNum, double val) throws ExecException {
        this.generatedCodeSetDouble(fieldNum, val);
    }

    protected abstract void generatedCodeSetDouble(int var1, double var2) throws ExecException;

    @Override
    public void setBoolean(int fieldNum, boolean val) throws ExecException {
        this.generatedCodeSetBoolean(fieldNum, val);
    }

    protected abstract void generatedCodeSetBoolean(int var1, boolean var2) throws ExecException;

    @Override
    public void setDateTime(int fieldNum, DateTime val) throws ExecException {
        this.generatedCodeSetDateTime(fieldNum, val);
    }

    protected abstract void generatedCodeSetDateTime(int var1, DateTime var2) throws ExecException;

    @Override
    public void setBigDecimal(int fieldNum, BigDecimal val) throws ExecException {
        this.generatedCodeSetBigDecimal(fieldNum, val);
    }

    protected abstract void generatedCodeSetBigDecimal(int var1, BigDecimal var2) throws ExecException;

    @Override
    public void setBigInteger(int fieldNum, BigInteger val) throws ExecException {
        this.generatedCodeSetBigInteger(fieldNum, val);
    }

    protected abstract void generatedCodeSetBigInteger(int var1, BigInteger var2) throws ExecException;

    @Override
    public void setString(int fieldNum, String val) throws ExecException {
        this.generatedCodeSetString(fieldNum, val);
    }

    protected abstract void generatedCodeSetString(int var1, String var2) throws ExecException;

    @Override
    public void setTuple(int fieldNum, Tuple val) throws ExecException {
        this.generatedCodeSetTuple(fieldNum, val);
    }

    protected abstract void generatedCodeSetTuple(int var1, Tuple var2) throws ExecException;

    @Override
    public void setBytes(int fieldNum, byte[] val) throws ExecException {
        this.generatedCodeSetBytes(fieldNum, val);
    }

    protected abstract void generatedCodeSetBytes(int var1, byte[] var2) throws ExecException;

    @Override
    public void setDataBag(int fieldNum, DataBag val) throws ExecException {
        this.generatedCodeSetDataBag(fieldNum, val);
    }

    protected abstract void generatedCodeSetDataBag(int var1, DataBag var2) throws ExecException;

    @Override
    public void setMap(int fieldNum, Map<String, Object> val) throws ExecException {
        this.generatedCodeSetMap(fieldNum, val);
    }

    protected abstract void generatedCodeSetMap(int var1, Map<String, Object> var2) throws ExecException;

    private void errorIfNull(boolean isNull, String type) throws FieldIsNullException {
        if (isNull) {
            throw new FieldIsNullException("Desired field of type [" + type + "] was null!");
        }
    }

    protected int returnUnlessNull(boolean isNull, int val) throws FieldIsNullException {
        this.errorIfNull(isNull, "int");
        return val;
    }

    protected long returnUnlessNull(boolean isNull, long val) throws FieldIsNullException {
        this.errorIfNull(isNull, "long");
        return val;
    }

    protected float returnUnlessNull(boolean isNull, float val) throws FieldIsNullException {
        this.errorIfNull(isNull, "float");
        return val;
    }

    protected double returnUnlessNull(boolean isNull, double val) throws FieldIsNullException {
        this.errorIfNull(isNull, "double");
        return val;
    }

    protected boolean returnUnlessNull(boolean isNull, boolean val) throws FieldIsNullException {
        this.errorIfNull(isNull, "boolean");
        return val;
    }

    protected DateTime returnUnlessNull(boolean isNull, DateTime val) throws FieldIsNullException {
        this.errorIfNull(isNull, "DateTime");
        return val;
    }

    protected BigDecimal returnUnlessNull(boolean isNull, BigDecimal val) throws FieldIsNullException {
        this.errorIfNull(isNull, "BigDecimal");
        return val;
    }

    protected BigInteger returnUnlessNull(boolean isNull, BigInteger val) throws FieldIsNullException {
        this.errorIfNull(isNull, "BigInteger");
        return val;
    }

    protected Tuple returnUnlessNull(boolean isNull, Tuple val) throws FieldIsNullException {
        this.errorIfNull(isNull, "Tuple");
        return val;
    }

    protected String returnUnlessNull(boolean isNull, String val) throws FieldIsNullException {
        this.errorIfNull(isNull, "String");
        return val;
    }

    protected byte[] returnUnlessNull(boolean isNull, byte[] val) throws FieldIsNullException {
        this.errorIfNull(isNull, "byte");
        return val;
    }

    protected DataBag returnUnlessNull(boolean isNull, DataBag val) throws FieldIsNullException {
        this.errorIfNull(isNull, "DataBag");
        return val;
    }

    protected Map<String, Object> returnUnlessNull(boolean isNull, Map<String, Object> val) throws FieldIsNullException {
        this.errorIfNull(isNull, "Map<String,Object>");
        return val;
    }

    @Override
    public int getInt(int fieldNum) throws ExecException {
        return this.generatedCodeGetInt(fieldNum);
    }

    protected abstract int generatedCodeGetInt(int var1) throws ExecException;

    public int unboxInt(Object val) {
        return ((Number)val).intValue();
    }

    @Override
    public long getLong(int fieldNum) throws ExecException {
        return this.generatedCodeGetLong(fieldNum);
    }

    protected abstract long generatedCodeGetLong(int var1) throws ExecException;

    public long unboxLong(Object val) {
        return ((Number)val).longValue();
    }

    @Override
    public float getFloat(int fieldNum) throws ExecException {
        return this.generatedCodeGetFloat(fieldNum);
    }

    protected abstract float generatedCodeGetFloat(int var1) throws ExecException;

    public float unboxFloat(Object val) {
        return ((Number)val).floatValue();
    }

    @Override
    public double getDouble(int fieldNum) throws ExecException {
        return this.generatedCodeGetDouble(fieldNum);
    }

    protected abstract double generatedCodeGetDouble(int var1) throws ExecException;

    public double unboxDouble(Object val) {
        return ((Number)val).doubleValue();
    }

    @Override
    public boolean getBoolean(int fieldNum) throws ExecException {
        return this.generatedCodeGetBoolean(fieldNum);
    }

    protected abstract boolean generatedCodeGetBoolean(int var1) throws ExecException;

    public boolean unboxBoolean(Object val) {
        return (Boolean)val;
    }

    @Override
    public DateTime getDateTime(int fieldNum) throws ExecException {
        return this.generatedCodeGetDateTime(fieldNum);
    }

    protected abstract DateTime generatedCodeGetDateTime(int var1) throws ExecException;

    public DateTime unboxDateTime(Object val) {
        return (DateTime)val;
    }

    @Override
    public String getString(int fieldNum) throws ExecException {
        return this.generatedCodeGetString(fieldNum);
    }

    protected abstract String generatedCodeGetString(int var1) throws ExecException;

    public String unboxString(Object val) {
        return (String)val;
    }

    @Override
    public byte[] getBytes(int fieldNum) throws ExecException {
        return this.generatedCodeGetBytes(fieldNum);
    }

    public byte[] unboxBytes(Object val) {
        DataByteArray dba = (DataByteArray)val;
        return val == null ? null : dba.get();
    }

    protected abstract byte[] generatedCodeGetBytes(int var1) throws ExecException;

    @Override
    public Tuple getTuple(int fieldNum) throws ExecException {
        return this.generatedCodeGetTuple(fieldNum);
    }

    protected abstract Tuple generatedCodeGetTuple(int var1) throws ExecException;

    protected Tuple unboxTuple(Object val) {
        return (Tuple)val;
    }

    @Override
    public DataBag getDataBag(int fieldNum) throws ExecException {
        return this.generatedCodeGetDataBag(fieldNum);
    }

    protected abstract DataBag generatedCodeGetDataBag(int var1) throws ExecException;

    protected DataBag unboxDataBag(Object val) {
        return (DataBag)val;
    }

    @Override
    public Map<String, Object> getMap(int fieldNum) throws ExecException {
        return this.generatedCodeGetMap(fieldNum);
    }

    protected abstract Map<String, Object> generatedCodeGetMap(int var1) throws ExecException;

    protected Map<String, Object> unboxMap(Object val) {
        return (Map)val;
    }

    @Override
    public BigDecimal getBigDecimal(int fieldNum) throws ExecException {
        return this.generatedCodeGetBigDecimal(fieldNum);
    }

    protected abstract BigDecimal generatedCodeGetBigDecimal(int var1) throws ExecException;

    public BigDecimal unboxBigDecimal(Object val) {
        return (BigDecimal)val;
    }

    @Override
    public BigInteger getBigInteger(int fieldNum) throws ExecException {
        return this.generatedCodeGetBigInteger(fieldNum);
    }

    protected abstract BigInteger generatedCodeGetBigInteger(int var1) throws ExecException;

    public BigInteger unboxBigInteger(Object val) {
        return (BigInteger)val;
    }

    protected static Schema staticSchemaGen(String s) {
        try {
            if (s.equals("")) {
                Log.warn((String)"No Schema present in SchemaTuple generated class");
                return new Schema();
            }
            return (Schema)ObjectSerializer.deserialize(s);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize serialized Schema: " + s, e);
        }
    }

    public void setAndCatch(Tuple t) {
        try {
            this.set(t);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to set position with Tuple: " + t, e);
        }
    }

    public void setAndCatch(SchemaTuple<?> t) {
        try {
            this.set(t);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to set position with Tuple: " + t, e);
        }
    }

    protected void writeElements(DataOutput out) throws IOException {
        boolean[] b = this.generatedCodeNullsArray();
        SedesHelper.writeBooleanArray(out, b);
        this.generatedCodeWriteElements(out);
    }

    protected abstract void generatedCodeWriteElements(DataOutput var1) throws IOException;

    protected int compareSize(Tuple t) {
        return this.compare(this.size(), t.size());
    }

    protected int compareNull(boolean usNull, boolean themNull) {
        if (usNull && themNull) {
            return 2;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return 0;
    }

    protected int compareNull(boolean usNull, Tuple t, int pos) {
        boolean themNull;
        try {
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to check if position " + pos + " is null in Tuple: " + t, e);
        }
        return this.compareNull(usNull, themNull);
    }

    protected int compareElementAtPos(int val, SchemaTuple<?> t, int pos) {
        int themVal;
        try {
            themVal = t.getInt(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve int field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(val, themVal);
    }

    protected int compare(boolean usNull, int usVal, boolean themNull, int themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(int val, int themVal) {
        return val == themVal ? 0 : (val > themVal ? 1 : -1);
    }

    protected int compareWithElementAtPos(boolean isNull, int val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        int themVal;
        try {
            themVal = t.getInt(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve int field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, long usVal, boolean themNull, long themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(long val, long themVal) {
        return val == themVal ? 0 : (val > themVal ? 1 : -1);
    }

    protected int compareWithElementAtPos(boolean isNull, long val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        long themVal;
        try {
            themVal = t.getLong(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve long field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, float usVal, boolean themNull, float themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    public int compare(float val, float themVal) {
        return val == themVal ? 0 : (val > themVal ? 1 : -1);
    }

    protected int compareWithElementAtPos(boolean isNull, float val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        float themVal;
        try {
            themVal = t.getFloat(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve float field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, double usVal, boolean themNull, double themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(double val, double themVal) {
        return val == themVal ? 0 : (val > themVal ? 1 : -1);
    }

    protected int compareWithElementAtPos(boolean isNull, double val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        double themVal;
        try {
            themVal = t.getDouble(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve double field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, boolean usVal, boolean themNull, boolean themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(boolean val, boolean themVal) {
        if (val ^ themVal) {
            return val ? 1 : -1;
        }
        return 0;
    }

    protected int compareWithElementAtPos(boolean isNull, boolean val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        boolean themVal;
        try {
            themVal = t.getBoolean(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve boolean field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, byte[] usVal, boolean themNull, byte[] themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(byte[] val, byte[] themVal) {
        return DataByteArray.compare(val, themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, byte[] val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        byte[] themVal;
        try {
            themVal = t.getBytes(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve byte[] field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, DateTime usVal, boolean themNull, DateTime themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(DateTime val, DateTime themVal) {
        return val.compareTo(themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, DateTime val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        DateTime themVal;
        try {
            themVal = t.getDateTime(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve String field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, BigDecimal usVal, boolean themNull, BigDecimal themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(BigDecimal val, BigDecimal themVal) {
        return val.compareTo(themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, BigDecimal val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        BigDecimal themVal;
        try {
            themVal = t.getBigDecimal(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve String field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, BigInteger usVal, boolean themNull, BigInteger themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(BigInteger val, BigInteger themVal) {
        return val.compareTo(themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, BigInteger val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        BigInteger themVal;
        try {
            themVal = t.getBigInteger(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve String field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, String usVal, boolean themNull, String themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(String val, String themVal) {
        return val.compareTo(themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, String val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        String themVal;
        try {
            themVal = t.getString(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve String field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, DataBag usVal, boolean themNull, DataBag themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(DataBag val, DataBag themVal) {
        return val.compareTo(themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, DataBag val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        DataBag themVal;
        try {
            themVal = t.getDataBag(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve DataBag field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, Map<String, Object> usVal, boolean themNull, Map<String, Object> themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return this.compare(usVal, themVal);
    }

    protected int compare(Map<String, Object> val, Map<String, Object> themVal) {
        return DataType.compare(val, themVal, (byte)100, (byte)100);
    }

    protected int compareWithElementAtPos(boolean isNull, Map<String, Object> val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        Map<String, Object> themVal;
        try {
            themVal = t.getMap(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve DataBag field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compareWithElementAtPos(boolean isNull, SchemaTuple<?> val, SchemaTuple<?> t, int pos) {
        boolean themNull;
        Object themVal;
        try {
            themVal = t.get(pos);
            themNull = t.isNull(pos);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to retrieve double field " + pos + " in given Tuple: " + t, e);
        }
        return this.compare(isNull, val, themNull, themVal);
    }

    protected int compare(boolean usNull, SchemaTuple<?> usVal, boolean themNull, Object themVal) {
        if (usNull && themNull) {
            return 0;
        }
        if (themNull) {
            return 1;
        }
        if (usNull) {
            return -1;
        }
        return usVal.compareTo(themVal);
    }

    public abstract SchemaTupleQuickGenerator<T> getQuickGenerator();

    @Override
    public int size() {
        return this.generatedCodeSize();
    }

    protected abstract int generatedCodeSize();

    public void readFields(DataInput in) throws IOException {
        boolean[] b = SedesHelper.readBooleanArray(in, this.schemaSize());
        this.generatedCodeReadFields(in, b);
    }

    protected abstract void generatedCodeReadFields(DataInput var1, boolean[] var2) throws IOException;

    protected abstract boolean[] generatedCodeNullsArray() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SchemaTupleQuickGenerator<A> {
        public abstract A make();
    }
}

