/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POOptimizedForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.pen.Illustrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinPackager
extends Packager {
    private POOptimizedForEach forEach;
    private boolean newKey = true;
    private Tuple res = null;
    private static final Result eopResult = new Result(3, null);
    public static final String DEFAULT_CHUNK_SIZE = "1000";
    private long chunkSize = Long.parseLong("1000");
    private Result forEachResult;
    private DataBag[] dbs = null;
    private int lastBagIndex;
    private Iterator<Tuple> lastBagIter;

    public JoinPackager(Packager p, POForEach f) {
        String scope = f.getOperatorKey().getScope();
        NodeIdGenerator nig = NodeIdGenerator.getGenerator();
        this.forEach = new POOptimizedForEach(new OperatorKey(scope, nig.getNextNodeId(scope)));
        if (p != null) {
            this.setKeyType(p.getKeyType());
            this.setNumInputs(p.getNumInputs());
            this.lastBagIndex = this.numInputs - 1;
            this.setInner(p.getInner());
            this.setKeyInfo(p.getKeyInfo());
            this.isKeyTuple = p.isKeyTuple;
            this.isKeyCompound = p.isKeyCompound;
        }
        if (f != null) {
            this.setInputPlans(f.getInputPlans());
            this.setToBeFlattened(f.getToBeFlattened());
        }
    }

    @Override
    public Result getNext() throws ExecException {
        int i;
        Tuple it = null;
        if (this.newKey) {
            this.dbs = new DataBag[this.numInputs];
            for (i = 0; i < this.numInputs - 1; ++i) {
                this.dbs[i] = this.bags[i];
            }
            this.dbs[this.lastBagIndex] = new NonSpillableDataBag((int)this.chunkSize);
            this.lastBagIter = this.bags[this.lastBagIndex].iterator();
            if (!this.lastBagIter.hasNext()) {
                this.newKey = true;
                return eopResult;
            }
            this.res = mTupleFactory.newTuple(this.numInputs + 1);
            for (i = 0; i < this.dbs.length; ++i) {
                this.res.set(i + 1, this.dbs[i]);
            }
            this.res.set(0, this.key);
            for (i = 0; i < this.dbs.length - 1; ++i) {
                if (!this.inner[i] || this.dbs[i].size() != 0L) continue;
                this.detachInput();
                return eopResult;
            }
            this.newKey = false;
        }
        block11: while (this.lastBagIter.hasNext() || this.forEach.processingPlan) {
            block12: while (this.forEach.processingPlan) {
                this.forEachResult = this.forEach.getNextTuple();
                switch (this.forEachResult.returnStatus) {
                    case 0: 
                    case 2: {
                        return this.forEachResult;
                    }
                    case 1: {
                        continue block12;
                    }
                }
            }
            if (this.lastBagIter.hasNext()) {
                this.dbs[this.lastBagIndex].clear();
                i = 0;
                while ((long)i < this.chunkSize && this.lastBagIter.hasNext()) {
                    it = this.lastBagIter.next();
                    this.dbs[this.lastBagIndex].add(it);
                    ++i;
                }
            } else {
                this.detachInput();
                return eopResult;
            }
            this.forEach.attachInput(this.res);
            Result forEachResult = this.forEach.getNextTuple();
            switch (forEachResult.returnStatus) {
                case 0: 
                case 2: {
                    return forEachResult;
                }
                case 1: {
                    continue block11;
                }
            }
        }
        this.detachInput();
        return eopResult;
    }

    @Override
    public void attachInput(Object key, DataBag[] bags, boolean[] readOnce) throws ExecException {
        this.checkBagType();
        this.key = key;
        this.bags = bags;
        this.readOnce = readOnce;
        for (int i = 0; i < bags.length - 1; ++i) {
            if (!readOnce[i]) continue;
            DataBag materializedBag = this.getBag();
            materializedBag.addAll(bags[i]);
            bags[i] = materializedBag;
        }
        if (!readOnce[this.numInputs - 1]) {
            throw new ExecException("JoinPackager expects the last input to be streamed");
        }
        this.newKey = true;
    }

    public List<PhysicalPlan> getInputPlans() {
        return this.forEach.getInputPlans();
    }

    public void setInputPlans(List<PhysicalPlan> plans) {
        this.forEach.setInputPlans(plans);
    }

    public void setToBeFlattened(List<Boolean> flattens) {
        this.forEach.setToBeFlattened(flattens);
    }

    public POOptimizedForEach getForEach() {
        return this.forEach;
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        this.illustrator = illustrator;
        this.forEach.setIllustrator(illustrator);
    }

    @Override
    public String name() {
        return this.getClass().getSimpleName() + "(" + this.forEach.getFlatStr() + ")";
    }
}

