/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro.mapreduce;

import java.io.IOException;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.HadoopInput;

public abstract class AvroTrevniRecordReaderBase<K, V, T>
extends RecordReader<K, V> {
    private AvroColumnReader<T> reader;
    private float rows;
    private long row;
    private T mCurrentRecord;

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit file = (FileSplit)inputSplit;
        context.setStatus(file.toString());
        AvroColumnReader.Params params = new AvroColumnReader.Params(new HadoopInput(file.getPath(), context.getConfiguration()));
        params.setModel(ReflectData.get());
        if (AvroJob.getInputKeySchema(context.getConfiguration()) != null) {
            params.setSchema(AvroJob.getInputKeySchema(context.getConfiguration()));
        }
        this.reader = new AvroColumnReader(params);
        this.rows = this.reader.getRowCount();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.reader.hasNext()) {
            return false;
        }
        this.mCurrentRecord = this.reader.next();
        ++this.row;
        return true;
    }

    protected T getCurrentRecord() {
        return this.mCurrentRecord;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.row / this.rows;
    }
}

