/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroDatumConverter;
import org.apache.avro.hadoop.io.AvroDatumConverterFactory;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.trevni.avro.mapreduce.AvroTrevniRecordWriterBase;

public class AvroTrevniKeyValueRecordWriter<K, V>
extends AvroTrevniRecordWriterBase<AvroKey<K>, AvroValue<V>, GenericRecord> {
    Schema mKeyValuePairSchema;
    AvroKeyValue<Object, Object> keyValueRecord;
    AvroDatumConverter<K, ?> keyConverter;
    AvroDatumConverter<V, ?> valueConverter;

    public AvroTrevniKeyValueRecordWriter(TaskAttemptContext context) throws IOException {
        super(context);
        this.mKeyValuePairSchema = this.initSchema(context);
        this.keyValueRecord = new AvroKeyValue(new GenericData.Record(this.mKeyValuePairSchema));
    }

    public void write(AvroKey<K> key, AvroValue<V> value) throws IOException, InterruptedException {
        this.keyValueRecord.setKey(key.datum());
        this.keyValueRecord.setValue(value.datum());
        this.writer.write(this.keyValueRecord.get());
        if (this.writer.sizeEstimate() >= this.blockSize) {
            this.flush();
        }
    }

    @Override
    protected Schema initSchema(TaskAttemptContext context) {
        AvroDatumConverterFactory converterFactory = new AvroDatumConverterFactory(context.getConfiguration());
        this.keyConverter = converterFactory.create(context.getOutputKeyClass());
        this.valueConverter = converterFactory.create(context.getOutputValueClass());
        return AvroKeyValue.getSchema(this.keyConverter.getWriterSchema(), this.valueConverter.getWriterSchema());
    }
}

