/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class InputStats {
    private String name;
    private String location;
    private long bytes;
    private long records;
    private boolean success;
    private INPUT_TYPE type = INPUT_TYPE.regular;
    private Configuration conf;

    InputStats(String location, long bytes, long records, boolean success) {
        this.location = location;
        this.bytes = bytes;
        this.records = records;
        this.success = success;
        try {
            this.name = new Path(location).getName();
        }
        catch (Exception e) {
            this.name = location;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getNumberRecords() {
        return this.records;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public INPUT_TYPE getInputType() {
        return this.type;
    }

    String getDisplayString(boolean local) {
        StringBuilder sb = new StringBuilder();
        if (this.success) {
            sb.append("Successfully ");
            if (this.type == INPUT_TYPE.sampler) {
                sb.append("sampled ");
            } else if (this.type == INPUT_TYPE.indexer) {
                sb.append("indexed ");
            } else {
                sb.append("read ");
            }
            if (!local && this.records >= 0L) {
                sb.append(this.records).append(" records ");
            } else {
                sb.append("records ");
            }
            if (this.bytes > 0L) {
                sb.append("(").append(this.bytes).append(" bytes) ");
            }
            sb.append("from: \"").append(this.location).append("\"");
            if (this.type == INPUT_TYPE.side) {
                sb.append(" as side file");
            }
            sb.append("\n");
        } else {
            sb.append("Failed to read data from \"").append(this.location).append("\"\n");
        }
        return sb.toString();
    }

    void setConf(Configuration conf) {
        this.conf = conf;
    }

    void markSampleInput() {
        this.type = INPUT_TYPE.sampler;
    }

    void markIndexerInput() {
        this.type = INPUT_TYPE.indexer;
    }

    void markSideFileInput() {
        this.type = INPUT_TYPE.side;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum INPUT_TYPE {
        regular,
        sampler,
        indexer,
        side;

    }
}

