/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.HashOutputStream;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.DotLOPrinter;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanPrinter;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

public class LogicalPlan
extends BaseOperatorPlan {
    public LogicalPlan(LogicalPlan other) {
        super(other);
    }

    public LogicalPlan() {
    }

    public boolean isEqual(OperatorPlan other) throws FrontendException {
        if (other == null || !(other instanceof LogicalPlan)) {
            return false;
        }
        return super.isEqual(other);
    }

    public void explain(PrintStream ps, String format, boolean verbose) throws FrontendException {
        if (format.equals("xml")) {
            ps.println("<logicalPlan>XML Not Supported</logicalPlan>");
            return;
        }
        ps.println("#-----------------------------------------------");
        ps.println("# New Logical Plan:");
        ps.println("#-----------------------------------------------");
        if (this.size() == 0) {
            ps.println("Logical plan is empty.");
        } else if (format.equals("dot")) {
            DotLOPrinter lpp = new DotLOPrinter(this, ps);
            lpp.dump();
        } else {
            LogicalPlanPrinter npp = new LogicalPlanPrinter((OperatorPlan)this, ps);
            npp.visit();
        }
    }

    public Operator findByAlias(String alias) {
        Iterator<Operator> it = this.getOperators();
        ArrayList<LogicalRelationalOperator> ops = new ArrayList<LogicalRelationalOperator>();
        while (it.hasNext()) {
            LogicalRelationalOperator op = (LogicalRelationalOperator)it.next();
            if (op.getAlias() == null || !op.getAlias().equals(alias)) continue;
            ops.add(op);
        }
        if (ops.isEmpty()) {
            return null;
        }
        return (Operator)ops.get(ops.size() - 1);
    }

    public String getSignature() throws FrontendException {
        HashFunction hf = Hashing.goodFastHash(32);
        HashOutputStream hos = new HashOutputStream(hf);
        PrintStream ps = new PrintStream(hos);
        LogicalPlanPrinter printer = new LogicalPlanPrinter((OperatorPlan)this, ps);
        printer.visit();
        return Integer.toString(hos.getHashCode().asInt());
    }
}

