/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantExpression
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    Object value;
    Result res = new Result();

    public ConstantExpression(OperatorKey k) {
        this(k, -1);
    }

    public ConstantExpression(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public String name() {
        if (this.value != null) {
            return "Constant(" + this.value.toString() + ") - " + this.mKey.toString();
        }
        return "Constant(DummyVal) - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitConstant(this);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        Tuple dummyTuple = TupleFactory.getInstance().newTuple(1);
        this.attachInput(dummyTuple);
    }

    private Result genericGetNext(byte dataType) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = this.value;
        return this.res;
    }

    @Override
    public Result getNextDataBag() throws ExecException {
        return this.genericGetNext((byte)120);
    }

    @Override
    public Result getNextDataByteArray() throws ExecException {
        return this.genericGetNext((byte)50);
    }

    @Override
    public Result getNextDouble() throws ExecException {
        return this.genericGetNext((byte)25);
    }

    @Override
    public Result getNextFloat() throws ExecException {
        return this.genericGetNext((byte)20);
    }

    @Override
    public Result getNextInteger() throws ExecException {
        return this.genericGetNext((byte)10);
    }

    @Override
    public Result getNextLong() throws ExecException {
        return this.genericGetNext((byte)15);
    }

    @Override
    public Result getNextDateTime() throws ExecException {
        return this.genericGetNext((byte)30);
    }

    @Override
    public Result getNextString() throws ExecException {
        return this.genericGetNext((byte)55);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        return this.genericGetNext((byte)110);
    }

    @Override
    public Result getNextBoolean() throws ExecException {
        return this.genericGetNext((byte)5);
    }

    @Override
    public Result getNextMap() throws ExecException {
        return this.genericGetNext((byte)100);
    }

    @Override
    public Result getNextBigInteger() throws ExecException {
        return this.genericGetNext((byte)65);
    }

    @Override
    public Result getNextBigDecimal() throws ExecException {
        return this.genericGetNext((byte)70);
    }

    @Override
    public ConstantExpression clone() throws CloneNotSupportedException {
        ConstantExpression clone = new ConstantExpression(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.value = this.value;
        clone.cloneHelper(this);
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return (Tuple)out;
    }
}

