/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.grunt;

import java.io.BufferedReader;
import java.util.ArrayList;
import jline.ConsoleReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.grunt.PigCompletor;
import org.apache.pig.tools.grunt.PigCompletorAliases;
import org.apache.pig.tools.pigstats.PigStatsUtil;

public class Grunt {
    private final Log log = LogFactory.getLog(this.getClass());
    BufferedReader in;
    PigServer pig;
    GruntParser parser;

    public Grunt(BufferedReader in, PigContext pigContext) throws ExecException {
        this.in = in;
        this.pig = new PigServer(pigContext);
        if (in != null) {
            this.parser = new GruntParser(in);
            this.parser.setParams(this.pig);
        }
    }

    public void setConsoleReader(ConsoleReader c) {
        c.addCompletor(new PigCompletorAliases(this.pig));
        c.addCompletor(new PigCompletor());
        this.parser.setConsoleReader(c);
    }

    public void run() {
        boolean verbose = "true".equalsIgnoreCase(this.pig.getPigContext().getProperties().getProperty("verbose"));
        while (true) {
            try {
                PigStatsUtil.getEmptyPigStats();
                this.parser.setInteractive(true);
                this.parser.parseStopOnError();
            }
            catch (Throwable t) {
                LogUtils.writeLog(t, this.pig.getPigContext().getProperties().getProperty("pig.logfile"), this.log, verbose, "Pig Stack Trace");
                this.parser.ReInit(this.in);
                continue;
            }
            break;
        }
    }

    public int[] exec() throws Throwable {
        boolean verbose = "true".equalsIgnoreCase(this.pig.getPigContext().getProperties().getProperty("verbose"));
        try {
            PigStatsUtil.getEmptyPigStats();
            this.parser.setInteractive(false);
            return this.parser.parseStopOnError();
        }
        catch (Throwable t) {
            LogUtils.writeLog(t, this.pig.getPigContext().getProperties().getProperty("pig.logfile"), this.log, verbose, "Pig Stack Trace");
            throw t;
        }
    }

    public void checkScript(String scriptFile) throws Throwable {
        boolean verbose = "true".equalsIgnoreCase(this.pig.getPigContext().getProperties().getProperty("verbose"));
        try {
            this.parser.setInteractive(false);
            this.parser.setValidateEachStatement(true);
            boolean dontPrintOutput = true;
            this.parser.processExplain(null, scriptFile, false, "text", null, new ArrayList<String>(), new ArrayList<String>(), dontPrintOutput);
        }
        catch (Throwable t) {
            LogUtils.writeLog(t, this.pig.getPigContext().getProperties().getProperty("pig.logfile"), this.log, verbose, "Pig Stack Trace");
            throw t;
        }
    }
}

