/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.ExecType;
import org.apache.pig.impl.util.UDFContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingOutputCapturer {
    private static Log log = LogFactory.getLog(ScriptingOutputCapturer.class);
    private static Map<String, String> outputFileNames = new HashMap<String, String>();
    private static String runId = UUID.randomUUID().toString();
    private static boolean captureOutput = false;
    private boolean instancedCapturingOutput = false;
    private ExecType execType;

    public ScriptingOutputCapturer(ExecType execType) {
        this.execType = execType;
    }

    public String getStandardOutputRootWriteLocation() {
        Configuration conf = UDFContext.getUDFContext().getJobConf();
        String jobId = conf.get("mapred.job.id");
        String taskId = conf.get("mapred.task.id");
        log.debug((Object)("JobId: " + jobId));
        log.debug((Object)("TaskId: " + taskId));
        if (this.execType == ExecType.LOCAL) {
            String logDir = System.getProperty("pig.udf.scripting.log.dir");
            if (logDir == null) {
                logDir = ".";
            }
            return logDir + "/" + (taskId == null ? "" : taskId + "_");
        }
        String taskLogDir = this.getTaskLogDir(jobId, taskId);
        return taskLogDir + "/";
    }

    public String getTaskLogDir(String jobId, String taskId) {
        String hadoopLogDir = System.getProperty("hadoop.log.dir");
        String defaultUserLogDir = hadoopLogDir + File.separator + "userlogs";
        String taskLogDir = new File(defaultUserLogDir + File.separator + jobId).exists() ? defaultUserLogDir + File.separator + jobId + File.separator + taskId : (new File(defaultUserLogDir + File.separator + taskId).exists() ? defaultUserLogDir + File.separator + taskId : (new File(defaultUserLogDir).exists() ? defaultUserLogDir : hadoopLogDir + File.separator + "udfOutput"));
        return taskLogDir;
    }

    public static void startCapturingOutput() {
        captureOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUdfOutput() throws IOException {
        HashMap<String, String> udfFuncNameToOutput = new HashMap<String, String>();
        for (Map.Entry<String, String> funcToOutputFileName : outputFileNames.entrySet()) {
            StringBuffer udfOutput = new StringBuffer();
            FileInputStream fis = new FileInputStream(funcToOutputFileName.getValue());
            InputStreamReader fr = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
            BufferedReader br = new BufferedReader(fr);
            try {
                String line = br.readLine();
                while (line != null) {
                    udfOutput.append("\t" + line + "\n");
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
            udfFuncNameToOutput.put(funcToOutputFileName.getKey(), udfOutput.toString());
        }
        return udfFuncNameToOutput;
    }

    public void registerOutputLocation(String functionName, String fileName) {
        outputFileNames.put(functionName, fileName);
    }

    public static String getRunId() {
        return runId;
    }

    public static boolean isClassCapturingOutput() {
        return captureOutput;
    }

    public boolean isInstanceCapturingOutput() {
        return this.instancedCapturingOutput;
    }

    public void setInstanceCapturingOutput(boolean instanceCapturingOutput) {
        this.instancedCapturingOutput = instanceCapturingOutput;
    }
}

