/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import org.apache.pig.ComparisonFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigToStream;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StreamToPig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionType {
    public static final byte UNKNOWNFUNC = 0;
    public static final byte EVALFUNC = 2;
    public static final byte COMPARISONFUNC = 4;
    public static final byte LOADFUNC = 8;
    public static final byte STOREFUNC = 16;
    public static final byte PIGTOSTREAMFUNC = 32;
    public static final byte STREAMTOPIGFUNC = 64;

    FunctionType() {
    }

    public static void tryCasting(Class<?> func, byte funcType) {
        Class typeClass;
        switch (funcType) {
            case 2: {
                typeClass = EvalFunc.class;
                break;
            }
            case 4: {
                typeClass = ComparisonFunc.class;
                break;
            }
            case 8: {
                typeClass = LoadFunc.class;
                break;
            }
            case 16: {
                typeClass = StoreFuncInterface.class;
                break;
            }
            case 32: {
                typeClass = PigToStream.class;
                break;
            }
            case 64: {
                typeClass = StreamToPig.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Received an unknown function type: " + funcType);
            }
        }
        if (!typeClass.isAssignableFrom(func)) {
            throw new ClassCastException(func + " does not implement " + typeClass);
        }
    }
}

