/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.SortColInfo;
import org.apache.pig.SortInfo;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOSort
extends LogicalRelationalOperator {
    private List<Boolean> mAscCols;
    private FuncSpec mSortFunc;
    private boolean mIsStar = false;
    private long limit = -1L;
    private List<LogicalExpressionPlan> mSortColPlans;

    public LOSort(OperatorPlan plan) {
        super("LOSort", plan);
    }

    public LOSort(OperatorPlan plan, List<LogicalExpressionPlan> sortColPlans, List<Boolean> ascCols, FuncSpec sortFunc) {
        this(plan);
        this.mSortColPlans = sortColPlans;
        this.mAscCols = ascCols;
        this.mSortFunc = sortFunc;
    }

    public List<LogicalExpressionPlan> getSortColPlans() {
        return this.mSortColPlans;
    }

    public void setSortColPlans(List<LogicalExpressionPlan> sortPlans) {
        this.mSortColPlans = sortPlans;
    }

    public List<Boolean> getAscendingCols() {
        return this.mAscCols;
    }

    public void setAscendingCols(List<Boolean> ascCols) {
        this.mAscCols = ascCols;
    }

    public FuncSpec getUserFunc() {
        return this.mSortFunc;
    }

    public void setUserFunc(FuncSpec func) {
        this.mSortFunc = func;
    }

    public boolean isStar() {
        return this.mIsStar;
    }

    public void setStar(boolean b) {
        this.mIsStar = b;
    }

    public void setLimit(long l) {
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isLimited() {
        return this.limit != -1L;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        LogicalRelationalOperator input = null;
        input = (LogicalRelationalOperator)this.plan.getPredecessors(this).get(0);
        this.schema = input.getSchema();
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public SortInfo getSortInfo() throws FrontendException {
        LogicalSchema schema = this.getSchema();
        ArrayList<SortColInfo> sortColInfoList = new ArrayList<SortColInfo>();
        for (int i = 0; i < this.mSortColPlans.size(); ++i) {
            LogicalExpressionPlan lp = this.mSortColPlans.get(i);
            Iterator<Operator> opsIterator = lp.getOperators();
            ArrayList<Operator> opsList = new ArrayList<Operator>();
            while (opsIterator.hasNext()) {
                opsList.add(opsIterator.next());
            }
            if (opsList.size() != 1 || !(opsList.get(0) instanceof ProjectExpression)) {
                throw new FrontendException(this, "Unsupported operator in inner plan: " + opsList.get(0), 2237);
            }
            ProjectExpression project = (ProjectExpression)opsList.get(0);
            if (project.isProjectStar()) {
                return new SortInfo(sortColInfoList);
            }
            if (project.isRangeProject()) {
                if (project.getEndCol() < 0) {
                    return new SortInfo(sortColInfoList);
                }
                for (int cnum = project.getStartCol(); cnum < project.getEndCol(); ++cnum) {
                    sortColInfoList.add(new SortColInfo(null, cnum, this.getOrder(this.mAscCols, i)));
                }
                continue;
            }
            int sortColIndex = project.getColNum();
            String sortColName = schema == null ? null : schema.getField((int)sortColIndex).alias;
            sortColInfoList.add(new SortColInfo(sortColName, sortColIndex, this.getOrder(this.mAscCols, i)));
        }
        return new SortInfo(sortColInfoList);
    }

    private SortColInfo.Order getOrder(List<Boolean> mAscCols2, int i) {
        return this.mAscCols.get(i) != false ? SortColInfo.Order.ASCENDING : SortColInfo.Order.DESCENDING;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOSort) {
            LOSort otherSort = (LOSort)other;
            if (!((Object)this.mAscCols).equals(otherSort.getAscendingCols())) {
                return false;
            }
            if (!this.mSortFunc.equals(otherSort.getUserFunc())) {
                return false;
            }
            if (this.mIsStar != otherSort.isStar()) {
                return false;
            }
            if (this.limit != otherSort.getLimit()) {
                return false;
            }
            if (!((Object)this.mSortColPlans).equals(otherSort.getSortColPlans())) {
                return false;
            }
        }
        return this.checkEquality((LogicalRelationalOperator)other);
    }

    public Operator getInput(LogicalPlan plan) {
        return plan.getPredecessors(this).get(0);
    }

    public static LOSort createCopy(LOSort sort) throws FrontendException {
        LOSort newSort = new LOSort(sort.getPlan(), null, sort.getAscendingCols(), sort.getUserFunc());
        ArrayList<LogicalExpressionPlan> newSortColPlans = new ArrayList<LogicalExpressionPlan>(sort.getSortColPlans().size());
        for (LogicalExpressionPlan lep : sort.getSortColPlans()) {
            LogicalExpressionPlan new_lep = lep.deepCopy();
            new ResetProjectionAttachedRelationalOpVisitor(new_lep, newSort).visit();
            newSortColPlans.add(new_lep);
        }
        newSort.setSortColPlans(newSortColPlans);
        return newSort;
    }

    private static class ResetProjectionAttachedRelationalOpVisitor
    extends LogicalExpressionVisitor {
        private LogicalRelationalOperator attachedRelationalOp;

        ResetProjectionAttachedRelationalOpVisitor(LogicalExpressionPlan plan, LogicalRelationalOperator op) throws FrontendException {
            super(plan, new ReverseDependencyOrderWalker(plan));
            this.attachedRelationalOp = op;
        }

        public void visit(ProjectExpression pe) throws FrontendException {
            pe.setAttachedRelationalOp(this.attachedRelationalOp);
        }
    }
}

