/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanVisitor<O extends Operator, P extends OperatorPlan<O>> {
    protected P mPlan;
    protected PlanWalker<O, P> mCurrentWalker;
    private Deque<PlanWalker<O, P>> mWalkers;

    public void visit() throws VisitorException {
        this.mCurrentWalker.walk(this);
    }

    public P getPlan() {
        return this.mPlan;
    }

    protected PlanVisitor(P plan, PlanWalker<O, P> walker) {
        this.mPlan = plan;
        this.mCurrentWalker = walker;
        this.mWalkers = new LinkedList<PlanWalker<O, P>>();
    }

    protected void pushWalker(PlanWalker<O, P> walker) {
        this.mWalkers.push(this.mCurrentWalker);
        this.mCurrentWalker = walker;
    }

    protected void popWalker() throws VisitorException {
        if (this.mWalkers.isEmpty()) {
            throw new VisitorException("No more walkers to pop.");
        }
        this.mCurrentWalker = this.mWalkers.pop();
    }
}

