/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMultiQueryPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanPrinter<O extends Operator, P extends OperatorPlan<O>>
extends PlanVisitor<O, P> {
    String TAB1 = "    ";
    String TABMore = "|   ";
    String LSep = "|\n|---";
    String USep = "|   |\n|   ";
    int levelCntr = -1;
    PrintStream stream = System.out;
    boolean isVerbose = true;

    public PlanPrinter(P plan) {
        super(plan, new DepthFirstWalker(plan));
    }

    public PlanPrinter(P plan, PrintStream stream) {
        super(plan, new DepthFirstWalker(plan));
        this.stream = stream;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public void visit() throws VisitorException {
        try {
            this.stream.write(this.depthFirstPP().getBytes());
        }
        catch (IOException ioe) {
            int errCode = 2079;
            String msg = "Unexpected error while printing physical plan.";
            throw new VisitorException(msg, errCode, 4, (Throwable)ioe);
        }
    }

    public void print(OutputStream printer) throws VisitorException, IOException {
        printer.write(this.depthFirstPP().getBytes());
    }

    protected void breadthFirst() throws VisitorException {
        List leaves = this.mPlan.getLeaves();
        HashSet seen = new HashSet();
        this.breadthFirst(leaves, seen);
    }

    private void breadthFirst(Collection<O> predecessors, Set<O> seen) throws VisitorException {
        ++this.levelCntr;
        this.dispTabs();
        ArrayList<Operator> newPredecessors = new ArrayList<Operator>();
        for (Operator pred : predecessors) {
            if (!seen.add(pred)) continue;
            List<Operator> predLst = this.mPlan.getPredecessors(pred);
            if (predLst != null) {
                newPredecessors.addAll(predLst);
            }
            pred.visit(this);
        }
        if (newPredecessors.size() > 0) {
            this.stream.println();
            this.breadthFirst(newPredecessors, seen);
        }
    }

    protected String depthFirstPP() throws VisitorException {
        StringBuilder sb = new StringBuilder();
        List leaves = this.mPlan.getLeaves();
        Collections.sort(leaves);
        for (Operator leaf : leaves) {
            sb.append(this.depthFirst(leaf));
            sb.append("\n");
        }
        sb.delete(sb.length() - "\n".length(), sb.length());
        sb.delete(sb.length() - "\n".length(), sb.length());
        return sb.toString();
    }

    private String planString(PhysicalPlan pp) {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (pp == null) {
            return "";
        }
        pp.explain(baos, this.isVerbose);
        sb.append(this.USep);
        sb.append(this.shiftStringByTabs(baos.toString(), 2));
        return sb.toString();
    }

    private String planString(List<PhysicalPlan> lep) {
        StringBuilder sb = new StringBuilder();
        if (lep != null) {
            for (PhysicalPlan ep : lep) {
                sb.append(this.planString(ep));
            }
        }
        return sb.toString();
    }

    private String depthFirst(O node) throws VisitorException {
        StringBuilder sb = new StringBuilder(((Operator)node).name() + "\n");
        if (this.isVerbose) {
            POSkewedJoin skewed;
            List<List<PhysicalPlan>> joinPlans;
            if (node instanceof POFilter) {
                sb.append(this.planString(((POFilter)node).getPlan()));
            } else if (node instanceof POLocalRearrange) {
                sb.append(this.planString(((POLocalRearrange)node).getPlans()));
            } else if (node instanceof POPartialAgg) {
                sb.append(this.planString(((POPartialAgg)node).getKeyPlan()));
                sb.append(this.planString(((POPartialAgg)node).getValuePlans()));
            } else if (node instanceof POCollectedGroup) {
                sb.append(this.planString(((POCollectedGroup)node).getPlans()));
            } else if (node instanceof PORank) {
                sb.append(this.planString(((PORank)node).getRankPlans()));
            } else if (node instanceof POCounter) {
                sb.append(this.planString(((POCounter)node).getCounterPlans()));
            } else if (node instanceof POSort) {
                sb.append(this.planString(((POSort)node).getSortPlans()));
            } else if (node instanceof POForEach) {
                sb.append(this.planString(((POForEach)node).getInputPlans()));
            } else if (node instanceof POMultiQueryPackage) {
                List<POPackage> pkgs = ((POMultiQueryPackage)node).getPackages();
                for (POPackage pkg : pkgs) {
                    sb.append(this.LSep + pkg.name() + "\n");
                }
            } else if (node instanceof POFRJoin) {
                POFRJoin frj = (POFRJoin)node;
                joinPlans = frj.getJoinPlans();
                if (joinPlans != null) {
                    for (List<PhysicalPlan> list : joinPlans) {
                        sb.append(this.planString(list));
                    }
                }
            } else if (node instanceof POSkewedJoin && (joinPlans = (skewed = (POSkewedJoin)node).getJoinPlans()) != null) {
                ArrayList<PhysicalPlan> inner_plans = new ArrayList<PhysicalPlan>();
                inner_plans.addAll(((MultiMap)((Object)joinPlans)).values());
                sb.append(this.planString(inner_plans));
            }
        }
        if (node instanceof POSplit) {
            sb.append(this.planString(((POSplit)node).getPlans()));
        } else if (node instanceof PODemux) {
            ArrayList<PhysicalPlan> plans = new ArrayList<PhysicalPlan>();
            HashSet<PhysicalPlan> pl = new HashSet<PhysicalPlan>();
            pl.addAll(((PODemux)node).getPlans());
            plans.addAll(pl);
            sb.append(this.planString(plans));
        }
        List<O> originalPredecessors = this.mPlan.getPredecessors(node);
        if (originalPredecessors == null) {
            return sb.toString();
        }
        ArrayList<O> predecessors = new ArrayList<O>(originalPredecessors);
        Collections.sort(predecessors);
        int i = 0;
        for (Operator pred : predecessors) {
            ++i;
            String DFStr = this.depthFirst(pred);
            if (DFStr == null) continue;
            sb.append(this.LSep);
            if (i < predecessors.size()) {
                sb.append(this.shiftStringByTabs(DFStr, 2));
                continue;
            }
            sb.append(this.shiftStringByTabs(DFStr, 1));
        }
        return sb.toString();
    }

    private String shiftStringByTabs(String DFStr, int TabType) {
        StringBuilder sb = new StringBuilder();
        String[] spl = DFStr.split("\n");
        String tab = TabType == 1 ? this.TAB1 : this.TABMore;
        sb.append(spl[0] + "\n");
        for (int i = 1; i < spl.length; ++i) {
            sb.append(tab);
            sb.append(spl[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void dispTabs() {
        for (int i = 0; i < this.levelCntr; ++i) {
            this.stream.print(this.TAB1);
        }
    }

    public void visitLoad(POLoad op) {
        this.stream.print(op.name() + "   ");
    }

    public void visitStore(POStore op) {
        this.stream.print(op.name() + "   ");
    }

    public void visitFilter(POFilter op) {
        this.stream.print(op.name() + "   ");
    }

    public void visitLocalRearrange(POLocalRearrange op) {
        this.stream.print(op.name() + "   ");
    }

    public void visitGlobalRearrange(POGlobalRearrange op) {
        this.stream.print(op.name() + "   ");
    }

    public void visitPackage(POPackage op) {
        this.stream.print(op.name() + "   ");
    }

    public void visitStartMap(POUnion op) {
        this.stream.print(op.name() + "   ");
    }
}

