/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnOutputBuffer;

class ArrayColumnOutputBuffer
extends ColumnOutputBuffer {
    private int length;

    public ArrayColumnOutputBuffer(ColumnFileWriter writer, ColumnMetaData meta) throws IOException {
        super(writer, meta);
        assert (this.getMeta().isArray() || this.getMeta().getParent() != null);
        assert (!this.getMeta().hasIndexValues());
    }

    @Override
    public void writeLength(int length) throws IOException {
        assert (this.length == 0);
        this.length = length;
        this.getBuffer().writeLength(length);
    }

    @Override
    public void writeValue(Object value) throws IOException {
        assert (this.length > 0);
        this.getBuffer().writeValue(value, this.getMeta().getType());
        --this.length;
    }
}

