/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data.utils;

import org.apache.pig.impl.logicalLayer.schema.Schema;

public class StructuresHelper {
    private StructuresHelper() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Triple<T1, T2, T3> {
        private final T1 t1;
        private final T2 t2;
        private final T3 t3;

        public Triple(T1 t1, T2 t2, T3 t3) {
            this.t1 = t1;
            this.t2 = t2;
            this.t3 = t3;
        }

        public T1 getFirst() {
            return this.t1;
        }

        public T2 getSecond() {
            return this.t2;
        }

        public T3 getThird() {
            return this.t3;
        }

        public static <A, B, C> Triple<A, B, C> make(A t1, B t2, C t3) {
            return new Triple<A, B, C>(t1, t2, t3);
        }

        public int hashCode() {
            return (this.t1 == null ? 0 : this.t1.hashCode()) + (this.t2 == null ? 0 : 31 * this.t2.hashCode()) + (this.t3 == null ? 0 : 527 * this.t3.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Triple)) {
                return false;
            }
            Triple tr = (Triple)o;
            if (this.t1 == null) {
                return tr.getFirst() == null;
            }
            if (!this.t1.equals(tr.getFirst())) {
                return false;
            }
            if (this.t2 == null) {
                return tr.getSecond() == null;
            }
            if (!this.t2.equals(tr.getSecond())) {
                return false;
            }
            if (this.t3 == null) {
                return tr.getThird() == null;
            }
            return this.t3.equals(tr.getThird());
        }

        public String toString() {
            return "[" + this.t1 + "," + this.t2 + "," + this.t3 + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<T1, T2> {
        private final T1 t1;
        private final T2 t2;

        public Pair(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public T1 getFirst() {
            return this.t1;
        }

        public T2 getSecond() {
            return this.t2;
        }

        public static <A, B> Pair<A, B> make(A t1, B t2) {
            return new Pair<A, B>(t1, t2);
        }

        public int hashCode() {
            return (this.t1 == null ? 0 : this.t1.hashCode()) + (this.t2 == null ? 0 : 31 * this.t2.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair pr = (Pair)o;
            if (this.t1 == null) {
                return pr.getFirst() == null;
            }
            if (!this.t1.equals(pr.getFirst())) {
                return false;
            }
            if (this.t2 == null) {
                return pr.getSecond() == null;
            }
            return this.t2.equals(pr.getSecond());
        }

        public String toString() {
            return "[" + this.t1 + "," + this.t2 + "]";
        }
    }

    public static class SchemaKey {
        private Schema s;
        private static int[] primeList = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 1133};

        public SchemaKey(Schema s) {
            this.s = s;
        }

        public int hashCode() {
            return SchemaKey.hashCode(this.s);
        }

        public static int hashCode(Schema s) {
            if (s == null) {
                return 0;
            }
            int idx = 0;
            int hashCode = 0;
            for (Schema.FieldSchema fs : s.getFields()) {
                hashCode += SchemaKey.hashCode(fs) * primeList[idx % primeList.length];
                ++idx;
            }
            return hashCode;
        }

        private static int hashCode(Schema.FieldSchema fs) {
            return fs.type * 17 + (fs.schema == null ? 0 : SchemaKey.hashCode(fs.schema)) * 23;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SchemaKey)) {
                return false;
            }
            Schema other = ((SchemaKey)o).get();
            return this.s == null && other == null || Schema.equals(this.s, other, false, true);
        }

        public Schema get() {
            return this.s;
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

