/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.log4j.PropertyConfigurator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ProgressableReporter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POJoinPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class PigCombiner {
    public static JobContext sJobContext = null;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Combine
    extends Reducer<PigNullableWritable, NullableTuple, PigNullableWritable, Writable> {
        private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        private byte keyType;
        private PhysicalPlan cp;
        private POPackage pack;
        ProgressableReporter pigReporter;
        PhysicalOperator[] roots;
        PhysicalOperator leaf;
        PigContext pigContext = null;
        private volatile boolean initialized = false;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            sJobContext = context;
            Configuration jConf = context.getConfiguration();
            try {
                PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(jConf.get("udf.import.list")));
                this.pigContext = (PigContext)ObjectSerializer.deserialize(jConf.get("pig.pigContext"));
                if (this.pigContext.getLog4jProperties() != null) {
                    PropertyConfigurator.configure((Properties)this.pigContext.getLog4jProperties());
                }
                this.cp = (PhysicalPlan)ObjectSerializer.deserialize(jConf.get("pig.combinePlan"));
                this.pack = (POPackage)ObjectSerializer.deserialize(jConf.get("pig.combine.package"));
                if (this.cp.isEmpty()) {
                    this.log.debug((Object)"Combine Plan empty!");
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.cp.explain(baos);
                    this.log.debug((Object)baos.toString());
                }
                this.keyType = ((byte[])ObjectSerializer.deserialize(jConf.get("pig.map.keytype")))[0];
                this.pigReporter = new ProgressableReporter();
                if (!this.cp.isEmpty()) {
                    this.roots = this.cp.getRoots().toArray(new PhysicalOperator[1]);
                    this.leaf = (PhysicalOperator)this.cp.getLeaves().get(0);
                }
            }
            catch (IOException ioe) {
                String msg = "Problem while configuring combiner's reduce plan.";
                throw new RuntimeException(msg, ioe);
            }
            this.log.info((Object)("Aliases being processed per job phase (AliasName[line,offset]): " + jConf.get("pig.alias.location")));
        }

        protected void reduce(PigNullableWritable key, Iterable<NullableTuple> tupIter, Reducer.Context context) throws IOException, InterruptedException {
            if (!this.initialized) {
                this.initialized = true;
                this.pigReporter.setRep((TaskAttemptContext)context);
                PhysicalOperator.setReporter(this.pigReporter);
                boolean aggregateWarning = "true".equalsIgnoreCase(this.pigContext.getProperties().getProperty("aggregate.warning"));
                PigHadoopLogger pigHadoopLogger = PigHadoopLogger.getInstance();
                pigHadoopLogger.setAggregate(aggregateWarning);
                PigStatusReporter.setContext((TaskInputOutputContext)context);
                pigHadoopLogger.setReporter(PigStatusReporter.getInstance());
                PhysicalOperator.setPigLogger(pigHadoopLogger);
            }
            if (this.pack instanceof POJoinPackage) {
                this.pack.attachInput(key, tupIter.iterator());
                while (!this.processOnePackageOutput(context)) {
                }
            } else {
                this.pack.attachInput(key, tupIter.iterator());
                this.processOnePackageOutput(context);
            }
        }

        public boolean processOnePackageOutput(Reducer.Context oc) throws IOException, InterruptedException {
            Result res;
            block10: {
                res = this.pack.getNextTuple();
                if (res.returnStatus == 0) {
                    Result redRes;
                    Tuple packRes = (Tuple)res.result;
                    if (this.cp.isEmpty()) {
                        oc.write(null, (Object)packRes);
                        return false;
                    }
                    for (int i = 0; i < this.roots.length; ++i) {
                        this.roots[i].attachInput(packRes);
                    }
                    while (true) {
                        redRes = this.leaf.getNextTuple();
                        if (redRes.returnStatus == 0) {
                            Tuple tuple = (Tuple)redRes.result;
                            Byte index = (Byte)tuple.get(0);
                            PigNullableWritable outKey = HDataType.getWritableComparableTypes(tuple.get(1), this.keyType);
                            NullableTuple val = new NullableTuple((Tuple)tuple.get(2));
                            outKey.setIndex(index);
                            val.setIndex(index);
                            oc.write((Object)outKey, (Object)val);
                            continue;
                        }
                        if (redRes.returnStatus == 3) break block10;
                        if (redRes.returnStatus != 1 && redRes.returnStatus == 2) break;
                    }
                    int errCode = 2090;
                    String msg = "Received Error while processing the combine plan.";
                    if (redRes.result != null) {
                        msg = msg + redRes.result;
                    }
                    throw new ExecException(msg, errCode, 4);
                }
            }
            if (res.returnStatus == 1) {
                return false;
            }
            if (res.returnStatus == 2) {
                int errCode = 2091;
                String msg = "Packaging error while processing group.";
                throw new ExecException(msg, errCode, 4);
            }
            return res.returnStatus == 3;
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            super.cleanup(context);
            this.leaf = null;
            this.pack = null;
            this.pigReporter = null;
            this.pigContext = null;
            this.roots = null;
            this.cp = null;
        }

        public byte getKeyType() {
            return this.keyType;
        }

        public void setKeyType(byte keyType) {
            this.keyType = keyType;
        }
    }
}

