/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.js;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.apache.pig.scripting.js.JsScriptEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsFunction
extends EvalFunc<Object> {
    private static final Log LOG = LogFactory.getLog(JsFunction.class);
    private String functionName;
    private JsScriptEngine jsScriptEngine = JsScriptEngine.getInstance();
    private Schema outputSchema;

    private static String stringify(Schema schema) {
        StringBuffer buffer = new StringBuffer();
        JsFunction.stringify(schema, buffer);
        return buffer.toString();
    }

    private static void stringify(Schema schema, StringBuffer buffer) {
        if (schema != null) {
            buffer.append("( ");
            List<Schema.FieldSchema> fields = schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                Schema.FieldSchema array_element = fields.get(i);
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(DataType.findTypeName(array_element.type)).append(": ").append(array_element.alias).append(" ");
                JsFunction.stringify(array_element.schema, buffer);
            }
            buffer.append(" )");
        }
    }

    private void debugConvertPigToJS(int depth, String pigType, Object value, Schema schema) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.indent(depth) + "converting from Pig " + pigType + " " + value + " using " + JsFunction.stringify(schema)));
        }
    }

    private void debugConvertJSToPig(int depth, String pigType, Object value, Schema schema) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.indent(depth) + "converting to Pig " + pigType + " " + this.toString(value) + " using " + JsFunction.stringify(schema)));
        }
    }

    private void debugReturn(int depth, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.indent(depth) + "returning " + this.toString(value)));
        }
    }

    private String indent(int depth) {
        StringBuffer b = new StringBuffer(depth * 2);
        for (int i = 0; i < depth * 2; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private void append(StringBuffer buffer, Object object) {
        if (object instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)object;
            buffer.append("{");
            boolean first = true;
            for (Object id : scriptable.getIds()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                if (id instanceof String) {
                    buffer.append(id).append(": ");
                    this.append(buffer, scriptable.get((String)id, this.jsScriptEngine.getScope()));
                    continue;
                }
                buffer.append("[").append(id).append("]: ");
                this.append(buffer, scriptable.get(((Integer)id).intValue(), this.jsScriptEngine.getScope()));
            }
            buffer.append("}");
        } else {
            buffer.append(object);
        }
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer, object);
        return buffer.toString();
    }

    public JsFunction(String functionName) {
        this.functionName = functionName;
        String outputSchemaDef = this.jsScriptEngine.jsEval(this.getClass().getName() + "(String)", functionName + ".outputSchema").toString();
        try {
            this.outputSchema = Utils.getSchemaFromString(outputSchemaDef);
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(functionName + ".outputSchema is not a valid schema: " + e.getMessage(), e);
        }
    }

    @Override
    public Object exec(Tuple tuple) throws IOException {
        Schema inputSchema = this.getInputSchema();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CALL " + JsFunction.stringify(this.outputSchema) + " " + this.functionName + " " + JsFunction.stringify(inputSchema)));
        }
        if (inputSchema.size() == 1 && inputSchema.getField((int)0).type == 110) {
            inputSchema = inputSchema.getField((int)0).schema;
        }
        Scriptable params = this.pigTupleToJS(tuple, inputSchema, 0);
        Object[] passedParams = new Object[inputSchema.size()];
        for (int j = 0; j < passedParams.length; ++j) {
            passedParams[j] = params.get(inputSchema.getField((int)j).alias, params);
        }
        Object result = this.jsScriptEngine.jsCall(this.functionName, passedParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("call " + this.functionName + "(" + Arrays.toString(passedParams) + ") => " + this.toString(result)));
        }
        if (this.outputSchema.size() == 1 && !(result instanceof NativeObject)) {
            Scriptable wrapper = this.jsScriptEngine.jsNewObject();
            wrapper.put(this.outputSchema.getField((int)0).alias, wrapper, result);
            result = wrapper;
        }
        Tuple evalTuple = this.jsToPigTuple((Scriptable)result, this.outputSchema, 0);
        Tuple eval = this.outputSchema.size() == 1 ? evalTuple.get(0) : evalTuple;
        LOG.debug((Object)eval);
        return eval;
    }

    @Override
    public Schema outputSchema(Schema input) {
        this.setInputSchema(input);
        return this.outputSchema;
    }

    private Scriptable pigTupleToJS(Tuple tuple, Schema schema, int depth) throws FrontendException, ExecException {
        this.debugConvertPigToJS(depth, "Tuple", tuple, schema);
        Scriptable object = null;
        if (tuple != null) {
            object = this.jsScriptEngine.jsNewObject();
            for (int i = 0; i < schema.size(); ++i) {
                Object value;
                Schema.FieldSchema field = schema.getField(i);
                if (field.type == 120) {
                    value = this.pigBagToJS((DataBag)tuple.get(i), field.schema, depth + 1);
                } else if (field.type == 110) {
                    value = this.pigTupleToJS((Tuple)tuple.get(i), field.schema, depth + 1);
                } else if (field.type == 100) {
                    value = this.pigMapToJS((Map)tuple.get(i), field.schema, depth + 1);
                } else {
                    this.debugConvertPigToJS(depth + 1, "value", tuple.get(i), field.schema);
                    value = Context.javaToJS((Object)tuple.get(i), (Scriptable)this.jsScriptEngine.getScope());
                    this.debugReturn(depth + 1, value);
                }
                object.put(field.alias, object, value);
            }
        }
        this.debugReturn(depth, object);
        return object;
    }

    private Scriptable pigMapToJS(Map<String, Object> map, Schema schema, int depth) {
        this.debugConvertPigToJS(depth, "Map", map, schema);
        Scriptable object = this.jsScriptEngine.jsNewObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            object.put(entry.getKey(), object, entry.getValue());
        }
        this.debugReturn(depth, object);
        return object;
    }

    private Scriptable pigBagToJS(DataBag bag, Schema schema, int depth) throws FrontendException, ExecException {
        this.debugConvertPigToJS(depth, "Bag", bag, schema);
        if (schema.size() == 1 && schema.getField((int)0).type == 110) {
            schema = schema.getField((int)0).schema;
        }
        Scriptable array = this.jsScriptEngine.jsNewArray(bag.size());
        array.setParentScope(this.jsScriptEngine.getScope());
        int i = 0;
        for (Tuple t : bag) {
            array.put(i++, array, (Object)this.pigTupleToJS(t, schema, depth + 1));
        }
        this.debugReturn(depth, array);
        return array;
    }

    private Tuple jsToPigTuple(Scriptable object, Schema schema, int depth) throws FrontendException, ExecException {
        this.debugConvertJSToPig(depth, "Tuple", object, schema);
        Tuple t = TupleFactory.getInstance().newTuple(schema.size());
        for (int i = 0; i < schema.size(); ++i) {
            Schema.FieldSchema field = schema.getField(i);
            if (object.has(field.alias, this.jsScriptEngine.getScope())) {
                Object attr = object.get(field.alias, object);
                Object value = field.type == 120 ? this.jsToPigBag((Scriptable)attr, field.schema, depth + 1) : (field.type == 110 ? this.jsToPigTuple((Scriptable)attr, field.schema, depth + 1) : (field.type == 100 ? this.jsToPigMap((Scriptable)attr, field.schema, depth + 1) : (attr instanceof NativeJavaObject ? ((NativeJavaObject)attr).unwrap() : (attr instanceof Undefined ? null : attr))));
                t.set(i, value);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("X( " + field.alias + " NOT FOUND"));
        }
        this.debugReturn(depth, t);
        return t;
    }

    private Object jsToPigMap(Scriptable object, Schema schema, int depth) {
        Object[] ids;
        this.debugConvertJSToPig(depth, "Map", object, schema);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object id : ids = object.getIds()) {
            if (!(id instanceof String)) continue;
            String name = (String)id;
            Object value = object.get(name, object);
            if (value instanceof NativeJavaObject) {
                value = ((NativeJavaObject)value).unwrap();
            } else if (value instanceof Undefined) {
                value = null;
            }
            map.put(name, value);
        }
        this.debugReturn(depth, map);
        return map;
    }

    private DataBag jsToPigBag(Scriptable array, Schema schema, int depth) throws FrontendException, ExecException {
        this.debugConvertJSToPig(depth, "Bag", array, schema);
        if (schema.size() == 1 && schema.getField((int)0).type == 110) {
            schema = schema.getField((int)0).schema;
        }
        ArrayList<Tuple> bag = new ArrayList<Tuple>();
        for (Object id : array.getIds()) {
            Scriptable arrayValue = (Scriptable)array.get(((Integer)id).intValue(), null);
            bag.add(this.jsToPigTuple(arrayValue, schema, depth + 1));
        }
        DataBag result = BagFactory.getInstance().newDefaultBag(bag);
        this.debugReturn(depth, result);
        return result;
    }
}

