/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.io.IOException;
import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.InterStorage;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ScalarExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.parser.LogicalPlanBuilder;

public class ScalarVisitor
extends AllExpressionVisitor {
    private final PigContext pigContext;
    private final String scope;

    public ScalarVisitor(OperatorPlan plan, PigContext pigContext, String scope) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
        this.pigContext = pigContext;
        this.scope = scope;
    }

    protected LogicalExpressionVisitor getVisitor(final LogicalExpressionPlan exprPlan) throws FrontendException {
        return new LogicalExpressionVisitor(exprPlan, new DependencyOrderWalker(exprPlan)){

            public void visit(ScalarExpression expr) throws FrontendException {
                ConstantExpression filenameConst = (ConstantExpression)exprPlan.getSuccessors(expr).get(1);
                Operator refOp = expr.getImplicitReferencedOperator();
                Operator attachedOp = expr.getAttachedLogicalOperator();
                LogicalPlan lp = (LogicalPlan)attachedOp.getPlan();
                List<Operator> succs = lp.getSuccessors(refOp);
                LOStore store = null;
                if (succs != null) {
                    for (Operator succ : succs) {
                        if (!(succ instanceof LOStore)) continue;
                        store = (LOStore)succ;
                        break;
                    }
                }
                if (store == null) {
                    FileSpec fileSpec;
                    FuncSpec funcSpec = new FuncSpec(InterStorage.class.getName());
                    try {
                        fileSpec = new FileSpec(FileLocalizer.getTemporaryPath(ScalarVisitor.this.pigContext).toString(), funcSpec);
                    }
                    catch (IOException e) {
                        throw new PlanValidationException(expr, "Failed to process scalar" + e);
                    }
                    StoreFuncInterface stoFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(funcSpec);
                    String sig = LogicalPlanBuilder.newOperatorKey(ScalarVisitor.this.scope);
                    stoFunc.setStoreFuncUDFContextSignature(sig);
                    store = new LOStore(lp, fileSpec, stoFunc, sig);
                    store.setTmpStore(true);
                    lp.add(store);
                    lp.connect(refOp, store);
                    expr.setImplicitReferencedOperator(store);
                }
                filenameConst.setValue(store.getOutputSpec().getFileName());
                if (lp.getSoftLinkSuccessors(store) == null || !lp.getSoftLinkSuccessors(store).contains(attachedOp)) {
                    lp.createSoftLink(store, attachedOp);
                }
            }
        };
    }
}

