/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobClient;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.SimplePigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class PigStats {
    private static final Log LOG = LogFactory.getLog(PigStats.class);
    private static ThreadLocal<PigStats> tps = new ThreadLocal();
    protected int returnCode = -1;
    private String errorMessage;
    private int errorCode = -1;

    public static PigStats get() {
        if (tps.get() == null) {
            tps.set(new SimplePigStats());
        }
        return tps.get();
    }

    static void set(PigStats stats) {
        tps.set(stats);
    }

    static PigStats start() {
        tps.set(new SimplePigStats());
        return tps.get();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public abstract JobClient getJobClient();

    public abstract boolean isEmbedded();

    public abstract boolean isSuccessful();

    public abstract Map<String, List<PigStats>> getAllStats();

    public abstract List<String> getAllErrorMessages();

    public abstract Properties getPigProperties();

    public abstract JobGraph getJobGraph();

    public abstract List<String> getOutputLocations();

    public abstract List<String> getOutputNames();

    public abstract long getNumberBytes(String var1);

    public abstract long getNumberRecords(String var1);

    public abstract String getOutputAlias(String var1);

    public abstract long getSMMSpillCount();

    public abstract long getProactiveSpillCountObjects();

    public abstract long getProactiveSpillCountRecords();

    public abstract long getBytesWritten();

    public abstract long getRecordWritten();

    public String getHadoopVersion() {
        return ScriptState.get().getHadoopVersion();
    }

    public String getPigVersion() {
        return ScriptState.get().getPigVersion();
    }

    public abstract String getScriptId();

    public abstract String getFeatures();

    public abstract long getDuration();

    public abstract int getNumberJobs();

    public abstract List<OutputStats> getOutputStats();

    public abstract OutputStats result(String var1);

    public abstract List<InputStats> getInputStats();

    void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JobComparator
    implements Comparator<JobStats> {
        private JobComparator() {
        }

        @Override
        public int compare(JobStats o1, JobStats o2) {
            return o1.getJobId().compareTo(o2.getJobId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobGraph
    extends BaseOperatorPlan
    implements Iterable<JobStats> {
        @Override
        public String toString() {
            SimplePigStats.JobGraphPrinter jp = new SimplePigStats.JobGraphPrinter(this);
            try {
                jp.visit();
            }
            catch (FrontendException e) {
                LOG.warn((Object)"unable to print job plan", (Throwable)e);
            }
            return jp.toString();
        }

        public List<JobStats> getJobList() {
            return IteratorUtils.toList(this.iterator());
        }

        @Override
        public Iterator<JobStats> iterator() {
            return new Iterator<JobStats>(){
                private Iterator<Operator> iter;
                {
                    this.iter = JobGraph.this.getOperators();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public JobStats next() {
                    return (JobStats)this.iter.next();
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public boolean isConnected(Operator from, Operator to) {
            List<Operator> succs = null;
            succs = this.getSuccessors(from);
            if (succs != null) {
                for (Operator succ : succs) {
                    if (!succ.getName().equals(to.getName()) && !this.isConnected(succ, to)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<JobStats> getSuccessfulJobs() {
            ArrayList<JobStats> lst = new ArrayList<JobStats>();
            for (JobStats js : this) {
                if (js.getState() != JobStats.JobState.SUCCESS) continue;
                lst.add(js);
            }
            Collections.sort(lst, new JobComparator());
            return lst;
        }

        public List<JobStats> getFailedJobs() {
            ArrayList<JobStats> lst = new ArrayList<JobStats>();
            for (JobStats js : this) {
                if (js.getState() != JobStats.JobState.FAILED) continue;
                lst.add(js);
            }
            return lst;
        }
    }
}

