/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigFileInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.TFileRecordReader;
import org.apache.pig.impl.io.TFileRecordWriter;
import org.apache.pig.impl.util.Utils;

@InterfaceAudience.Private
public class TFileStorage
extends FileInputLoadFunc
implements StoreFuncInterface,
LoadMetadata {
    private static final Log mLog = LogFactory.getLog(TFileStorage.class);
    private TFileRecordReader recReader = null;
    private TFileRecordWriter recWriter = null;

    public TFileStorage() throws IOException {
        mLog.debug((Object)"TFile storage in use");
    }

    public Tuple getNext() throws IOException {
        if (this.recReader.nextKeyValue()) {
            return this.recReader.getCurrentValue();
        }
        return null;
    }

    public void putNext(Tuple t) throws IOException {
        try {
            this.recWriter.write(null, t);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public InputFormat getInputFormat() {
        return new TFileInputFormat();
    }

    public int hashCode() {
        return 42;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.recReader = (TFileRecordReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public OutputFormat getOutputFormat() {
        return new TFileOutputFormat();
    }

    public void prepareToWrite(RecordWriter writer) {
        this.recWriter = (TFileRecordWriter)writer;
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    public void checkSchema(ResourceSchema s) throws IOException {
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        return Utils.getSchema(this, location, true, job);
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression plan) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setStoreFuncUDFContextSignature(String signature) {
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TFileOutputFormat
    extends FileOutputFormat<WritableComparable, Tuple> {
        public RecordWriter<WritableComparable, Tuple> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
            Configuration conf = job.getConfiguration();
            String codec = conf.get("pig.tmpfilecompression.codec", "");
            if (!codec.equals("lzo") && !codec.equals("gz")) {
                throw new IOException("Invalid temporary file compression codec [" + codec + "]. Expected compression codecs are gz and lzo");
            }
            mLog.info((Object)(codec + " compression codec in use"));
            Path file = this.getDefaultWorkFile(job, "");
            return new TFileRecordWriter(file, codec, conf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TFileInputFormat
    extends PigFileInputFormat<Text, Tuple> {
        public RecordReader<Text, Tuple> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new TFileRecordReader();
        }
    }
}

