/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.log4j.PropertyConfigurator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReducePOStoreImpl;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ProgressableReporter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.UDFFinishVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.SpillableMemoryManager;
import org.apache.pig.tools.pigstats.PigStatusReporter;
import org.joda.time.DateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PigGenericMapBase
extends Mapper<Text, Tuple, PigNullableWritable, Writable> {
    private static final Tuple DUMMYTUPLE = null;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected byte keyType;
    protected PhysicalPlan mp = null;
    protected List<POStore> stores;
    protected TupleFactory tf = TupleFactory.getInstance();
    boolean inIllustrator = false;
    Mapper.Context outputCollector;
    ProgressableReporter pigReporter;
    protected boolean errorInMap = false;
    PhysicalOperator[] roots;
    private PhysicalOperator leaf;
    PigContext pigContext = null;
    private volatile boolean initialized = false;

    public void setMapPlan(PhysicalPlan plan) {
        this.mp = plan;
    }

    public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        if (this.errorInMap) {
            return;
        }
        if (((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.invoke.close.in.map", "false").equals("true")) {
            this.mp.endOfAllInput = true;
            this.runPipeline(this.leaf);
        }
        if (!this.inIllustrator) {
            for (POStore store : this.stores) {
                if (!this.initialized) {
                    MapReducePOStoreImpl impl = new MapReducePOStoreImpl((TaskInputOutputContext)context);
                    store.setStoreImpl(impl);
                    store.setUp();
                }
                store.tearDown();
            }
        }
        UDFFinishVisitor finisher = new UDFFinishVisitor(this.mp, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(this.mp));
        try {
            finisher.visit();
        }
        catch (VisitorException e) {
            int errCode = 2121;
            String msg = "Error while calling finish method on UDFs.";
            throw new VisitorException(msg, errCode, 4, (Throwable)e);
        }
        this.mp = null;
        PhysicalOperator.setReporter(null);
        this.initialized = false;
    }

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration job = context.getConfiguration();
        SpillableMemoryManager.configure(ConfigurationUtil.toProperties(job));
        PigMapReduce.sJobContext = context;
        PigMapReduce.sJobConfInternal.set(context.getConfiguration());
        PigMapReduce.sJobConf = context.getConfiguration();
        this.inIllustrator = this.inIllustrator(context);
        PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(job.get("udf.import.list")));
        this.pigContext = (PigContext)ObjectSerializer.deserialize(job.get("pig.pigContext"));
        SchemaTupleBackend.initialize(job, this.pigContext);
        if (this.pigContext.getLog4jProperties() != null) {
            PropertyConfigurator.configure((Properties)this.pigContext.getLog4jProperties());
        }
        if (this.mp == null) {
            this.mp = (PhysicalPlan)ObjectSerializer.deserialize(job.get("pig.mapPlan"));
        }
        this.stores = PlanHelper.getPhysicalOperators(this.mp, POStore.class);
        if (this.mp.isEmpty()) {
            this.log.debug((Object)"Map Plan empty!");
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.mp.explain(baos);
            this.log.debug((Object)baos.toString());
        }
        this.keyType = ((byte[])ObjectSerializer.deserialize(job.get("pig.map.keytype")))[0];
        this.pigReporter = new ProgressableReporter();
        MapRedUtil.setupUDFContext(job);
        if (!this.mp.isEmpty()) {
            PigSplit split = (PigSplit)context.getInputSplit();
            List<OperatorKey> targetOpKeys = split.getTargetOps();
            ArrayList targetOpsAsList = new ArrayList();
            for (OperatorKey targetKey : targetOpKeys) {
                targetOpsAsList.add(this.mp.getOperator(targetKey));
            }
            this.roots = targetOpsAsList.toArray(new PhysicalOperator[1]);
            this.leaf = (PhysicalOperator)this.mp.getLeaves().get(0);
        }
        PigStatusReporter.setContext((TaskInputOutputContext)context);
        this.log.info((Object)("Aliases being processed per job phase (AliasName[line,offset]): " + job.get("pig.alias.location")));
        String dtzStr = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.datetime.default.tz");
        if (dtzStr != null && dtzStr.length() > 0) {
            DateTimeZone.setDefault(DateTimeZone.forOffsetMillis(DateTimeZone.forID(dtzStr).getOffset(null)));
        }
    }

    protected void map(Text key, Tuple inpTuple, Mapper.Context context) throws IOException, InterruptedException {
        if (!this.initialized) {
            this.initialized = true;
            this.outputCollector = context;
            this.pigReporter.setRep((TaskAttemptContext)context);
            PhysicalOperator.setReporter(this.pigReporter);
            if (!this.inIllustrator) {
                for (POStore store : this.stores) {
                    MapReducePOStoreImpl impl = new MapReducePOStoreImpl((TaskInputOutputContext)context);
                    store.setStoreImpl(impl);
                    if (this.pigContext.inIllustrator) continue;
                    store.setUp();
                }
            }
            boolean aggregateWarning = "true".equalsIgnoreCase(this.pigContext.getProperties().getProperty("aggregate.warning"));
            PigHadoopLogger pigHadoopLogger = PigHadoopLogger.getInstance();
            pigHadoopLogger.setAggregate(aggregateWarning);
            pigHadoopLogger.setReporter(PigStatusReporter.getInstance());
            PhysicalOperator.setPigLogger(pigHadoopLogger);
        }
        if (this.mp.isEmpty()) {
            this.collect(context, inpTuple);
            return;
        }
        for (PhysicalOperator root : this.roots) {
            if (this.inIllustrator) {
                if (root == null) continue;
                root.attachInput(inpTuple);
                continue;
            }
            root.attachInput(this.tf.newTupleNoCopy(inpTuple.getAll()));
        }
        this.runPipeline(this.leaf);
    }

    protected void runPipeline(PhysicalOperator leaf) throws IOException, InterruptedException {
        Result res;
        while (true) {
            res = leaf.getNext(DUMMYTUPLE);
            if (res.returnStatus == 0) {
                this.collect(this.outputCollector, (Tuple)res.result);
                continue;
            }
            if (res.returnStatus == 3) {
                return;
            }
            if (res.returnStatus != 1 && res.returnStatus == 2) break;
        }
        this.errorInMap = true;
        String errMsg = res.result != null ? "Received Error while processing the map plan: " + res.result : "Received Error while processing the map plan.";
        int errCode = 2055;
        ExecException ee = new ExecException(errMsg, errCode, 4);
        throw ee;
    }

    public abstract void collect(Mapper.Context var1, Tuple var2) throws InterruptedException, IOException;

    public abstract boolean inIllustrator(Mapper.Context var1);

    public byte getKeyType() {
        return this.keyType;
    }

    public void setKeyType(byte keyType) {
        this.keyType = keyType;
    }

    public abstract Mapper.Context getIllustratorContext(Configuration var1, DataBag var2, List<Pair<PigNullableWritable, Writable>> var3, InputSplit var4) throws IOException, InterruptedException;
}

