/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jline.ConsoleReader;
import jline.ConsoleReaderInputStream;
import jline.History;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.pig.ExecType;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.util.JarManager;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.PropertiesUtil;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.DryRunGruntParser;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.tools.cmdline.CmdLineParser;
import org.apache.pig.tools.grunt.Grunt;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.parameters.ParseException;
import org.apache.pig.tools.pigstats.PigProgressNotificationListener;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.timer.PerformanceTimerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.LimitedPrivate(value={"Oozie"})
@InterfaceStability.Stable
public class Main {
    private static final Log log = LogFactory.getLog(Main.class);
    private static final String LOG4J_CONF = "log4jconf";
    private static final String BRIEF = "brief";
    private static final String DEBUG = "debug";
    private static final String VERBOSE = "verbose";
    private static final String version;
    private static final String majorVersion;
    private static final String minorVersion;
    private static final String patchVersion;
    private static final String svnRevision;
    private static final String buildTime;
    private static final String PROP_FILT_SIMPL_OPT = "pig.exec.filterLogicExpressionSimplifier";
    protected static final String PROGRESS_NOTIFICATION_LISTENER_KEY = "pig.notification.listener";
    protected static final String PROGRESS_NOTIFICATION_LISTENER_ARG_KEY = "pig.notification.listener.arg";

    public static void main(String[] args) {
        System.exit(Main.run(args, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int run(String[] args, PigProgressNotificationListener listener) {
        int rc = 1;
        boolean verbose = false;
        boolean gruntCalled = false;
        String logFileName = null;
        try {
            BufferedReader in;
            char opt;
            Configuration conf = new Configuration(false);
            GenericOptionsParser parser = new GenericOptionsParser(conf, args);
            conf = parser.getConfiguration();
            Properties properties = new Properties();
            PropertiesUtil.loadDefaultProperties(properties);
            properties.putAll((Map<?, ?>)ConfigurationUtil.toProperties(conf));
            if (listener == null) {
                listener = Main.makeListener(properties);
            }
            String[] pigArgs = parser.getRemainingArgs();
            boolean userSpecifiedLog = false;
            boolean checkScriptOnly = false;
            BufferedReader pin = null;
            boolean debug = false;
            boolean dryrun = false;
            boolean embedded = false;
            ArrayList<String> params = new ArrayList<String>();
            List<String> paramFiles = new ArrayList<String>();
            HashSet<String> optimizerRules = new HashSet<String>();
            CmdLineParser opts = new CmdLineParser(pigArgs);
            opts.registerOpt('4', LOG4J_CONF, CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('b', BRIEF, CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('c', "check", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('d', DEBUG, CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('e', "execute", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('f', "file", CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('g', "embedded", CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('h', "help", CmdLineParser.ValueExpected.OPTIONAL);
            opts.registerOpt('i', "version", CmdLineParser.ValueExpected.OPTIONAL);
            opts.registerOpt('l', "logfile", CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('m', "param_file", CmdLineParser.ValueExpected.OPTIONAL);
            opts.registerOpt('p', "param", CmdLineParser.ValueExpected.OPTIONAL);
            opts.registerOpt('r', "dryrun", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('t', "optimizer_off", CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('v', VERBOSE, CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('w', "warning", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('x', "exectype", CmdLineParser.ValueExpected.REQUIRED);
            opts.registerOpt('F', "stop_on_failure", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('M', "no_multiquery", CmdLineParser.ValueExpected.NOT_ACCEPTED);
            opts.registerOpt('P', "propertyFile", CmdLineParser.ValueExpected.REQUIRED);
            ExecMode mode = ExecMode.UNKNOWN;
            String file = null;
            String engine = null;
            ExecType execType = ExecType.MAPREDUCE;
            String execTypeString = properties.getProperty("exectype");
            if (execTypeString != null && execTypeString.length() > 0) {
                execType = ExecType.fromString(execTypeString);
            }
            UDFContext.getUDFContext().setClientSystemProps(properties);
            block60: while ((opt = opts.getNextOpt()) != '-') {
                switch (opt) {
                    case '4': {
                        String log4jconf = opts.getValStr();
                        if (log4jconf == null) continue block60;
                        properties.setProperty(LOG4J_CONF, log4jconf);
                        break;
                    }
                    case 'b': {
                        properties.setProperty(BRIEF, "true");
                        break;
                    }
                    case 'c': {
                        checkScriptOnly = true;
                        break;
                    }
                    case 'd': {
                        String logLevel = opts.getValStr();
                        if (logLevel != null) {
                            properties.setProperty(DEBUG, logLevel);
                        }
                        debug = true;
                        break;
                    }
                    case 'e': {
                        mode = ExecMode.STRING;
                        break;
                    }
                    case 'f': {
                        mode = ExecMode.FILE;
                        file = opts.getValStr();
                        break;
                    }
                    case 'g': {
                        embedded = true;
                        engine = opts.getValStr();
                        break;
                    }
                    case 'F': {
                        properties.setProperty("stop.on.failure", "true");
                        break;
                    }
                    case 'h': {
                        String topic = opts.getValStr();
                        if (topic != null) {
                            if (topic.equalsIgnoreCase("properties")) {
                                Main.printProperties();
                            } else {
                                System.out.println("Invalide help topic - " + topic);
                                Main.usage();
                            }
                        } else {
                            Main.usage();
                        }
                        int n = 0;
                        return n;
                    }
                    case 'i': {
                        System.out.println(Main.getVersionString());
                        int n = 0;
                        return n;
                    }
                    case 'l': {
                        String logFileParameter = opts.getValStr();
                        logFileName = logFileParameter != null && logFileParameter.length() > 0 ? Main.validateLogFile(logFileParameter, null) : Main.validateLogFile(logFileName, null);
                        userSpecifiedLog = true;
                        properties.setProperty("pig.logfile", logFileName == null ? "" : logFileName);
                        break;
                    }
                    case 'm': {
                        paramFiles.add(opts.getValStr());
                        break;
                    }
                    case 'M': {
                        properties.setProperty("opt.multiquery", "false");
                        break;
                    }
                    case 'p': {
                        params.add(opts.getValStr());
                        break;
                    }
                    case 'r': {
                        dryrun = true;
                        break;
                    }
                    case 't': {
                        optimizerRules.add(opts.getValStr());
                        break;
                    }
                    case 'v': {
                        properties.setProperty(VERBOSE, "true");
                        verbose = true;
                        break;
                    }
                    case 'w': {
                        properties.setProperty("aggregate.warning", "false");
                        break;
                    }
                    case 'x': {
                        try {
                            execType = ExecType.fromString(opts.getValStr());
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("ERROR: Unrecognized exectype.", e);
                        }
                    }
                    case 'P': {
                        InputStream inputStream = null;
                        FileLocalizer.FetchFileRet localFileRet = FileLocalizer.fetchFile(properties, opts.getValStr());
                        inputStream = new BufferedInputStream(new FileInputStream(localFileRet.file));
                        properties.load(inputStream);
                        if (inputStream == null) continue block60;
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {}
                        break;
                        catch (IOException e) {
                            try {
                                throw new RuntimeException("Unable to parse properties file '" + opts.getValStr() + "'");
                            }
                            catch (Throwable throwable) {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e2) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    default: {
                        Character cc = Character.valueOf(opt);
                        throw new AssertionError((Object)("Unhandled option " + cc.toString()));
                    }
                }
            }
            PigContext pigContext = new PigContext(execType, properties);
            String commandLine = LoadFunc.join((AbstractList)Arrays.asList(args), " ");
            ScriptState scriptState = ScriptState.start(commandLine, pigContext);
            if (listener != null) {
                scriptState.registerListener(listener);
            }
            pigContext.getProperties().setProperty("pig.cmd.args", commandLine);
            if (logFileName == null && !userSpecifiedLog) {
                logFileName = Main.validateLogFile(properties.getProperty("pig.logfile"), null);
            }
            pigContext.getProperties().setProperty("pig.logfile", logFileName == null ? "" : logFileName);
            Main.configureLog4J(properties, pigContext);
            log.info((Object)Main.getVersionString().replace("\n", ""));
            if (logFileName != null) {
                log.info((Object)("Logging error messages to: " + logFileName));
            }
            if (!Boolean.valueOf(properties.getProperty(PROP_FILT_SIMPL_OPT, "false")).booleanValue()) {
                optimizerRules.add("FilterLogicExpressionSimplifier");
            }
            if (optimizerRules.size() > 0) {
                pigContext.getProperties().setProperty("pig.optimizer.rules", ObjectSerializer.serialize(optimizerRules));
            }
            PigContext.setClassLoader(pigContext.createCl(null));
            Grunt grunt = null;
            String substFile = null;
            paramFiles = Main.fetchRemoteParamFiles(paramFiles, properties);
            pigContext.setParams(params);
            pigContext.setParamFiles(paramFiles);
            switch (mode) {
                case FILE: {
                    FileLocalizer.FetchFileRet localFileRet = FileLocalizer.fetchFile(properties, file);
                    if (localFileRet.didFetch) {
                        properties.setProperty("pig.jars.relative.to.dfs", "true");
                    }
                    scriptState.setFileName(file);
                    if (embedded) {
                        int e2 = Main.runEmbeddedScript(pigContext, localFileRet.file.getPath(), engine);
                        return e2;
                    }
                    ScriptEngine.SupportedScriptLang type2222 = Main.determineScriptType(localFileRet.file.getPath());
                    if (type2222 != null) {
                        int n = Main.runEmbeddedScript(pigContext, localFileRet.file.getPath(), type2222.name().toLowerCase());
                        return n;
                    }
                    in = new BufferedReader(new InputStreamReader(Utils.getCompositeStream(new FileInputStream(localFileRet.file), properties)));
                    substFile = file + ".substituted";
                    pin = Main.runParamPreprocessor(pigContext, in, substFile, debug || dryrun || checkScriptOnly);
                    if (dryrun) {
                        if (Main.dryrun(substFile, pigContext)) {
                            log.info((Object)("Dry run completed. Substituted pig script is at " + substFile + ". Expanded pig script is at " + file + ".expanded"));
                        } else {
                            log.info((Object)("Dry run completed. Substituted pig script is at " + substFile));
                        }
                        int type2222 = 0;
                        return type2222;
                    }
                    logFileName = Main.validateLogFile(logFileName, file);
                    pigContext.getProperties().setProperty("pig.logfile", logFileName);
                    pigContext.getProperties().setProperty("jobName", "PigLatin:" + new File(file).getName());
                    if (!debug) {
                        new File(substFile).deleteOnExit();
                    }
                    scriptState.setScript(new File(file));
                    grunt = new Grunt(pin, pigContext);
                    gruntCalled = true;
                    if (checkScriptOnly) {
                        grunt.checkScript(substFile);
                        System.err.println(file + " syntax OK");
                        rc = 0;
                    } else {
                        int[] results = grunt.exec();
                        rc = Main.getReturnCodeForStats(results);
                    }
                    int results = rc;
                    return results;
                }
                case STRING: {
                    if (checkScriptOnly) {
                        System.err.println("ERROR:-c (-check) option is only valid when executing pig with a pig script file)");
                        int localFileRet = 4;
                        return localFileRet;
                    }
                    StringBuffer sb = new StringBuffer();
                    String[] remainders2 = opts.getRemainingArgs();
                    for (int i = 0; i < remainders2.length; ++i) {
                        if (i != 0) {
                            sb.append(' ');
                        }
                        sb.append(remainders2[i]);
                    }
                    sb.append('\n');
                    scriptState.setScript(sb.toString());
                    in = new BufferedReader(new StringReader(sb.toString()));
                    grunt = new Grunt(in, pigContext);
                    gruntCalled = true;
                    int[] results = grunt.exec();
                    int n = Main.getReturnCodeForStats(results);
                    return n;
                }
            }
            String[] remainders = opts.getRemainingArgs();
            if (remainders == null) {
                if (checkScriptOnly) {
                    System.err.println("ERROR:-c (-check) option is only valid when executing pig with a pig script file)");
                    int remainders2 = 4;
                    return remainders2;
                }
                mode = ExecMode.SHELL;
                ConsoleReader reader = new ConsoleReader(Utils.getCompositeStream(System.in, properties), new OutputStreamWriter(System.out));
                reader.setDefaultPrompt("grunt> ");
                String HISTORYFILE = ".pig_history";
                String historyFile = System.getProperty("user.home") + File.separator + ".pig_history";
                reader.setHistory(new History(new File(historyFile)));
                ConsoleReaderInputStream inputStream = new ConsoleReaderInputStream(reader);
                grunt = new Grunt(new BufferedReader(new InputStreamReader(inputStream)), pigContext);
                grunt.setConsoleReader(reader);
                gruntCalled = true;
                grunt.run();
                int n = 0;
                return n;
            }
            pigContext.getProperties().setProperty("pig.cmd.args.remainders", ObjectSerializer.serialize((Serializable)remainders));
            mode = ExecMode.FILE;
            FileLocalizer.FetchFileRet localFileRet = FileLocalizer.fetchFile(properties, remainders[0]);
            if (localFileRet.didFetch) {
                properties.setProperty("pig.jars.relative.to.dfs", "true");
            }
            scriptState.setFileName(remainders[0]);
            if (embedded) {
                int HISTORYFILE = Main.runEmbeddedScript(pigContext, localFileRet.file.getPath(), engine);
                return HISTORYFILE;
            }
            ScriptEngine.SupportedScriptLang type = Main.determineScriptType(localFileRet.file.getPath());
            if (type != null) {
                int historyFile = Main.runEmbeddedScript(pigContext, localFileRet.file.getPath(), type.name().toLowerCase());
                return historyFile;
            }
            InputStream seqInputStream = Utils.getCompositeStream(new FileInputStream(localFileRet.file), properties);
            in = new BufferedReader(new InputStreamReader(seqInputStream));
            substFile = remainders[0] + ".substituted";
            pin = Main.runParamPreprocessor(pigContext, in, substFile, debug || dryrun || checkScriptOnly);
            if (dryrun) {
                if (Main.dryrun(substFile, pigContext)) {
                    log.info((Object)("Dry run completed. Substituted pig script is at " + substFile + ". Expanded pig script is at " + remainders[0] + ".expanded"));
                } else {
                    log.info((Object)("Dry run completed. Substituted pig script is at " + substFile));
                }
                int historyFile = 0;
                return historyFile;
            }
            logFileName = Main.validateLogFile(logFileName, remainders[0]);
            pigContext.getProperties().setProperty("pig.logfile", logFileName);
            if (!debug) {
                new File(substFile).deleteOnExit();
            }
            pigContext.getProperties().setProperty("jobName", "PigLatin:" + new File(remainders[0]).getName());
            scriptState.setScript(localFileRet.file);
            grunt = new Grunt(pin, pigContext);
            gruntCalled = true;
            if (checkScriptOnly) {
                grunt.checkScript(substFile);
                System.err.println(remainders[0] + " syntax OK");
                rc = 0;
            } else {
                int[] results = grunt.exec();
                rc = Main.getReturnCodeForStats(results);
            }
            int n = rc;
            return n;
        }
        catch (java.text.ParseException e) {
            Main.usage();
            rc = 7;
            PigStatsUtil.setErrorMessage(e.getMessage());
        }
        catch (ParseException e) {
            rc = 7;
            PigStatsUtil.setErrorMessage(e.getMessage());
        }
        catch (IOException e) {
            if (e instanceof PigException) {
                PigException pe = (PigException)e;
                rc = pe.retriable() ? 1 : 6;
                PigStatsUtil.setErrorMessage(pe.getMessage());
                PigStatsUtil.setErrorCode(pe.getErrorCode());
            } else {
                rc = 5;
                PigStatsUtil.setErrorMessage(e.getMessage());
            }
            if (!gruntCalled) {
                LogUtils.writeLog(e, logFileName, log, verbose, "Error before Pig is launched");
            }
        }
        catch (Throwable e) {
            rc = 8;
            PigStatsUtil.setErrorMessage(e.getMessage());
            if (!gruntCalled) {
                LogUtils.writeLog(e, logFileName, log, verbose, "Error before Pig is launched");
            }
        }
        finally {
            FileLocalizer.deleteTempFiles();
            PerformanceTimerFactory.getPerfTimerFactory().dumpTimers();
        }
        return rc;
    }

    protected static PigProgressNotificationListener makeListener(Properties properties) {
        try {
            return PigContext.instantiateObjectFromParams(ConfigurationUtil.toConfiguration(properties), PROGRESS_NOTIFICATION_LISTENER_KEY, PROGRESS_NOTIFICATION_LISTENER_ARG_KEY, PigProgressNotificationListener.class);
        }
        catch (ExecException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getReturnCodeForStats(int[] stats) {
        return stats[1] == 0 ? 0 : (stats[0] == 0 ? 2 : 3);
    }

    public static boolean dryrun(String scriptFile, PigContext pigContext) throws RecognitionException, IOException {
        BufferedReader rd = new BufferedReader(new FileReader(scriptFile));
        DryRunGruntParser dryrun = new DryRunGruntParser(rd, scriptFile, pigContext);
        boolean hasMacro = dryrun.parseStopOnError();
        if (hasMacro) {
            String expandedFile = scriptFile.replace(".substituted", ".expanded");
            BufferedWriter fw = new BufferedWriter(new FileWriter(expandedFile));
            fw.append(dryrun.getResult());
            fw.close();
        }
        return hasMacro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureLog4J(Properties properties, PigContext pigContext) {
        String log4jconf = properties.getProperty(LOG4J_CONF);
        String trueString = "true";
        boolean brief = trueString.equalsIgnoreCase(properties.getProperty(BRIEF));
        Level logLevel = Level.INFO;
        String logLevelString = properties.getProperty(DEBUG);
        if (logLevelString != null) {
            logLevel = Level.toLevel((String)logLevelString, (Level)Level.INFO);
        }
        Properties props = new Properties();
        FileReader propertyReader = null;
        if (log4jconf != null) {
            try {
                propertyReader = new FileReader(log4jconf);
                props.load(propertyReader);
            }
            catch (IOException e) {
                System.err.println("Warn: Cannot open log4j properties file, use default");
            }
            finally {
                if (propertyReader != null) {
                    try {
                        propertyReader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (props.size() == 0) {
            props.setProperty("log4j.logger.org.apache.pig", logLevel.toString());
            logLevelString = System.getProperty("pig.logfile.level");
            if (logLevelString == null) {
                props.setProperty("log4j.rootLogger", "INFO, PIGCONSOLE");
            } else {
                logLevel = Level.toLevel((String)logLevelString, (Level)Level.INFO);
                props.setProperty("log4j.logger.org.apache.pig", logLevel.toString());
                props.setProperty("log4j.rootLogger", "INFO, PIGCONSOLE, F");
                props.setProperty("log4j.appender.F", "org.apache.log4j.RollingFileAppender");
                props.setProperty("log4j.appender.F.File", properties.getProperty("pig.logfile"));
                props.setProperty("log4j.appender.F.layout", "org.apache.log4j.PatternLayout");
                props.setProperty("log4j.appender.F.layout.ConversionPattern", brief ? "%m%n" : "%d [%t] %-5p %c - %m%n");
            }
            props.setProperty("log4j.appender.PIGCONSOLE", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.PIGCONSOLE.target", "System.err");
            props.setProperty("log4j.appender.PIGCONSOLE.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.PIGCONSOLE.layout.ConversionPattern", brief ? "%m%n" : "%d [%t] %-5p %c - %m%n");
        }
        PropertyConfigurator.configure((Properties)props);
        logLevel = Logger.getLogger((String)"org.apache.pig").getLevel();
        if (logLevel == null) {
            logLevel = Logger.getLogger((String)"org.apache.pig").getEffectiveLevel();
        }
        Properties backendProps = pigContext.getLog4jProperties();
        backendProps.setProperty("log4j.logger.org.apache.pig", logLevel.toString());
        pigContext.setLog4jProperties(backendProps);
        pigContext.setDefaultLogLevel(logLevel);
    }

    private static List<String> fetchRemoteParamFiles(List<String> paramFiles, Properties properties) throws IOException {
        ArrayList<String> paramFiles2 = new ArrayList<String>();
        for (String param : paramFiles) {
            FileLocalizer.FetchFileRet localFileRet = FileLocalizer.fetchFile(properties, param);
            paramFiles2.add(localFileRet.file.getAbsolutePath());
        }
        return paramFiles2;
    }

    private static BufferedReader runParamPreprocessor(PigContext context, BufferedReader origPigScript, String scriptFile, boolean createFile) throws ParseException, IOException {
        ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
        String[] type1 = new String[1];
        String[] type2 = new String[1];
        if (createFile) {
            BufferedWriter fw = new BufferedWriter(new FileWriter(scriptFile));
            psp.genSubstitutedFile(origPigScript, fw, context.getParams().size() > 0 ? context.getParams().toArray(type1) : null, context.getParamFiles().size() > 0 ? context.getParamFiles().toArray(type2) : null);
            return new BufferedReader(new FileReader(scriptFile));
        }
        StringWriter writer = new StringWriter();
        psp.genSubstitutedFile(origPigScript, writer, context.getParams().size() > 0 ? context.getParams().toArray(type1) : null, context.getParamFiles().size() > 0 ? context.getParamFiles().toArray(type2) : null);
        return new BufferedReader(new StringReader(writer.toString()));
    }

    public static String getMajorVersion() {
        return majorVersion;
    }

    public static String getMinorVersion() {
        return minorVersion;
    }

    public static String getPatchVersion() {
        return patchVersion;
    }

    public static String getSvnRevision() {
        return svnRevision;
    }

    public static String getBuildTime() {
        return buildTime;
    }

    public static String getVersionString() {
        return "Apache Pig version " + version + " (r" + svnRevision + ") \ncompiled " + buildTime;
    }

    public static void usage() {
        System.out.println("\n" + Main.getVersionString() + "\n");
        System.out.println("USAGE: Pig [options] [-] : Run interactively in grunt shell.");
        System.out.println("       Pig [options] -e[xecute] cmd [cmd ...] : Run cmd(s).");
        System.out.println("       Pig [options] [-f[ile]] file : Run cmds found in file.");
        System.out.println("  options include:");
        System.out.println("    -4, -log4jconf - Log4j configuration file, overrides log conf");
        System.out.println("    -b, -brief - Brief logging (no timestamps)");
        System.out.println("    -c, -check - Syntax check");
        System.out.println("    -d, -debug - Debug level, INFO is default");
        System.out.println("    -e, -execute - Commands to execute (within quotes)");
        System.out.println("    -f, -file - Path to the script to execute");
        System.out.println("    -g, -embedded - ScriptEngine classname or keyword for the ScriptEngine");
        System.out.println("    -h, -help - Display this message. You can specify topic to get help for that topic.");
        System.out.println("        properties is the only topic currently supported: -h properties.");
        System.out.println("    -i, -version - Display version information");
        System.out.println("    -l, -logfile - Path to client side log file; default is current working directory.");
        System.out.println("    -m, -param_file - Path to the parameter file");
        System.out.println("    -p, -param - Key value pair of the form param=val");
        System.out.println("    -r, -dryrun - Produces script with substituted parameters. Script is not executed.");
        System.out.println("    -t, -optimizer_off - Turn optimizations off. The following values are supported:");
        System.out.println("            SplitFilter - Split filter conditions");
        System.out.println("            PushUpFilter - Filter as early as possible");
        System.out.println("            MergeFilter - Merge filter conditions");
        System.out.println("            PushDownForeachFlatten - Join or explode as late as possible");
        System.out.println("            LimitOptimizer - Limit as early as possible");
        System.out.println("            ColumnMapKeyPrune - Remove unused data");
        System.out.println("            AddForEach - Add ForEach to remove unneeded columns");
        System.out.println("            MergeForEach - Merge adjacent ForEach");
        System.out.println("            GroupByConstParallelSetter - Force parallel 1 for \"group all\" statement");
        System.out.println("            All - Disable all optimizations");
        System.out.println("        All optimizations listed here are enabled by default. Optimization values are case insensitive.");
        System.out.println("    -v, -verbose - Print all error messages to screen");
        System.out.println("    -w, -warning - Turn warning logging on; also turns warning aggregation off");
        System.out.println("    -x, -exectype - Set execution mode: local|mapreduce, default is mapreduce.");
        System.out.println("    -F, -stop_on_failure - Aborts execution on the first failed job; default is off");
        System.out.println("    -M, -no_multiquery - Turn multiquery optimization off; default is on");
        System.out.println("    -P, -propertyFile - Path to property file");
    }

    public static void printProperties() {
        System.out.println("The following properties are supported:");
        System.out.println("    Logging:");
        System.out.println("        verbose=true|false; default is false. This property is the same as -v switch");
        System.out.println("        brief=true|false; default is false. This property is the same as -b switch");
        System.out.println("        debug=OFF|ERROR|WARN|INFO|DEBUG; default is INFO. This property is the same as -d switch");
        System.out.println("        aggregate.warning=true|false; default is true. If true, prints count of warnings");
        System.out.println("            of each type rather than logging each warning.");
        System.out.println("    Performance tuning:");
        System.out.println("        pig.cachedbag.memusage=<mem fraction>; default is 0.2 (20% of all memory).");
        System.out.println("            Note that this memory is shared across all large bags used by the application.");
        System.out.println("        pig.skewedjoin.reduce.memusagea=<mem fraction>; default is 0.3 (30% of all memory).");
        System.out.println("            Specifies the fraction of heap available for the reducer to perform the join.");
        System.out.println("        pig.exec.nocombiner=true|false; default is false. ");
        System.out.println("            Only disable combiner as a temporary workaround for problems.");
        System.out.println("        opt.multiquery=true|false; multiquery is on by default.");
        System.out.println("            Only disable multiquery as a temporary workaround for problems.");
        System.out.println("        pig.tmpfilecompression=true|false; compression is off by default.");
        System.out.println("            Determines whether output of intermediate jobs is compressed.");
        System.out.println("        pig.tmpfilecompression.codec=lzo|gzip; default is gzip.");
        System.out.println("            Used in conjunction with pig.tmpfilecompression. Defines compression type.");
        System.out.println("        pig.noSplitCombination=true|false. Split combination is on by default.");
        System.out.println("            Determines if multiple small files are combined into a single map.");
        System.out.println("        pig.exec.mapPartAgg=true|false. Default is false.");
        System.out.println("            Determines if partial aggregation is done within map phase, ");
        System.out.println("            before records are sent to combiner.");
        System.out.println("        pig.exec.mapPartAgg.minReduction=<min aggregation factor>. Default is 10.");
        System.out.println("            If the in-map partial aggregation does not reduce the output num records");
        System.out.println("            by this factor, it gets disabled.");
        System.out.println("        pig.exec.filterLogicExpressionSimplifier=true|false; Default is false.");
        System.out.println("            Enable optimizer rules to simplify filter expressions.");
        System.out.println("    Miscellaneous:");
        System.out.println("        exectype=mapreduce|local; default is mapreduce. This property is the same as -x switch");
        System.out.println("        pig.additional.jars=<colon seperated list of jars>. Used in place of register command.");
        System.out.println("        udf.import.list=<comma seperated list of imports>. Used to avoid package names in UDF.");
        System.out.println("        stop.on.failure=true|false; default is false. Set to true to terminate on the first error.");
        System.out.println("Additionally, any Hadoop property can be specified.");
    }

    private static String validateLogFile(String logFileName, String scriptName) {
        File logFile;
        File scriptFile;
        String strippedDownScriptName = null;
        if (scriptName != null && !(scriptFile = new File(scriptName)).isDirectory()) {
            try {
                String scriptFileAbsPath = scriptFile.getCanonicalPath();
                strippedDownScriptName = Main.getFileFromCanonicalPath(scriptFileAbsPath);
            }
            catch (IOException ioe) {
                log.warn((Object)("Could not compute canonical path to the script file " + ioe.getMessage()));
                strippedDownScriptName = null;
            }
        }
        String defaultLogFileName = (strippedDownScriptName == null ? "pig_" : strippedDownScriptName) + new Date().getTime() + ".log";
        if (logFileName != null) {
            logFile = new File(logFileName);
            if (logFile.isDirectory()) {
                if (logFile.canWrite()) {
                    try {
                        logFileName = logFile.getCanonicalPath() + File.separator + defaultLogFileName;
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("Could not compute canonical path to the log file " + ioe.getMessage()));
                        return null;
                    }
                    return logFileName;
                }
                log.warn((Object)("Need write permission in the directory: " + logFileName + " to create log file."));
                return null;
            }
            if (logFile.exists()) {
                if (logFile.canWrite()) {
                    try {
                        logFileName = new File(logFileName).getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("Could not compute canonical path to the log file " + ioe.getMessage()));
                        return null;
                    }
                    return logFileName;
                }
                log.warn((Object)("Cannot write to file: " + logFileName + ". Need write permission."));
                return logFileName;
            }
            if ((logFile = logFile.getParentFile()) != null) {
                if (logFile.canWrite()) {
                    try {
                        logFileName = new File(logFileName).getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("Could not compute canonical path to the log file " + ioe.getMessage()));
                        return null;
                    }
                    return logFileName;
                }
                log.warn((Object)("Need write permission in the directory: " + logFile + " to create log file."));
                return logFileName;
            }
        }
        String currDir = System.getProperty("user.dir");
        logFile = new File(currDir);
        logFileName = currDir + File.separator + (logFileName == null ? defaultLogFileName : logFileName);
        if (logFile.canWrite()) {
            return logFileName;
        }
        log.warn((Object)("Cannot write to log file: " + logFileName));
        return null;
    }

    private static String getFileFromCanonicalPath(String canonicalPath) {
        return canonicalPath.substring(canonicalPath.lastIndexOf(File.separator));
    }

    private static ScriptEngine.SupportedScriptLang determineScriptType(String file) throws IOException {
        return ScriptEngine.getSupportedScriptLang(file);
    }

    private static int runEmbeddedScript(PigContext pigContext, String file, String engine) throws IOException {
        log.info((Object)("Run embedded script: " + engine));
        pigContext.connect();
        ScriptEngine scriptEngine = ScriptEngine.getInstance(engine);
        Map<String, List<PigStats>> statsMap = scriptEngine.run(pigContext, file);
        PigStatsUtil.setStatsMap(statsMap);
        int failCount = 0;
        int totalCount = 0;
        for (List<PigStats> lst : statsMap.values()) {
            if (lst == null || lst.isEmpty()) continue;
            for (PigStats stats : lst) {
                if (!stats.isSuccessful()) {
                    ++failCount;
                }
                ++totalCount;
            }
        }
        return totalCount > 0 && failCount == totalCount ? 2 : (failCount > 0 ? 3 : 0);
    }

    static {
        Attributes attr = null;
        try {
            String findContainingJar = JarManager.findContainingJar(Main.class);
            if (findContainingJar != null) {
                JarFile jar = new JarFile(findContainingJar);
                Manifest manifest = jar.getManifest();
                Map<String, Attributes> attrs = manifest.getEntries();
                attr = attrs.get("org/apache/pig");
            } else {
                log.info((Object)"Unable to read pigs manifest file as we are not running from a jar, version information unavailable");
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to read pigs manifest file, version information unavailable", (Throwable)e);
        }
        if (attr != null) {
            version = attr.getValue("Implementation-Version");
            svnRevision = attr.getValue("Svn-Revision");
            buildTime = attr.getValue("Build-TimeStamp");
            String[] split = version.split("\\.");
            majorVersion = split[0];
            minorVersion = split[1];
            patchVersion = split[2];
        } else {
            version = null;
            majorVersion = null;
            minorVersion = null;
            patchVersion = null;
            svnRevision = null;
            buildTime = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExecMode {
        STRING,
        FILE,
        SHELL,
        UNKNOWN;

    }
}

