/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.cli.CLIParser;
import org.apache.oozie.service.Services;
import org.apache.openjpa.jdbc.meta.MappingTool;

public class OozieDBCLI {
    public static final String HELP_CMD = "help";
    public static final String VERSION_CMD = "version";
    public static final String CREATE_CMD = "create";
    public static final String UPGRADE_CMD = "upgrade";
    public static final String POST_UPGRADE_CMD = "postupgrade";
    public static final String SQL_FILE_OPT = "sqlfile";
    public static final String RUN_OPT = "run";
    public static final String[] HELP_INFO = new String[]{"", "IMPORTANT: If using an Oracle or MySQL Database, before running this", "tool copy the corresponding JDBC driver to the tools libext/ directory"};
    private boolean used = false;
    private static final String COORD_JOBS_THROTTLING_DEFAULT = "update COORD_JOBS set mat_throttling = 12";
    private static final String COORD_JOBS_ADD_APP_NAMESPACE = "update COORD_JOBS set app_namespace = 'uri:oozie:coordinator:0.1'";
    private static final String COORD_JOBS_STATUS_1 = "update COORD_JOBS set status = 'RUNNING', PENDING = 1 where id in ( select job_id from COORD_ACTIONS where job_id in ( select id from COORD_JOBS where status = 'SUCCEEDED') and(status != 'FAILED' and status != 'SUCCEEDED' and status != 'KILLED' and status != 'TIMEDOUT') )";
    private static final String COORD_JOBS_STATUS_2 = "update COORD_JOBS set status = 'RUNNING' where status = 'PREMATER'";
    private static final String COORD_ACTIONS_STATUS = "update COORD_ACTIONS set status = 'SUSPENDED' where id in( select A.id from COORD_ACTIONS A, WF_JOBS B where A.external_id = B.id and B.status = 'SUSPENDED' and A.status = 'RUNNING' )";
    private static final String WORKFLOW_STATUS_QUERY = "select count(*) from WF_JOBS where status IN ('RUNNING', 'SUSPENDED')";
    private static final String OOZIE_SYS_EXISTS = "select count(*) from OOZIE_SYS";
    private static final String DB_VERSION = "1";
    private static final String GET_OOZIE_DB_VERSION = "select data from OOZIE_SYS where name = 'db.version'";
    private static final String CREATE_OOZIE_SYS = "create table OOZIE_SYS (name varchar(100), data varchar(100))";
    private static final String SET_DB_VERSION = "insert into OOZIE_SYS (name, data) values ('db.version', '1')";
    private static final String SET_OOZIE_VERSION = "insert into OOZIE_SYS (name, data) values ('oozie.version', '" + BuildInfo.getBuildInfo().getProperty("build.version") + "')";
    private static final String GET_OOZIE_SYS_INFO = "select name, data from OOZIE_SYS order by name";

    public static void main(String[] args) {
        System.exit(new OozieDBCLI().run(args));
    }

    protected Options createUpgradeOptions() {
        Option sqlfile = new Option(SQL_FILE_OPT, true, "Generate SQL script instead creating/upgrading the DB schema");
        Option run = new Option(RUN_OPT, false, "Confirm the DB schema creation/upgrade");
        Options options = new Options();
        options.addOption(sqlfile);
        options.addOption(run);
        return options;
    }

    public synchronized int run(String[] args) {
        if (this.used) {
            throw new IllegalStateException("CLI instance already used");
        }
        this.used = true;
        CLIParser parser = new CLIParser("ooziedb.sh", HELP_INFO);
        parser.addCommand(HELP_CMD, "", "display usage for all commands or specified command", new Options(), false);
        parser.addCommand(VERSION_CMD, "", "show Oozie DB version information", new Options(), false);
        parser.addCommand(CREATE_CMD, "", "create Oozie DB schema", this.createUpgradeOptions(), false);
        parser.addCommand(UPGRADE_CMD, "", "upgrade Oozie DB", this.createUpgradeOptions(), false);
        parser.addCommand(POST_UPGRADE_CMD, "", "post upgrade Oozie DB", this.createUpgradeOptions(), false);
        try {
            System.out.println();
            CLIParser.Command command = parser.parse(args);
            if (command.getName().equals(HELP_CMD)) {
                parser.showHelp(command.getCommandLine());
            } else if (command.getName().equals(VERSION_CMD)) {
                this.showVersion();
            } else {
                if (!command.getCommandLine().hasOption(SQL_FILE_OPT) && !command.getCommandLine().hasOption(RUN_OPT)) {
                    throw new Exception("'-sqlfile <FILE>' or '-run' options must be specified");
                }
                CommandLine commandLine = command.getCommandLine();
                String sqlFile = commandLine.hasOption(SQL_FILE_OPT) ? commandLine.getOptionValue(SQL_FILE_OPT) : File.createTempFile("ooziedb-", ".sql").getAbsolutePath();
                boolean run = commandLine.hasOption(RUN_OPT);
                if (command.getName().equals(CREATE_CMD)) {
                    this.createDB(sqlFile, run);
                }
                if (command.getName().equals(UPGRADE_CMD)) {
                    this.upgradeDB(sqlFile, run);
                }
                if (command.getName().equals(POST_UPGRADE_CMD)) {
                    this.postUpgradeDB(sqlFile, run);
                }
                System.out.println();
                System.out.println("The SQL commands have been written to: " + sqlFile);
                if (!run) {
                    System.out.println();
                    System.out.println("WARN: The SQL commands have NOT been executed, you must use the '-run' option");
                    System.out.println();
                }
            }
            return 0;
        }
        catch (ParseException ex) {
            System.err.println("Invalid sub-command: " + ex.getMessage());
            System.err.println();
            System.err.println(parser.shortHelp());
            return 1;
        }
        catch (Exception ex) {
            System.err.println();
            System.err.println("Error: " + ex.getMessage());
            System.err.println();
            System.err.println("Stack trace for the error was (for debug purposes):");
            System.err.println("--------------------------------------");
            ex.printStackTrace(System.err);
            System.err.println("--------------------------------------");
            System.err.println();
            return 1;
        }
    }

    private Map<String, String> getJdbcConf() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        HashMap<String, String> jdbcConf = new HashMap<String, String>();
        jdbcConf.put("driver", conf.get("oozie.service.JPAService.jdbc.driver"));
        String url = conf.get("oozie.service.JPAService.jdbc.url");
        jdbcConf.put("url", url);
        jdbcConf.put("user", conf.get("oozie.service.JPAService.jdbc.username"));
        jdbcConf.put("password", conf.get("oozie.service.JPAService.jdbc.password"));
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new RuntimeException("Invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'");
        }
        dbType = dbType.substring(0, dbType.indexOf(":"));
        jdbcConf.put("dbtype", dbType);
        return jdbcConf;
    }

    private void createDB(String sqlFile, boolean run) throws Exception {
        this.validateConnection();
        this.validateDBSchema(false);
        this.verifyOozieSysTable(false);
        this.createUpgradeDB(sqlFile, run, true);
        this.createOozieSysTable(sqlFile, run);
        System.out.println();
        if (run) {
            System.out.println("Oozie DB has been created for Oozie version '" + BuildInfo.getBuildInfo().getProperty("build.version") + "'");
        }
        System.out.println();
    }

    private void upgradeDB(String sqlFile, boolean run) throws Exception {
        this.upgradeDBTo32(sqlFile, run);
    }

    private void upgradeDBTo32(String sqlFile, boolean run) throws Exception {
        this.validateConnection();
        this.validateDBSchema(true);
        this.verifyOozieSysTable(false);
        this.verifyDBState();
        this.createUpgradeDB(sqlFile, run, false);
        this.createOozieSysTable(sqlFile, run);
        this.postUpgradeTasks(sqlFile, run, false);
        this.ddlTweaks(sqlFile, run);
        if (run) {
            System.out.println();
            System.out.println("Oozie DB has been upgraded to Oozie version '" + BuildInfo.getBuildInfo().getProperty("build.version") + "'");
        }
        System.out.println();
    }

    private void postUpgradeDB(String sqlFile, boolean run) throws Exception {
        this.postUpgradeDBTo32(sqlFile, run);
    }

    private void postUpgradeDBTo32(String sqlFile, boolean run) throws Exception {
        this.validateConnection();
        this.validateDBSchema(true);
        this.verifyOozieSysTable(true);
        this.verifyOozieDBVersion();
        this.verifyDBState();
        this.postUpgradeTasks(sqlFile, run, true);
        if (run) {
            System.out.println();
            System.out.println("Post ugprade updates have been executed");
        }
        System.out.println();
    }

    private String getDBVendor() throws Exception {
        String url = this.getJdbcConf().get("url");
        String vendor = url.substring("jdbc:".length());
        vendor = vendor.substring(0, vendor.indexOf(":"));
        return vendor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpgradeTasks(String sqlFile, boolean run, boolean force) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        boolean skipUpdates = this.getDBVendor().equals("mysql");
        Connection conn = run ? this.createConnection() : null;
        try {
            Statement st;
            System.out.println("Post-upgrade COORD_JOBS new columns default values");
            writer.println("update COORD_JOBS set mat_throttling = 12;");
            if (run) {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.executeUpdate(COORD_JOBS_THROTTLING_DEFAULT);
                st.close();
            }
            writer.println("update COORD_JOBS set app_namespace = 'uri:oozie:coordinator:0.1';");
            if (run) {
                st = conn.createStatement();
                st.executeUpdate(COORD_JOBS_ADD_APP_NAMESPACE);
                st.close();
            }
            System.out.println("DONE");
            if (!skipUpdates || force) {
                System.out.println("Post-upgrade COORD_JOBS & COORD_ACTIONS status values");
                writer.println("update COORD_JOBS set status = 'RUNNING', PENDING = 1 where id in ( select job_id from COORD_ACTIONS where job_id in ( select id from COORD_JOBS where status = 'SUCCEEDED') and(status != 'FAILED' and status != 'SUCCEEDED' and status != 'KILLED' and status != 'TIMEDOUT') );");
                writer.println("update COORD_JOBS set status = 'RUNNING' where status = 'PREMATER';");
                writer.println("update COORD_ACTIONS set status = 'SUSPENDED' where id in( select A.id from COORD_ACTIONS A, WF_JOBS B where A.external_id = B.id and B.status = 'SUSPENDED' and A.status = 'RUNNING' );");
                if (run) {
                    st = conn.createStatement();
                    st.executeUpdate(COORD_JOBS_STATUS_1);
                    st.close();
                    st = conn.createStatement();
                    st.executeUpdate(COORD_JOBS_STATUS_2);
                    st.close();
                    st = conn.createStatement();
                    st.executeUpdate(COORD_ACTIONS_STATUS);
                    st.close();
                }
                System.out.println("DONE");
            } else {
                System.out.println("SKIPPING Post-upgrade of COORD_JOBS & COORD_ACTIONS status values,");
                System.out.println("         MySQL 5 does not support the update queries");
                System.out.println();
                System.out.println("         Oozie will be able to run jobs started before the upgrade,");
                System.out.println("         although those jobs may show different status names in their actions");
            }
            writer.close();
        }
        finally {
            if (run) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ddlTweaks(String sqlFile, boolean run) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        String dbVendor = this.getDBVendor();
        String ddlQuery = null;
        if (dbVendor.equals("derby")) {
            ddlQuery = "ALTER TABLE WF_ACTIONS ALTER COLUMN execution_path SET DATA TYPE VARCHAR(1024)";
        } else if (dbVendor.equals("oracle")) {
            ddlQuery = "ALTER TABLE WF_ACTIONS MODIFY (execution_path VARCHAR2(1024))";
        } else if (dbVendor.equals("mysql")) {
            ddlQuery = "ALTER TABLE WF_ACTIONS MODIFY execution_path VARCHAR(1024)";
        } else if (dbVendor.equals("postgresql")) {
            ddlQuery = "ALTER TABLE WF_ACTIONS ALTER COLUMN execution_path TYPE VARCHAR(1024)";
        }
        Connection conn = run ? this.createConnection() : null;
        try {
            System.out.println("Table 'WF_ACTIONS' column 'execution_path', length changed to 1024");
            writer.println(ddlQuery + ";");
            if (run) {
                conn.setAutoCommit(true);
                Statement st = conn.createStatement();
                st.executeUpdate(ddlQuery);
                st.close();
            }
            System.out.println("DONE");
            writer.close();
        }
        finally {
            if (run) {
                conn.close();
            }
        }
    }

    private Connection createConnection() throws Exception {
        Map<String, String> conf = this.getJdbcConf();
        Class.forName(conf.get("driver")).newInstance();
        return DriverManager.getConnection(conf.get("url"), conf.get("user"), conf.get("password"));
    }

    private void validateConnection() throws Exception {
        System.out.println("Validate DB Connection");
        try {
            this.createConnection().close();
            System.out.println("DONE");
        }
        catch (Exception ex) {
            throw new Exception("Could not connect to the database: " + ex.toString(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDBSchema(boolean exists) throws Exception {
        boolean schemaExists;
        System.out.println(exists ? "Check DB schema exists" : "Check DB schema does not exist");
        Connection conn = this.createConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(WORKFLOW_STATUS_QUERY);
            rs.next();
            rs.close();
            st.close();
            schemaExists = true;
        }
        catch (Exception ex) {
            schemaExists = false;
        }
        finally {
            conn.close();
        }
        if (schemaExists != exists) {
            throw new Exception("DB schema " + (exists ? "does not exist" : "exists"));
        }
        System.out.println("DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOozieSysTable(boolean exists) throws Exception {
        boolean tableExists;
        System.out.println(exists ? "Check OOZIE_SYS table exists" : "Check OOZIE_SYS table does not exist");
        Connection conn = this.createConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(OOZIE_SYS_EXISTS);
            rs.next();
            rs.close();
            st.close();
            tableExists = true;
        }
        catch (Exception ex) {
            tableExists = false;
        }
        finally {
            conn.close();
        }
        if (tableExists != exists) {
            throw new Exception("OOZIE SYS table " + (exists ? "does not exist" : "exists"));
        }
        System.out.println("DONE");
    }

    private void verifyOozieDBVersion() throws Exception {
        System.out.println("Verify Oozie DB version");
        Connection conn = this.createConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(GET_OOZIE_DB_VERSION);
            if (rs.next()) {
                String version = rs.getString(1);
                if (!DB_VERSION.equals(version.trim())) {
                    throw new Exception("ERROR: Expected Oozie DB version '1', found '" + version.trim() + "'");
                }
            } else {
                throw new Exception("ERROR: Could not find Oozie DB 'db.version' in OOZIE_SYS table");
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new Exception("ERROR: Could not query OOZIE_SYS table: " + ex.toString(), ex);
        }
        finally {
            conn.close();
        }
        System.out.println("DONE");
    }

    private void createOozieSysTable(String sqlFile, boolean run) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter(sqlFile, true));
        writer.println();
        writer.println(CREATE_OOZIE_SYS);
        writer.println(SET_DB_VERSION);
        writer.println(SET_OOZIE_VERSION);
        writer.close();
        System.out.println("Create OOZIE_SYS table");
        if (run) {
            Connection conn = this.createConnection();
            try {
                conn.setAutoCommit(true);
                Statement st = conn.createStatement();
                st.executeUpdate(CREATE_OOZIE_SYS);
                st.executeUpdate(SET_DB_VERSION);
                st.executeUpdate(SET_OOZIE_VERSION);
                st.close();
            }
            catch (Exception ex) {
                throw new Exception("Could not create OOZIE_SYS table: " + ex.toString(), ex);
            }
            finally {
                conn.close();
            }
        }
        System.out.println("DONE");
    }

    private void showOozieSysInfo() throws Exception {
        Connection conn = this.createConnection();
        try {
            System.out.println();
            System.out.println("Oozie DB Version Information");
            System.out.println("--------------------------------------");
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(GET_OOZIE_SYS_INFO);
            while (rs.next()) {
                System.out.println(rs.getString(1) + ": " + rs.getString(2));
            }
            System.out.println("--------------------------------------");
            System.out.println();
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new Exception("ERROR querying OOZIE_SYS table: " + ex.toString(), ex);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDBState() throws Exception {
        System.out.println("Verify there are not active Workflow Jobs");
        Connection conn = this.createConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(WORKFLOW_STATUS_QUERY);
            rs.next();
            long activeWorkflows = rs.getLong(1);
            rs.close();
            st.close();
            if (activeWorkflows > 0L) {
                throw new Exception("There are [" + activeWorkflows + "] workflows in RUNNING/SUSPENDED state, they must complete or be killed");
            }
            System.out.println("DONE");
        }
        finally {
            conn.close();
        }
    }

    private String[] createMappingToolArguments(String sqlFile) throws Exception {
        Map<String, String> conf = this.getJdbcConf();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-schemaAction");
        args.add("add");
        args.add("-p");
        args.add("persistence.xml#oozie-" + conf.get("dbtype"));
        args.add("-connectionDriverName");
        args.add(conf.get("driver"));
        args.add("-connectionURL");
        args.add(conf.get("url"));
        args.add("-connectionUserName");
        args.add(conf.get("user"));
        args.add("-connectionPassword");
        args.add(conf.get("password"));
        if (sqlFile != null) {
            args.add("-sqlFile");
            args.add(sqlFile);
        }
        args.add("org.apache.oozie.client.rest.JsonWorkflowJob");
        args.add("org.apache.oozie.WorkflowJobBean");
        args.add("org.apache.oozie.client.rest.JsonWorkflowAction");
        args.add("org.apache.oozie.WorkflowActionBean");
        args.add("org.apache.oozie.client.rest.JsonCoordinatorJob");
        args.add("org.apache.oozie.CoordinatorJobBean");
        args.add("org.apache.oozie.client.rest.JsonCoordinatorAction");
        args.add("org.apache.oozie.CoordinatorActionBean");
        args.add("org.apache.oozie.client.rest.JsonSLAEvent");
        args.add("org.apache.oozie.SLAEventBean");
        args.add("org.apache.oozie.client.rest.JsonBundleJob");
        args.add("org.apache.oozie.BundleJobBean");
        args.add("org.apache.oozie.BundleActionBean");
        args.add("org.apache.oozie.util.db.ValidateConnectionBean");
        return args.toArray(new String[args.size()]);
    }

    private void createUpgradeDB(String sqlFile, boolean run, boolean create) throws Exception {
        System.out.println(create ? "Create SQL schema" : "Upgrade SQL schema");
        String[] args = this.createMappingToolArguments(sqlFile);
        MappingTool.main((String[])args);
        if (run) {
            args = this.createMappingToolArguments(null);
            MappingTool.main((String[])args);
        }
        System.out.println("DONE");
    }

    private void showVersion() throws Exception {
        System.out.println("Oozie DB tool version: " + BuildInfo.getBuildInfo().getProperty("build.version"));
        System.out.println();
        this.validateConnection();
        this.validateDBSchema(true);
        try {
            this.verifyOozieSysTable(true);
        }
        catch (Exception ex) {
            throw new Exception("ERROR: It seems this Oozie DB was never upgraded with the 'ooziedb' tool");
        }
        this.showOozieSysInfo();
    }
}

