/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.hadoop.MapReduceMain;

public class StreamingMain
extends MapReduceMain {
    public static void main(String[] args) throws Exception {
        StreamingMain.run(StreamingMain.class, (String[])args);
    }

    protected RunningJob submitJob(Configuration actionConf) throws Exception {
        String[] values;
        JobConf jobConf = new JobConf();
        jobConf.set("mapred.mapper.class", "org.apache.hadoop.streaming.PipeMapper");
        jobConf.set("mapred.reducer.class", "org.apache.hadoop.streaming.PipeReducer");
        jobConf.set("mapred.map.runner.class", "org.apache.hadoop.streaming.PipeMapRunner");
        jobConf.set("mapred.input.format.class", "org.apache.hadoop.mapred.TextInputFormat");
        jobConf.set("mapred.output.format.class", "org.apache.hadoop.mapred.TextOutputFormat");
        jobConf.set("mapred.output.value.class", "org.apache.hadoop.io.Text");
        jobConf.set("mapred.output.key.class", "org.apache.hadoop.io.Text");
        jobConf.set("mapred.create.symlink", "yes");
        jobConf.set("mapred.used.genericoptionsparser", "true");
        jobConf.set("stream.addenvironment", "");
        String value = actionConf.get("oozie.streaming.mapper");
        if (value != null) {
            jobConf.set("stream.map.streamprocessor", value);
        }
        if ((value = actionConf.get("oozie.streaming.reducer")) != null) {
            jobConf.set("stream.reduce.streamprocessor", value);
        }
        if ((value = actionConf.get("oozie.streaming.record-reader")) != null) {
            jobConf.set("stream.recordreader.class", value);
        }
        for (String s : values = StreamingMain.getStrings((Configuration)actionConf, (String)"oozie.streaming.record-reader-mapping")) {
            String[] kv = s.split("=");
            jobConf.set("stream.recordreader." + kv[0], kv[1]);
        }
        values = StreamingMain.getStrings((Configuration)actionConf, (String)"oozie.streaming.env");
        value = jobConf.get("stream.addenvironment", "");
        if (value.length() > 0) {
            value = value + " ";
        }
        for (String s : values) {
            value = value + s + " ";
        }
        jobConf.set("stream.addenvironment", value);
        this.addActionConf(jobConf, actionConf);
        if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            jobConf.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        JobClient jobClient = null;
        RunningJob runJob = null;
        boolean exception = false;
        try {
            jobClient = this.createJobClient(jobConf);
            runJob = jobClient.submitJob(jobConf);
        }
        catch (Exception ex) {
            exception = true;
            throw ex;
        }
        finally {
            try {
                if (jobClient != null) {
                    jobClient.close();
                }
            }
            catch (Exception ex) {
                if (exception) {
                    System.out.println("JobClient Error: " + ex);
                }
                throw ex;
            }
        }
        return runJob;
    }
}

