/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.PropertyConfigurator;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.sqoop.Sqoop;

public class SqoopMain
extends LauncherMain {
    public static final String SQOOP_SITE_CONF = "sqoop-site.xml";
    private static final Pattern[] SQOOP_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Job complete: (job_\\S*)"), Pattern.compile("Job (job_\\S*) completed successfully")};
    private static final String SQOOP_LOG4J_PROPS = "sqoop-log4j.properties";

    public static void main(String[] args) throws Exception {
        SqoopMain.run(SqoopMain.class, (String[])args);
    }

    private static Configuration initActionConf() {
        Configuration sqoopConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        sqoopConf.addResource(new Path("file:///", actionXml));
        String delegationToken = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (delegationToken != null) {
            sqoopConf.set("mapreduce.job.credentials.binary", delegationToken);
            System.out.println("------------------------");
            System.out.println("Setting env property for mapreduce.job.credentials.binary to: " + delegationToken);
            System.out.println("------------------------");
            System.setProperty("mapreduce.job.credentials.binary", delegationToken);
        } else {
            System.out.println("Non-Kerberos execution");
        }
        return sqoopConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration setUpSqoopSite() throws Exception {
        Configuration sqoopConf = SqoopMain.initActionConf();
        FileOutputStream os = new FileOutputStream(SQOOP_SITE_CONF);
        try {
            sqoopConf.writeXml((OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
        System.out.println();
        System.out.println("Sqoop Configuration Properties:");
        System.out.println("------------------------");
        for (Map.Entry entry : sqoopConf) {
            System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        System.out.flush();
        System.out.println("------------------------");
        System.out.println();
        return sqoopConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setUpSqoopLog4J(Configuration sqoopConf) throws IOException {
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system property not set");
        }
        String logFile = new File("sqoop-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        Properties hadoopProps = new Properties();
        URL log4jFile = Thread.currentThread().getContextClassLoader().getResource("log4j.properties");
        if (log4jFile != null) {
            hadoopProps.load(log4jFile.openStream());
        }
        String logLevel = sqoopConf.get("oozie.sqoop.log.level", "INFO");
        hadoopProps.setProperty("log4j.logger.org.apache.sqoop", logLevel + ", A");
        hadoopProps.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        hadoopProps.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        hadoopProps.setProperty("log4j.appender.A.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        hadoopProps.setProperty("log4j.appender.jobid", "org.apache.log4j.FileAppender");
        hadoopProps.setProperty("log4j.appender.jobid.file", logFile);
        hadoopProps.setProperty("log4j.appender.jobid.layout", "org.apache.log4j.PatternLayout");
        hadoopProps.setProperty("log4j.appender.jobid.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        hadoopProps.setProperty("log4j.logger.org.apache.hadoop.mapred", "INFO, jobid");
        hadoopProps.setProperty("log4j.logger.org.apache.hadoop.mapreduce.Job", "INFO, jobid");
        String localProps = new File(SQOOP_LOG4J_PROPS).getAbsolutePath();
        FileOutputStream os1 = new FileOutputStream(localProps);
        try {
            hadoopProps.store(os1, "");
        }
        finally {
            ((OutputStream)os1).close();
        }
        PropertyConfigurator.configure((String)SQOOP_LOG4J_PROPS);
        return logFile;
    }

    protected void run(String[] args) throws Exception {
        String logFile;
        block4: {
            System.out.println();
            System.out.println("Oozie Sqoop action configuration");
            System.out.println("=================================================================");
            Configuration sqoopConf = SqoopMain.setUpSqoopSite();
            logFile = SqoopMain.setUpSqoopLog4J(sqoopConf);
            String[] sqoopArgs = MapReduceMain.getStrings((Configuration)sqoopConf, (String)"oozie.sqoop.args");
            if (sqoopArgs == null) {
                throw new RuntimeException("Action Configuration does not have [oozie.sqoop.args] property");
            }
            System.out.println("Sqoop command arguments :");
            for (String arg : sqoopArgs) {
                System.out.println("             " + arg);
            }
            LauncherMainHadoopUtils.killChildYarnJobs((Configuration)sqoopConf);
            System.out.println("=================================================================");
            System.out.println();
            System.out.println(">>> Invoking Sqoop command line now >>>");
            System.out.println();
            System.out.flush();
            try {
                this.runSqoopJob(sqoopArgs);
            }
            catch (SecurityException ex) {
                if (!LauncherSecurityManager.getExitInvoked() || LauncherSecurityManager.getExitCode() == 0) break block4;
                throw ex;
            }
        }
        System.out.println();
        System.out.println("<<< Invocation of Sqoop command completed <<<");
        System.out.println();
        Properties jobIds = SqoopMain.getHadoopJobIds((String)logFile, (Pattern[])SQOOP_JOB_IDS_PATTERNS);
        File file = new File(System.getProperty("oozie.action.externalChildIDs"));
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).write(jobIds.getProperty("hadoopJobs").getBytes());
        ((OutputStream)os).close();
        System.out.println(" Hadoop Job IDs executed by Sqoop: " + jobIds.getProperty("hadoopJobs"));
        System.out.println();
    }

    protected void runSqoopJob(String[] args) throws Exception {
        Sqoop.main((String[])args);
    }
}

