/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainHadoopUtils;
import org.apache.spark.deploy.SparkSubmit;

public class SparkMain
extends LauncherMain {
    private static final String MASTER_OPTION = "--master";
    private static final String MODE_OPTION = "--deploy-mode";
    private static final String JOB_NAME_OPTION = "--name";
    private static final String CLASS_NAME_OPTION = "--class";
    private static final String VERBOSE_OPTION = "--verbose";
    private static final String DELIM = " ";

    public static void main(String[] args) throws Exception {
        SparkMain.run(SparkMain.class, (String[])args);
    }

    protected void run(String[] args) throws Exception {
        String sparkOpts;
        Configuration actionConf = SparkMain.loadActionConf();
        SparkMain.setYarnTag((Configuration)actionConf);
        LauncherMainHadoopUtils.killChildYarnJobs((Configuration)actionConf);
        ArrayList<String> sparkArgs = new ArrayList<String>();
        sparkArgs.add(MASTER_OPTION);
        sparkArgs.add(actionConf.get("oozie.spark.master"));
        String sparkDeployMode = actionConf.get("oozie.spark.mode");
        if (sparkDeployMode != null) {
            sparkArgs.add(MODE_OPTION);
            sparkArgs.add(sparkDeployMode);
        }
        sparkArgs.add(JOB_NAME_OPTION);
        sparkArgs.add(actionConf.get("oozie.spark.name"));
        String className = actionConf.get("oozie.spark.class");
        if (className != null) {
            sparkArgs.add(CLASS_NAME_OPTION);
            sparkArgs.add(className);
        }
        if (StringUtils.isNotEmpty((String)(sparkOpts = actionConf.get("oozie.spark.spark-opts")))) {
            String[] sparkOptions;
            for (String opt : sparkOptions = sparkOpts.split(DELIM)) {
                sparkArgs.add(opt);
            }
        }
        if (!sparkArgs.contains(VERBOSE_OPTION)) {
            sparkArgs.add(VERBOSE_OPTION);
        }
        String jarPath = actionConf.get("oozie.spark.jar");
        sparkArgs.add(jarPath);
        for (String arg : args) {
            sparkArgs.add(arg);
        }
        System.out.println("Spark Action Main class        : " + SparkSubmit.class.getName());
        System.out.println();
        System.out.println("Oozie Spark action configuration");
        System.out.println("=================================================================");
        System.out.println();
        for (String arg : sparkArgs) {
            System.out.println("                    " + arg);
        }
        System.out.println();
        this.runSpark(sparkArgs.toArray(new String[sparkArgs.size()]));
    }

    private void runSpark(String[] args) throws Exception {
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Spark class now >>>");
        System.out.println();
        System.out.flush();
        SparkSubmit.main((String[])args);
    }
}

